/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.provision.preference.ProvisionPreference;
import netjfwatcher.provisionlog.gui.treenode.IProvisionLogTreeNode;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTree;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;
import netjfwatcher.provisionlog.gui.treeview.AbstractProvisionLogNodeTreeView;
import netjfwatcher.provisionlog.gui.treeview.ProvisionLogNodeTreeViewSorter;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/**
 * SSH2 m[hTree ViewɂANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderNodeTree extends Action {
	/* MO */
	private static Logger logger = null;

	/*
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	private HashMap nodeIconImageMap = new HashMap();

	/* TreeViewer */
	private TreeViewer provisionLogNodeTreeViewer;

	/* Xe[^XC}l[W擾pView */
	private AbstractProvisionLogNodeTreeView nodeTreeView;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* Composite */
	private Composite parentComposite;

	/* NodeTreeGroup */
	private ProvisionLogNodeTreeGroup nodeTreeGroupRoot;

	private Image fileObjImage;

	/*
	 * GroupǗMapGroupɑ݂Ă邩AVK Group쐬邩̔fɎgp
	 */
	private HashMap groupMap = new HashMap();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private IAction reloadNodeTreeDatabase = new ActionReloadNodeTree();

	private IAction sortNodeTreeDatabase = new ActionSortNodeTreeDatabase();

	private IAction actionRemoveProvisionLogFile = new ActionRemoveProvisionLogFile();

	/**
	 * m[hTree ViewɂANVNXCX^X 𐶐܂B
	 * 
	 */
	public ActionBuilderNodeTree() {
		logger = Logger.getLogger(this.getClass().getName());
		createLogNodeIconImage();
	}

	public ActionBuilderNodeTree(AbstractProvisionLogNodeTreeView nodeTreeView,
			TreeViewer nodeListTreeViewer, Composite parentComposite,
			ProvisionLogNodeTreeGroup nodeTreeGroupRoot) {
		logger = Logger.getLogger(this.getClass().getName());
		this.nodeTreeView = nodeTreeView;
		this.provisionLogNodeTreeViewer = nodeListTreeViewer;
		this.parentComposite = parentComposite;
		this.nodeTreeGroupRoot = nodeTreeGroupRoot;
		createLogNodeIconImage();
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeListTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return provisionLogNodeTreeViewer;
	}

	/**
	 * m[hTreeǂݍ݃ANVԂ܂B
	 * 
	 * @return reloadNodeTree m[hTreeǂݍ݃ANV
	 */
	public IAction actionReloadNodeTreeDatabase() {
		return reloadNodeTreeDatabase;
	}

	/**
	 * m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeDatabase m[hTree\[gANV
	 */
	public IAction actionSortNodeTreeDatabase() {
		return sortNodeTreeDatabase;
	}

	public IAction getActionRemoveProvisionLogFile() {
		return actionRemoveProvisionLogFile;
	}

	public void createNodeTree(final boolean isSortDirectionTreeView) {

		File fleDir = new File(ProvisionPreference.PROVISION_LOG_DIR);
		File[] fileList = fleDir.listFiles();
		if (fileList != null) {
			for (int fileCount = 0; fileCount < fileList.length; fileCount++) {
				if (fileList[fileCount].isDirectory()) {

					/* 擾GroupVȖȌꍇGroupVK쐬 */
					ProvisionLogNodeTreeGroup logNodeTreeGroup = null;

					String group = fileList[fileCount].getName();

					if (groupMap.containsKey(group)) {
						/* 擾Groupɑ݂ꍇɂ́AGroup擾 */
						logNodeTreeGroup = (ProvisionLogNodeTreeGroup) groupMap
								.get(group);
					} else {
						/* 擾GroupVȖȌꍇGroupVK쐬 */
						logNodeTreeGroup = new ProvisionLogNodeTreeGroup(group);

						/* m[hTree RootGroupǉ */
						nodeTreeGroupRoot.addChild(logNodeTreeGroup);
						groupMap.put(group, logNodeTreeGroup);
					}
					nodeTreeGroupRoot.addChild(logNodeTreeGroup);

				} else {
					if (fileList[fileCount].isFile()) {

						nodeTreeGroupRoot.addChild(new ProvisionLogNodeTree(
								fileList[fileCount].getName(),
								fileList[fileCount].getName(),
								fileList[fileCount], fileObjImage));

					}

				}
			}
		}

		/* TreeView\[g */
		provisionLogNodeTreeViewer
				.setSorter(new ProvisionLogNodeTreeViewSorter() {

					public int compare(Viewer viewer, Object e1, Object e2) {

						int cat1 = category(e1);
						int cat2 = category(e2);
						if (cat1 != cat2) {
							return cat1 - cat2;
						}

						// cat1 == cat2
						String name1;
						String name2;

						if ((viewer == null)
								|| !(viewer instanceof ContentViewer)) {
							name1 = e1.toString();
							name2 = e2.toString();
						} else {
							IBaseLabelProvider prov = ((ContentViewer) viewer)
									.getLabelProvider();

							if (prov instanceof ILabelProvider) {
								ILabelProvider lprov = (ILabelProvider) prov;
								name1 = lprov.getText(e1);
								name2 = lprov.getText(e2);
							} else {
								name1 = e1.toString();
								name2 = e2.toString();
							}
						}

						if (name1 == null) {
							name1 = ""; //$NON-NLS-1$
						}

						if (name2 == null) {
							name2 = ""; //$NON-NLS-1$
						}

						if (isSortDirectionTreeView) {
							// \[g
							return collator.compare(name1, name2);
						}

						// ~\[g
						return collator.compare(name2, name1);
					}
				});

		provisionLogNodeTreeViewer.expandAll();
		provisionLogNodeTreeViewer.refresh();
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 * @param groupNo
	 *            O[v
	 * @param nodeNo
	 *            m[h
	 */
	protected void setStatusLine(int groupNo, int nodeNo) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (nodeTreeView.getViewSite()
				.getActionBars().getStatusLineManager());

		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Node Tree View " + "Group count="
				+ groupNo + " Node count=" + nodeNo);
	}

	/**
	 * m[hTreȇIm[hԂ܂B
	 * 
	 * @return node m[h
	 */
	public IProvisionLogTreeNode getNodeBase() {
		// TreeIm[ho
		IStructuredSelection selectElement = (IStructuredSelection) getViewer()
				.getSelection();
		IProvisionLogTreeNode node = (IProvisionLogTreeNode) selectElement
				.getFirstElement();

		if (node == null) {
			node = (IProvisionLogTreeNode) getViewer().getInput();
		}

		return node;
	}

	/**
	 * m[hO[vԂ܂B
	 * 
	 * @param node
	 *            m[h
	 * @return baseNodeGroup m[hO[v
	 */
	public ProvisionLogNodeTreeGroup setNodeGroupBase(IProvisionLogTreeNode node) {
		ProvisionLogNodeTreeGroup baseNodeGroup = null;

		if (node != null) {
			baseNodeGroup = node.getParent();
		}

		if (node instanceof ProvisionLogNodeTreeGroup) {
			baseNodeGroup = (ProvisionLogNodeTreeGroup) node;
		}

		return baseNodeGroup;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			ProvisionLogNodeTreeGroup baseNodeGroup = null;

			IProvisionLogTreeNode node = getNodeBase();
			baseNodeGroup = setNodeGroupBase(node);

			doTask(baseNodeGroup, node);
		}

		/**
		 * ANVs^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected abstract void doTask(ProvisionLogNodeTreeGroup group,
				IProvisionLogTreeNode node);

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Provision Log Tree reload";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Provision Log Tree reload";
		}
	}

	public final class ActionReloadNodeTree extends AbstractNodeAction {

		protected void doTask(ProvisionLogNodeTreeGroup group,
				IProvisionLogTreeNode node) {
			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		public void setNodeTree() {
			createNodeTree(true);
		}
	}

	/**
	 * m[h\[gANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractNodeSortAction extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(MenuPreference.NODE_TREE_SORT_IMAGE_FILE));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Provision Log Tree sort";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Provision Log Tree sort";
		}
	}

	/**
	 * m[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortNodeTreeDatabase extends
			AbstractNodeSortAction {

		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(ProvisionLogNodeTreeGroup group,
				IProvisionLogTreeNode node) {
			if (isSortToggle) {

				isSortToggle = false;
			} else {

				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				ProvisionLogNodeTreeGroup nodeTreeGroup = (ProvisionLogNodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					ProvisionLogNodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof ProvisionLogNodeTreeGroup) {
						parentNodeTreeGroup = (ProvisionLogNodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		protected void setNodeTree() {

			createNodeTree(isSortToggle);

		}
	}

	private void createLogNodeIconImage() {

		String logNodeFileImageName = "icons/file_obj.gif";
		fileObjImage = null;

		Display display = parentComposite.getDisplay();

		URL url = null;
		url = bundle.getEntry(logNodeFileImageName);
		if (url == null) {
			/* Icon\[Xt@CȂꍇMO̎ */
			logger.severe("Not found icon file : " + logNodeFileImageName);
		} else {
			try {
				/* m[hIconC[W */
				fileObjImage = new Image(display, url.openStream());

			} catch (IOException e) {
				logger.warning("Abort create image " + e.getMessage() + " for "
						+ logNodeFileImageName);
				e.printStackTrace();
			}
		}

	}

	public final class ActionRemoveProvisionLogFile extends AbstractNodeAction {

		private IProvisionLogTreeNode provisionLogNodeTree;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/remove_exc.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Remove Provision Log File";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Remove Provision Log File";
		}

		protected void doTask(ProvisionLogNodeTreeGroup group,
				IProvisionLogTreeNode node) {

			openEditor();
		}

		public void openEditor() {

			if (provisionLogNodeTree instanceof ProvisionLogNodeTree) {

				File logFile = provisionLogNodeTree.getFile();
				logFile.delete();

			} else if (provisionLogNodeTree instanceof ProvisionLogNodeTreeGroup) {

			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();

			createNodeTree(true);

		}

		public void setProvisionLogNodeTree(
				IProvisionLogTreeNode provisionLogNodeTree) {
			this.provisionLogNodeTree = provisionLogNodeTree;
		}
	}
}
