/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.treenode;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ProvisionLogNodeTreeGroup extends AbstractProvisionLogTreeNode {
	/*
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * m[hTree groupɏm[hTreẽm[hi[HashSet
	 */
	private Set childrenHashSet = new HashSet();

	/**
	 * Provisionm[hTreeɂm[hO[vƂȂTreem[hNX CX^X𐶐܂B
	 * 
	 */
	public ProvisionLogNodeTreeGroup() {
	}

	/**
	 * Provisionm[hTreeɂm[hO[vƂȂTreem[hNX CX^XO[vw肵Đ܂B
	 * 
	 * @param name
	 *            m[hO[v
	 */
	public ProvisionLogNodeTreeGroup(String name) {
		setName(name);
	}

	/**
	 * Provisionm[hTree groupɏm[hTreẽm[hzŕԂ܂B
	 * 
	 * @return INodeTreeNode[]
	 */
	public IProvisionLogTreeNode[] getChildren() {
		return (IProvisionLogTreeNode[]) childrenHashSet
				.toArray(new IProvisionLogTreeNode[childrenHashSet.size()]);
	}

	/**
	 * Provisionm[hTree groupIconC[WԂ܂B
	 * 
	 * @return m[hTree groupIconC[W
	 */
	public Image getImage() {
		return PlatformUI.getWorkbench().getSharedImages().getImage(
				ISharedImages.IMG_OBJ_FOLDER);
	}

	/**
	 * Provisionm[hTree groupɃm[hTreẽm[ho^܂B
	 * 
	 * @param toAdd
	 *            o^m[hTreẽm[h
	 */
	public void addChild(IProvisionLogTreeNode toAdd) {
		childrenHashSet.add(toAdd);
		toAdd.setParent(this);
	}

	/**
	 * Childem[h݂邩Ԃ܂B
	 * 
	 * @return Childem[hݗL
	 */
	public boolean hasChildren() {
		return !childrenHashSet.isEmpty();
	}

	/**
	 * Provisionm[hTree groupɏw̃m[hTreẽm[h 폜܂B
	 * 
	 * @param toRemove
	 *            폜m[hTreẽm[h
	 */
	public void removeChild(IProvisionLogTreeNode toRemove) {
		childrenHashSet.remove(toRemove);
	}

	public File getFile() {
		return null;
	}
	/**
	 * SĂChildem[h폜܂B
	 * 
	 */
	public void removeChildAll() {
		childrenHashSet.clear();
	}
}
