/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.treeview;

import netjfwatcher.provisionlog.gui.action.ActionBuilderEditorsPartClose;
import netjfwatcher.provisionlog.gui.action.ActionBuilderNodeTree;
import netjfwatcher.provisionlog.gui.treenode.IProvisionLogTreeNode;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractProvisionLogNodeTreeView extends ViewPart {
	/** Node TreeANV */
	protected ActionBuilderNodeTree actionNodeTree;

	/** Editor PartɊւANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/** TreeViewer */
	protected TreeViewer provisionLogNodeTreeViewer;

	/**
	 * Node Tree Viewɂ郁o[yу\bh钊ۃNX CX^X𐶐܂B
	 * 
	 */
	public AbstractProvisionLogNodeTreeView() {
		// nothing
	}

	/**
	 * m[hTreeɊւANVԂ܂B
	 * 
	 * @return actionNodeTree m[hTreeɊւANV
	 */
	public ActionBuilderNodeTree getActionNodeTreeBuilder() {
		return actionNodeTree;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 * 
	 */
	public void setFocus() {
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return provisionLogNodeTreeViewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parentComposite
	 *            Composite
	 */
	public void createPartControl(Composite parentComposite) {
		/* Tree Viewer𐶐 */
		provisionLogNodeTreeViewer = new TreeViewer(parentComposite);
		provisionLogNodeTreeViewer.setUseHashlookup(true);
		provisionLogNodeTreeViewer
				.setContentProvider(new ProvisionLogNodeTreeViewContentProvider());
		provisionLogNodeTreeViewer
				.setLabelProvider(new ProvisionLogNodeTreeViewLabelProvider());

		/* SorterZbg */
		provisionLogNodeTreeViewer
				.setSorter(new ProvisionLogNodeTreeViewSorter());

		/* m[hTree Group̓f[^ƂăZbg */
		provisionLogNodeTreeViewer.setInput(createInitialInput());
		provisionLogNodeTreeViewer.expandAll();

		/* m[hTreeRoot擾 */
		IProvisionLogTreeNode nodeTreeNode = (IProvisionLogTreeNode) getViewer()
				.getInput();
		ProvisionLogNodeTreeGroup nodeTreeGroupRoot = nodeTreeNode.getParent();

		if (nodeTreeNode instanceof ProvisionLogNodeTreeGroup) {
			nodeTreeGroupRoot = (ProvisionLogNodeTreeGroup) nodeTreeNode;
		}

		/* m[hTreeANVZbg */
		actionNodeTree = new ActionBuilderNodeTree(this,
				provisionLogNodeTreeViewer, parentComposite, nodeTreeGroupRoot);

		/* m[hTree View̑IXi[ݒ */
		setupNodeTreeViewListener();

		/* Contextj[ */
		createContextMenu();

		/* ANV̏ƂToolBarݒ */
		setToolBarActions();

		/* \ݒ */
		initShow();
	}

	/**
	 * ̃m[hTreer[̏͐ݒl𐶐܂B
	 * 
	 * @return topInputDataObject
	 */
	protected Object createInitialInput() {
		/* m[hTreełtopm[h𐶐 */
		ProvisionLogNodeTreeGroup topInputDataObject = new RootOfRootNodeTreeGroup();

		return topInputDataObject;
	}

	/**
	 * m[hTree View̏\̂߂Ƀf[^擾A\ \bhłB
	 * 
	 */
	abstract protected void initShow();

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		provisionLogNodeTreeViewer
				.addSelectionChangedListener(new ProvisionLogNodeTreeListener());
	}

	/**
	 * m[hTree View̃j[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void setToolBarActions();

	/**
	 * m[hTree ViewContextj[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void createContextMenu();

	/**
	 * m[hTreeɂTopm[ĥ߂̃NXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected static final class RootOfRootNodeTreeGroup extends
			ProvisionLogNodeTreeGroup {
		/**
		 * em[hԂ܂B
		 * 
		 * @return em[h
		 */
		public ProvisionLogNodeTreeGroup getParent() {
			return null;
		}

		/**
		 * qm[h폜܂B
		 * 
		 * @param toRemove
		 *            m[h
		 */
		public void removeChild(IProvisionLogTreeNode toRemove) {
			// ROOT O[vȂ悤ɃI[o[Ch
		}
	}
}
