/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.treeview;

import java.io.File;
import java.util.logging.Logger;

import netjfwatcher.provision.gui.editor.EditorInputProvision;
import netjfwatcher.provision.gui.editor.EditorProvisionLogFileView;
import netjfwatcher.provision.info.ProvisionInfo;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTree;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * m[hTreeIXi[NXłB m[hTreeIɂAm[hViewuEUŕ\܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ProvisionLogNodeTreeListener implements ISelectionChangedListener {
	/* IWorkbenchPage */
	private static IWorkbenchPage activePage;

	private IEditorPart editorPart;

	/* MO */
	private static Logger logger = null;

	public ProvisionLogNodeTreeListener() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * e[uViewɃtB[hꗗőIGg͒lƂĐݒ ̃Cxg_@ƂWebɃANZX
	 * 
	 * @param event
	 *            SelectionChangedEvent
	 */
	public void selectionChanged(SelectionChangedEvent event) {

		StructuredSelection ss = (StructuredSelection) event.getSelection();

		if (!(ss.getFirstElement() instanceof ProvisionLogNodeTreeGroup)
				&& !(ss.getFirstElement() instanceof ProvisionLogNodeTree)) {

			return;
		}

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		if (editorPart != null) {

			activePage.closeEditor(editorPart, false);
			editorPart = null;
		}

		try {

			if (ss.getFirstElement() instanceof ProvisionLogNodeTree) {
				final ProvisionLogNodeTree entry = (ProvisionLogNodeTree) ss
						.getFirstElement();
				File logFile = entry.getFile();

				ProvisionInfo provisionInfo = new ProvisionInfo();
				provisionInfo.setLogFile(logFile);
				editorPart = activePage.openEditor(new EditorInputProvision(
						entry.getFileName()
								+ EditorProvisionLogFileView.TITLE_SUFFIX,
						provisionInfo, false), EditorProvisionLogFileView.class
						.getName());

			}
		} catch (PartInitException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}

	}
}
