/*
 * Created on 2007/01/10
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.provisionlog.gui.treeview;

import java.util.logging.Logger;

import netjfwatcher.provisionlog.gui.action.ActionBuilderNodeTree.ActionReloadNodeTree;
import netjfwatcher.provisionlog.gui.action.ActionBuilderNodeTree.ActionRemoveProvisionLogFile;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTree;
import netjfwatcher.provisionlog.gui.treenode.ProvisionLogNodeTreeGroup;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

public class ProvisionLogNodeTreeView extends AbstractProvisionLogNodeTreeView {

	private static Logger logger = null;

	public ProvisionLogNodeTreeView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	protected void initShow() {
		((ActionReloadNodeTree) actionNodeTree.actionReloadNodeTreeDatabase())
				.setNodeTree();

	}

	/**
	 * ReLXgj[𐶐܂B
	 * 
	 */
	public void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		Menu menu = mm.createContextMenu(provisionLogNodeTreeViewer
				.getControl());
		provisionLogNodeTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, provisionLogNodeTreeViewer);
	}

	/**
	 * ANV̏ƂToolBarݒ肵܂B
	 * 
	 */
	protected void setToolBarActions() {
		/* ToolBarݒ */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* m[hTreeēǍANV */
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionReloadNodeTreeDatabase());
		toolBarManager.add(getActionNodeTreeBuilder()
				.actionSortNodeTreeDatabase());
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B m[hTreẽm[hIĂꍇƑIĂȂꍇ
	 * j[ς܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(getActionNodeTreeBuilder().actionReloadNodeTreeDatabase());

		/* m[hTree\[g */
		manager.add(getActionNodeTreeBuilder().actionSortNodeTreeDatabase());

		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (provisionLogNodeTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = provisionLogNodeTreeViewer.getTree()
					.getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof ProvisionLogNodeTreeGroup) {
						/* GroupI */
						provisionLogNodeTreeViewer.getTree().deselectAll();

					} else if (treeItem[nodeTreeSelectNo].getData() instanceof ProvisionLogNodeTree) {
						ProvisionLogNodeTree nodeData = (ProvisionLogNodeTree) treeItem[nodeTreeSelectNo]
								.getData();

						((ActionRemoveProvisionLogFile) getActionNodeTreeBuilder().getActionRemoveProvisionLogFile())
								.setProvisionLogNodeTree(nodeData);

						manager.add(getActionNodeTreeBuilder()
								.getActionRemoveProvisionLogFile());
					} else {
						/* Groupłm[hłȂ */
						provisionLogNodeTreeViewer.getTree().deselectAll();
					}
				}
			} else {
				/* TreeI */

			}
		}

	}

	/**
	 * Provisionm[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Provision Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		provisionLogNodeTreeViewer
				.addSelectionChangedListener(new ProvisionLogNodeTreeListener());
	}
}
