/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.internal.menus.SLocation;

public abstract class MenuElement
extends HandleObject {
    private static final SLocation[] NO_LOCATIONS = new SLocation[0];
    public static final String PROPERTY_DEFINED = "DEFINED";
    public static final String PROPERTY_LOCATIONS = "LOCATIONS";
    public static final String PROPERTY_VISIBILITY = "VISIBILITY";
    protected SLocation[] locations;
    private Map windowToShowingMap = null;
    private Map windowToVisibleMap = null;

    public MenuElement(String id) {
        super(id);
    }

    public final void addListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    public boolean containsLocation(SLocation location) {
        if (this.locations != null && location != null) {
            int i = 0;
            while (i < this.locations.length) {
                if (location.equals(this.locations[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public final void addLocation(SLocation location) {
        SLocation[] newLocations;
        if (location == null) {
            throw new NullPointerException("The location cannot be null");
        }
        if (this.containsLocation(location)) {
            return;
        }
        if (this.locations == null || this.locations.length == 0) {
            newLocations = new SLocation[]{location};
        } else {
            newLocations = new SLocation[this.locations.length + 1];
            System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
            newLocations[this.locations.length] = location;
        }
        this.setLocations(newLocations);
    }

    protected final void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    protected final void fireVisibleChanged(boolean visible) {
        if (this.isListenerAttached()) {
            PropertyChangeEvent event = visible ? new PropertyChangeEvent((Object)this, PROPERTY_VISIBILITY, (Object)Boolean.FALSE, (Object)Boolean.TRUE) : new PropertyChangeEvent((Object)this, PROPERTY_VISIBILITY, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
            this.firePropertyChangeEvent(event);
        }
    }

    public final SLocation[] getLocations() throws NotDefinedException {
        if (!this.isDefined()) {
            throw new NotDefinedException("Cannot get the locations from an undefined menu element");
        }
        if (this.locations == null) {
            return NO_LOCATIONS;
        }
        SLocation[] result = new SLocation[this.locations.length];
        System.arraycopy(this.locations, 0, result, 0, this.locations.length);
        return result;
    }

    public final boolean isShowing(Window window) {
        if (this.windowToShowingMap != null) {
            Object value = this.windowToShowingMap.get(window);
            if (value == null) {
                value = this.windowToShowingMap.get(null);
            }
            if (value == Boolean.TRUE) {
                return true;
            }
        }
        return false;
    }

    public final boolean isVisible(Window window) {
        if (this.windowToVisibleMap != null) {
            Object value = this.windowToVisibleMap.get(window);
            if (value == null) {
                value = this.windowToVisibleMap.get(null);
            }
            if (value == Boolean.FALSE) {
                return false;
            }
        }
        return true;
    }

    public final void removeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    protected final void setDefined(boolean defined) {
        if (this.defined != defined) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_DEFINED, (Object)(this.defined ? Boolean.TRUE : Boolean.FALSE), (Object)(defined ? Boolean.TRUE : Boolean.FALSE));
            }
            this.defined = defined;
            this.firePropertyChangeEvent(event);
        }
    }

    protected final void setLocations(SLocation[] locations) {
        if (!Util.equals((Object[])this.locations, (Object[])locations)) {
            PropertyChangeEvent event = null;
            if (this.isListenerAttached()) {
                event = new PropertyChangeEvent((Object)this, PROPERTY_LOCATIONS, (Object)this.locations, (Object)locations);
            }
            this.locations = locations;
            this.firePropertyChangeEvent(event);
        }
    }

    final void setShowing(Window window, boolean showing) {
        if (window == null) {
            throw new NullPointerException("The window in which a menu element is showing must not be null");
        }
        if (this.windowToShowingMap == null) {
            this.windowToShowingMap = new WeakHashMap(3);
        }
        this.windowToShowingMap.put(window, showing ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void setVisible(Window window, boolean visible) {
        boolean initialVisible = this.isVisible(window);
        if (initialVisible != visible) {
            if (this.windowToVisibleMap == null) {
                this.windowToVisibleMap = new WeakHashMap(3);
            }
            this.windowToVisibleMap.put(window, visible ? Boolean.TRUE : Boolean.FALSE);
            this.fireVisibleChanged(visible);
        }
    }
}

