/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.ILocationElementTokenizer;
import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.LocationElementToken;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.misc.Policy;

public final class SBar
extends LeafLocationElement {
    public static final String TYPE_MENU = "menu";
    public static final String TYPE_TRIM = "trim";
    private final String type;

    public SBar() {
        this(TYPE_MENU, null);
    }

    public SBar(String path) {
        this(TYPE_MENU, path);
    }

    public SBar(String type, String path) {
        super(path);
        this.type = type;
    }

    public final LocationElement createChild(String id) {
        String parentPath = this.getPath();
        String path = parentPath == null ? id : String.valueOf(parentPath) + '/' + id;
        return new SBar(this.getType(), path);
    }

    public final ILocationElementTokenizer getTokenizer() {
        if (Policy.EXPERIMENTAL_MENU && this.getPath() != null && this.getPath().indexOf("org.eclipse.search.menu") > -1) {
            System.err.println("getTokenizer: " + this.getPath());
        }
        return new ILocationElementTokenizer(){
            String remainingPath;
            String parsedPath;
            {
                this.remainingPath = SBar.this.getPath();
                this.parsedPath = null;
            }

            public final LocationElementToken nextToken() {
                String id;
                SLocation location = new SLocation(new SBar(SBar.this.getType(), this.parsedPath));
                int separator = this.remainingPath.indexOf(47);
                if (separator == -1) {
                    id = this.remainingPath;
                    this.remainingPath = null;
                } else {
                    id = this.remainingPath.substring(0, separator);
                    this.remainingPath = this.remainingPath.substring(separator + 1);
                    if (this.remainingPath.length() == 0) {
                        this.remainingPath = null;
                    }
                }
                this.parsedPath = this.parsedPath == null ? id : String.valueOf(this.parsedPath) + '/' + id;
                return new LocationElementToken(location, id);
            }

            public final boolean hasMoreTokens() {
                return this.remainingPath != null;
            }
        };
    }

    public final String getType() {
        return this.type;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SBar(");
        buffer.append(this.type);
        buffer.append(',');
        buffer.append(this.getPath());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SBar) {
            SBar bar = (SBar)obj;
            return Util.equals((Object)this.type, (Object)bar.type) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((Object)this.type) + super.hashCode();
    }
}

