/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.control;

import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DataAccessObjectApacheDerby;
import netjfwatcher.database.access.control.DataAccessObjectAxion;
import netjfwatcher.database.access.control.DataAccessObjectHSQLDB;
import netjfwatcher.database.access.control.DataAccessObjectMySQL;
import netjfwatcher.database.access.control.DataAccessObjectOracle;
import netjfwatcher.database.access.control.DataAccessObjectPostgreSQL;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.ResourceInfo;

public final class DatabaseAccessControlKind {
    private static ResourceInfo resourceInfo = null;
    private static Logger logger = null;
    private AbstractDataAccessObject databaseAccessObject;
    private String databaseName;

    private DatabaseAccessControlKind() {
        logger = Logger.getLogger(this.getClass().getName());
        this.setDatabaseKindControl();
    }

    public void updateDatabaseKindControl() {
        SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
        resourceInfo = resourceset.getResourceInfo();
        this.setDatabaseKindControl();
    }

    private void setDatabaseKindControl() {
        String kind;
        if (resourceInfo == null) {
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            resourceInfo = resourceset.getResourceInfo();
        }
        this.databaseName = kind = resourceInfo.getDatabaseName();
        if (kind.equals("HSQLDB")) {
            this.databaseAccessObject = new DataAccessObjectHSQLDB();
        } else if (kind.equals("Apache Derby") || kind.equals("Embedded Derby")) {
            this.databaseAccessObject = new DataAccessObjectApacheDerby();
        } else if (kind.equals("MySQL")) {
            this.databaseAccessObject = new DataAccessObjectMySQL();
        } else if (kind.equals("Postgresql")) {
            this.databaseAccessObject = new DataAccessObjectPostgreSQL();
        } else if (kind.equals("Oracle")) {
            this.databaseAccessObject = new DataAccessObjectOracle();
        } else if (kind.equals("Axion")) {
            this.databaseAccessObject = new DataAccessObjectAxion();
        } else {
            logger.warning("Database Nosuport : " + kind);
        }
        logger.info("Database Kind : " + kind);
        this.databaseAccessObject.setDriver(resourceInfo.getDatabaseDriver());
        this.databaseAccessObject.setDatabaseurl(resourceInfo.getDatabaseUrl());
        this.databaseAccessObject.setUser(resourceInfo.getDatabaseUser());
        this.databaseAccessObject.setPassword(resourceInfo.getDatabasePassword());
    }

    public static DatabaseAccessControlKind getInstance() {
        return SingletonAboutMessage.DBKIND;
    }

    public static void setResource(ResourceInfo setResourceInfo) {
        resourceInfo = setResourceInfo;
    }

    public AbstractDataAccessObject getDataAccessObject() {
        return this.databaseAccessObject;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public static ResourceInfo getResourceInfo() {
        return resourceInfo;
    }

    /* synthetic */ DatabaseAccessControlKind(DatabaseAccessControlKind databaseAccessControlKind) {
        this();
    }

    private static class SingletonAboutMessage {
        static final DatabaseAccessControlKind DBKIND = new DatabaseAccessControlKind(null);

        private SingletonAboutMessage() {
        }
    }
}

