/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;

public final class DBTableAlarm
extends DBTableBase {
    public static final String ALARM_TABLE = "alarm_table";
    public static final String UNCONFIRM = "unconfirm";
    public static final String ALARM_ID = "id";
    public static final String NODENAME = "nodename";
    public static final String GROUP = "node_group";
    public static final String IPADDRESS = "ipaddress";
    public static final String ALARM_CODE = "alarm_code";
    public static final String ALARM_LEVEL = "alarm_level";
    public static final String ALARM_MESSAGE = "alarm_message";
    public static final String ALARM_CONFIRM = "alarm_confirm";
    public static final String ALARM_DATE = "alarm_date";
    public static final String ALL_NODE = "all";
    public static final String INIT_SORT_COLUMN = "id";
    public static final String INIT_SORT_DIRECTION = "desc";
    private static Logger logger = null;
    private final DateFormat simpleDateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DBTableAlarm() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static DBTableAlarm getInstance() {
        return SingletonResource.RESOURCE;
    }

    public synchronized void createTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
        try {
            this.deleteTable(databaseAccess, ALARM_TABLE);
        }
        catch (SQLException e) {
            logger.info(String.valueOf(DatabaseAccessControlKind.getInstance().getDatabaseName()) + " : " + e.getMessage());
        }
        try {
            this.dropSequence(databaseAccess, dataaccessobject.getDropAlarmTableSequenceSQL());
            databaseAccess.executeUpdate(dataaccessobject.getCreateAlarmTable());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized void dropTable() throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            AbstractDataAccessObject dataaccessobject = DatabaseAccessControlKind.getInstance().getDataAccessObject();
            this.deleteTable(databaseAccess, ALARM_TABLE);
            this.dropSequence(databaseAccess, dataaccessobject.getDropAlarmTableSequenceSQL());
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
    }

    public synchronized boolean putAlarm(String ipaddress, String nodename, String group, AlarmCodeInformation alarminfo, String message) throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            Date date = Calendar.getInstance().getTime();
            String alarmLevel = alarminfo.getLevel();
            String alarmCode = alarminfo.getCode();
            String alarmMessage = message;
            String alarmConfirm = UNCONFIRM;
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            String checkAlarmMessage = databaseKind.equals("HSQLDB") || databaseKind.equals("Postgresql") || databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby") ? "'" + alarmMessage.replaceAll("'", " ") + "'" : "\"" + alarmMessage + "\"";
            databaseAccess.executeUpdate("insert into alarm_table ( nodename, node_group, ipaddress, alarm_code, alarm_level, alarm_message, alarm_confirm, alarm_date ) VALUES( '" + nodename + "'," + "'" + group + "'," + "'" + ipaddress + "'," + "'" + alarmCode + "'," + "'" + alarmLevel + "'," + checkAlarmMessage + "," + "'" + alarmConfirm + "'," + " '" + this.simpleDateformat.format(date) + "'" + ")");
        }
        finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
        return true;
    }

    public synchronized ArrayList findAllAlarm(int limit, String selectIPAddress, String paraSortColumn, String paraSortDirection) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<AlarmInformation> alarmList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();
            ArrayList filterList = alarmFilterDBTable.findAll();
            String sql = this.createAlarmFilterSQL(selectIPAddress, paraSortColumn, paraSortDirection, filterList);
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            alarmList = new ArrayList<AlarmInformation>();
            int alarmCount = 0;
            while (rs.next()) {
                AlarmInformation alarmInfo = new AlarmInformation();
                alarmInfo.setNodename(rs.getObject(NODENAME).toString());
                alarmInfo.setGroup(rs.getObject(GROUP).toString());
                alarmInfo.setIpaddress(rs.getObject(IPADDRESS).toString());
                alarmInfo.setAlarmCode(rs.getObject(ALARM_CODE).toString());
                alarmInfo.setAlarmLevel(rs.getObject(ALARM_LEVEL).toString());
                alarmInfo.setAlarmMessage(rs.getObject(ALARM_MESSAGE).toString());
                alarmInfo.setAlarmConfirm(rs.getObject(ALARM_CONFIRM).toString());
                alarmInfo.setAlarmDate(rs.getObject(ALARM_DATE).toString());
                alarmInfo.setAlarmID(rs.getObject("id").toString());
                alarmList.add(alarmInfo);
                if (limit == 0 || ++alarmCount < limit) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return alarmList;
    }

    private String createAlarmFilterSQL(String selectIPAddress, String paraSortColumn, String paraSortDirection, ArrayList filterList) {
        String sortColumn = paraSortColumn == null ? "id" : paraSortColumn;
        String sortDirection = paraSortDirection == null ? INIT_SORT_DIRECTION : paraSortDirection;
        String alarmNodename = "";
        String alarmIPAddress = "";
        String alarmLevel = "";
        String alarmConfirm = "";
        String alarmStartDate = null;
        String alarmEndDate = null;
        String filterIPAddress = "";
        String filterNodename = "";
        String filterLevel = "";
        String filterConfirm = "";
        String filterStartDate = "";
        String filterEndDate = "";
        int i = 0;
        while (i < filterList.size()) {
            Date date;
            AlarmViewFilter alarmViewFilter = (AlarmViewFilter)filterList.get(i);
            alarmNodename = alarmViewFilter.getNodename();
            alarmIPAddress = alarmViewFilter.getIpaddress();
            alarmLevel = alarmViewFilter.getAlarmLevel();
            alarmConfirm = alarmViewFilter.getAlarmConfirm();
            if (!alarmViewFilter.getAlarmStartDate().equals("*")) {
                date = Calendar.getInstance().getTime();
                date.setTime(Long.parseLong(alarmViewFilter.getAlarmStartDate()));
                alarmStartDate = this.simpleDateformat.format(date);
            } else {
                alarmStartDate = "*";
            }
            if (!alarmViewFilter.getAlarmEndDate().equals("*")) {
                date = new Date(Long.parseLong(alarmViewFilter.getAlarmEndDate()));
                alarmEndDate = this.simpleDateformat.format(date);
            } else {
                alarmEndDate = "*";
            }
            ++i;
        }
        filterConfirm = alarmConfirm.equals("*") ? " where alarm_confirm != '*' " : " where alarm_confirm = '" + alarmConfirm + "' ";
        if (!alarmNodename.equals("*")) {
            filterNodename = " and nodename='" + alarmNodename + "' ";
        }
        if (!alarmLevel.equals("*")) {
            filterLevel = " and alarm_level='" + alarmLevel + "' ";
        }
        if (!selectIPAddress.equals(ALL_NODE)) {
            filterIPAddress = " and ipaddress='" + selectIPAddress + "' ";
        } else if (!alarmIPAddress.equals("*")) {
            filterIPAddress = " and ipaddress='" + alarmIPAddress + "' ";
        }
        if (!alarmStartDate.equals("*")) {
            filterStartDate = " and alarm_date >= '" + alarmStartDate + "' ";
        }
        if (!alarmEndDate.equals("*")) {
            filterEndDate = " and alarm_date <= '" + alarmEndDate + "' ";
        }
        String sql = "SELECT * from alarm_table" + filterConfirm + filterNodename + filterIPAddress + filterLevel + filterStartDate + filterEndDate + " order by " + sortColumn + " " + sortDirection;
        return sql;
    }

    public synchronized ArrayList getNodeAlarm(String selectIPAddress) throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<AlarmInformation> alarmList = null;
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            String sql = "SELECT * from alarm_table where alarm_confirm = 'unconfirm'  and ipaddress='" + selectIPAddress + "' " + " order by " + "id" + " " + INIT_SORT_DIRECTION;
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            alarmList = new ArrayList<AlarmInformation>();
            if (rs.next()) {
                AlarmInformation alarmInfo = new AlarmInformation();
                alarmInfo.setNodename(rs.getObject(NODENAME).toString());
                alarmInfo.setGroup(rs.getObject(GROUP).toString());
                alarmInfo.setIpaddress(rs.getObject(IPADDRESS).toString());
                alarmInfo.setAlarmCode(rs.getObject(ALARM_CODE).toString());
                alarmInfo.setAlarmLevel(rs.getObject(ALARM_LEVEL).toString());
                alarmInfo.setAlarmMessage(rs.getObject(ALARM_MESSAGE).toString());
                alarmInfo.setAlarmConfirm(rs.getObject(ALARM_CONFIRM).toString());
                alarmInfo.setAlarmDate(rs.getObject(ALARM_DATE).toString());
                alarmInfo.setAlarmID(rs.getObject("id").toString());
                alarmList.add(alarmInfo);
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                stmt = null;
            }
            if (conn != null && dataaccess != null) {
                dataaccess.releaseConnection(conn);
                conn = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
            dataaccess = null;
            throw throwable;
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
            stmt = null;
        }
        if (conn != null && dataaccess != null) {
            dataaccess.releaseConnection(conn);
            conn = null;
            DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
        }
        dataaccess = null;
        return alarmList;
    }

    public synchronized boolean updateAlarmIDConfirm(String ipaddress, String alarmID) throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            String sql = databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby") ? "UPDATE alarm_table set alarm_confirm = 'confirm' where id=" + alarmID + " and " + IPADDRESS + "=" + "'" + ipaddress + "'" : "UPDATE alarm_table set alarm_confirm = 'confirm' where id='" + alarmID + "'" + " and " + IPADDRESS + "=" + "'" + ipaddress + "'";
            dataaccess.executeUpdate(sql);
            return true;
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
            }
        }
    }

    public synchronized boolean updateAllAlarmIDConfirm(String ipaddress) throws DatabaseConnectionException, SQLException {
        DatabaseAccess dataaccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        try {
            ArrayList alarmList = null;
            alarmList = this.findAllAlarm(0, ipaddress, null, null);
            if (alarmList == null) {
                return false;
            }
            SystemResourceFileParse resourceset = SystemResourceConfig.getInstance().getResourceFileParse();
            String databaseKind = resourceset.getResourceInfo().getDatabaseName();
            String baseSql = "UPDATE alarm_table set alarm_confirm= 'confirm' where id=";
            if (databaseKind.equals("Apache Derby") || databaseKind.equals("Embedded Derby")) {
                int i = 0;
                while (i < alarmList.size()) {
                    AlarmInformation alarmConfirm = (AlarmInformation)alarmList.get(i);
                    String alarmID = alarmConfirm.getAlarmID();
                    String sql = String.valueOf(baseSql) + alarmID;
                    dataaccess.executeUpdate(sql);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < alarmList.size()) {
                    AlarmInformation alarmConfirm = (AlarmInformation)alarmList.get(i);
                    String alarmID = alarmConfirm.getAlarmID();
                    String sql = String.valueOf(baseSql) + "'" + alarmID + "'";
                    dataaccess.executeUpdate(sql);
                    ++i;
                }
            }
            return true;
        }
        finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(dataaccess);
                dataaccess = null;
            }
        }
    }

    /* synthetic */ DBTableAlarm(DBTableAlarm dBTableAlarm) {
        this();
    }

    private static class SingletonResource {
        static final DBTableAlarm RESOURCE = new DBTableAlarm(null);

        private SingletonResource() {
        }
    }
}

