/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;

public class ActionBuilderDataExport {
    private static Logger logger;
    private IAction exportAlarmAction = new ActionExportAlarm();
    private IAction exportSnmpStatisticsAction = new ActionExportSnmpStatisticsData();
    private IAction exportPingResponseAction = new ActionExportPingResponse();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderDataExport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public IAction getActionExportAlarm() {
        return this.exportAlarmAction;
    }

    public IAction getActionExportSnmpStatistics() {
        return this.exportSnmpStatisticsAction;
    }

    public IAction getActionExportPing() {
        return this.exportPingResponseAction;
    }

    protected void refreshNodeAlarmTable() {
    }

    private void writeCSVFile(String csvFile, Table table) {
        if (csvFile == null || csvFile.equals("") || table == null) {
            return;
        }
        FileOutputStream fo = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            try {
                fo = new FileOutputStream(csvFile);
                osw = new OutputStreamWriter(fo);
                bw = new BufferedWriter(osw);
                ArrayList tableDataList = this.getTableData(table);
                if (tableDataList != null) {
                    System.out.println("tableDataList.size() : " + tableDataList.size());
                    int j = 0;
                    while (j < tableDataList.size()) {
                        String[] tableData = (String[])tableDataList.get(j);
                        StringBuffer buf = new StringBuffer();
                        int k = 0;
                        while (k < tableData.length) {
                            System.out.println("data : " + tableData[k]);
                            buf.append(String.valueOf(tableData[k]) + ",");
                            ++k;
                        }
                        System.out.println("data buf : " + buf.toString());
                        bw.write(buf.toString());
                        bw.newLine();
                        bw.flush();
                        ++j;
                    }
                } else {
                    System.out.println("tableDataList null");
                }
            }
            catch (FileNotFoundException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Alarm List import error", (String)e.getMessage());
                logger.warning("Alarm List import error " + e.getMessage());
                e.printStackTrace();
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e2) {
                        logger.warning(e2.getMessage());
                        e2.printStackTrace();
                        return;
                    }
                }
                if (osw != null) {
                    try {
                        osw.close();
                    }
                    catch (IOException e3) {
                        logger.warning(e3.getMessage());
                        e3.printStackTrace();
                        return;
                    }
                }
                if (fo != null) {
                    try {
                        fo.close();
                    }
                    catch (IOException e4) {
                        logger.warning(e4.getMessage());
                        e4.printStackTrace();
                        return;
                    }
                }
                return;
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private ArrayList getTableData(Table table) {
        ArrayList<Object> tableDataList = new ArrayList<Object>();
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            tableDataList.add(items[i].getData());
            ++i;
        }
        return tableDataList;
    }

    private abstract class AbstractExportAction
    extends Action {
        private AbstractExportAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public class ActionExportAlarm
    extends AbstractExportAction {
        private Table table;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDataExport.this.bundle.getEntry("icons/export_wiz.gif"));
        }

        public String getText() {
            return "Export alarm table";
        }

        public String getToolTipText() {
            return "Alarm\u60c5\u5831\u3092CSV\u51fa\u529b\u3057\u307e\u3059";
        }

        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 8192);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);
            if (csvFile == null) {
                return;
            }
            ActionBuilderDataExport.this.writeCSVFile(csvFile, this.table);
        }

        public void setTable(Table table) {
            this.table = table;
        }
    }

    public class ActionExportPingResponse
    extends AbstractExportAction {
        private Table table;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDataExport.this.bundle.getEntry("icons/export_wiz.gif"));
        }

        public String getText() {
            return "Export ping response table";
        }

        public String getToolTipText() {
            return "Ping response data\u3092CSV\u51fa\u529b\u3057\u307e\u3059";
        }

        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 8192);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);
            if (csvFile == null) {
                return;
            }
            ActionBuilderDataExport.this.writeCSVFile(csvFile, this.table);
        }

        public void setTable(Table table) {
            this.table = table;
        }
    }

    public class ActionExportSnmpStatisticsData
    extends AbstractExportAction {
        private Table table;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderDataExport.this.bundle.getEntry("icons/export_wiz.gif"));
        }

        public String getText() {
            return "Export snmp statisticsdata table";
        }

        public String getToolTipText() {
            return "SNMP\u7d71\u8a08\u60c5\u5831\u3092CSV\u51fa\u529b\u3057\u307e\u3059";
        }

        protected void doTask() {
            Shell shell = new Shell();
            FileDialog openDialog = new FileDialog(shell, 8192);
            String csvFile = openDialog.open();
            logger.info("Open file name : " + csvFile);
            if (csvFile == null) {
                return;
            }
            ActionBuilderDataExport.this.writeCSVFile(csvFile, this.table);
        }

        public void setTable(Table table) {
            this.table = table;
        }
    }
}

