/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmp;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisricsSet;
import netjfwatcher.engine.view.editorpart.snmp.EditorSnmpStatisticsInfo;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderSnmp
extends Action {
    private static Logger logger;
    private IEditorPart editorNodeConfigView;
    private IAction snmpInfoShowAction = new ActionShowNodeSnmpView();
    private IAction snmpInfoShowActionSocket = new ActionShowNodeSnmpViewSocket();
    private IAction snmpStatisticsSetAction = new ActionSnmpStatisticsSet();
    private IAction snmpStatisticsSetActionSocket = new ActionSnmpStatisticsSetSocket();
    private IAction snmpStatisticsAction = new ActionSnmpStatistics();
    private IAction snmpStatisticsActionSocket = new ActionSnmpStatisticsSocket();
    private IAction snmpPrintAction = new ActionSnmpPrint();
    private IAction snmpPrintActionSocket = new ActionSnmpPrintSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderSnmp() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionSnmpInfo() {
        return this.snmpInfoShowAction;
    }

    public IAction getActionSnmpInfoSocket() {
        return this.snmpInfoShowActionSocket;
    }

    public IAction getActionSnmpStatisticsSet() {
        return this.snmpStatisticsSetAction;
    }

    public IAction getActionSnmpStatisticsSetSocket() {
        return this.snmpStatisticsSetActionSocket;
    }

    public IAction getActionSnmpStatistics() {
        return this.snmpStatisticsAction;
    }

    public IAction getActionSnmpStatisticsSocket() {
        return this.snmpStatisticsActionSocket;
    }

    public IAction getActionPrintSnmp() {
        return this.snmpPrintAction;
    }

    public IAction getActionPrintSnmpSocket() {
        return this.snmpPrintActionSocket;
    }

    private abstract class AbstractSnmpAction
    extends Action {
        private AbstractSnmpAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public class ActionShowNodeSnmpView
    extends AbstractSnmpAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmp.this.bundle.getEntry("icons/SnmpM.gif"));
        }

        public String getText() {
            return "Node Snmp";
        }

        public String getToolTipText() {
            return "Node Snmp";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp View", this.nodeInfo, false), EditorNodeSnmp.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionShowNodeSnmpViewSocket
    extends AbstractSnmpAction {
        private NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmp.this.bundle.getEntry("icons/SnmpM.gif"));
        }

        public String getText() {
            return "Node Snmp";
        }

        public String getToolTipText() {
            return "Node Snmp";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true), EditorNodeSnmp.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionSnmpStatisticsSet
    extends AbstractSnmpAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmp.this.bundle.getEntry("icons/table.gif"));
        }

        public String getText() {
            return "Node Snmp Statistics Set";
        }

        public String getToolTipText() {
            return "Node Snmp Statistics Set";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics set", this.nodeInfo, false, ""), EditorNodeSnmpStatisricsSet.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionSnmpStatisticsSetSocket
    extends ActionSnmpStatisticsSet {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Snmp Statistics set" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true, ""), EditorNodeSnmpStatisricsSet.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected class ActionSnmpStatistics
    extends AbstractSnmpAction {
        protected ActionSnmpStatistics() {
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmp.this.bundle.getEntry("icons/table.gif"));
        }

        public String getText() {
            return "Snmp Statistics";
        }

        public String getToolTipText() {
            return "Snmp Statistics";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(" Snmp Statistics Info View", false), EditorSnmpStatisticsInfo.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    protected class ActionSnmpStatisticsSocket
    extends ActionSnmpStatistics {
        protected ActionSnmpStatisticsSocket() {
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(" Snmp Statistics Info View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), true), EditorSnmpStatisticsInfo.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionSnmpPrint
    extends ActionShowNodeSnmpView {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderSnmp.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Printer Node Snmp";
        }

        public String getToolTipText() {
            return "Printer Node Snmp";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Printer Node View", this.nodeInfo, false), "netwatcher.printer.gui.editor.EditorPrinterNodeStatusView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public class ActionSnmpPrintSocket
    extends ActionSnmpPrint {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderSnmp.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderSnmp.this.editorNodeConfigView, false);
                ActionBuilderSnmp.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                ActionBuilderSnmp.this.editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Printer Node View", this.nodeInfo, true), "netwatcher.printer.gui.editor.EditorPrinterNodeStatusView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

