/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.nodecontrol;

import java.sql.SQLException;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.database.access.model.DBTablePrintMIB;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.database.access.model.DBTableSystemMIB;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.noderegister.snmp.NodeSnmpRegisterInitializeThread;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueDatabaseWatchControl;
import netjfwatcher.engine.server.protocol.control.ListQueueDefaultSnmpMibControl;
import netjfwatcher.engine.server.protocol.control.ListQueueHTTPControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePingControl;
import netjfwatcher.engine.server.protocol.control.ListQueuePopControl;
import netjfwatcher.engine.server.protocol.control.ListQueueSmtpControl;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.DatabaseWatcherInfo;
import netjfwatcher.engine.socket.info.NodeInformation;

public final class NodeAdd {
    private static Logger logger = null;
    private NodeWatchInfo nodewatchinfo;

    private NodeAdd() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void addNode(CommandInfo com) {
        logger = Logger.getLogger(this.getClass().getName());
        AlarmRecovery alarmRecovery = AlarmRecovery.getInstance();
        alarmRecovery.setArarmrecoveryCheck(com.getIpaddress());
        String ipaddress = com.getIpaddress();
        DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();
        DBTablePingResponse pingRes = DBTablePingResponse.getInstance();
        DBTableSystemMIB systemMib = DBTableSystemMIB.getInstance();
        DBTableInterfaceMIB interfaceMib = DBTableInterfaceMIB.getInstance();
        DBTablePrintMIB printMib = DBTablePrintMIB.getInstance();
        DBTableStatisticsMIBControl statisticsMibTable = DBTableStatisticsMIBControl.getInstance();
        try {
            try {
                nodeRegister.registerNode(com.getNodeInformation());
                pingRes.createTable(ipaddress);
                systemMib.createTable(ipaddress);
                interfaceMib.createTable(ipaddress);
                printMib.createTable(ipaddress);
                statisticsMibTable.createStatisticsMibConfigTable(ipaddress);
                statisticsMibTable.createStatisticsMibDataTable(ipaddress);
                statisticsMibTable.createMibInstanceTable(ipaddress);
            }
            catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            nodeRegister = null;
            pingRes = null;
            systemMib = null;
            interfaceMib = null;
            statisticsMibTable = null;
        }
        this.nodewatchinfo = new NodeWatchInfo();
        String snmpVersion = com.getNodeInformation().getSnmpVersion();
        if (snmpVersion.equals("SNMPV1")) {
            this.nodewatchinfo.setSnmpVersion(0);
        } else if (snmpVersion.equals("SNMPV2C")) {
            this.nodewatchinfo.setSnmpVersion(1);
        } else if (snmpVersion.equals("SNMPV3")) {
            this.nodewatchinfo.setSnmpVersion(3);
        } else {
            logger.warning("Bad snmp version : " + snmpVersion);
        }
        this.nodewatchinfo.setIpaddress(com.getNodeInformation().getIpaddress());
        this.nodewatchinfo.setNodename(com.getNodeInformation().getNodename());
        this.nodewatchinfo.setNodeKind(com.getNodeInformation().getNodeKind());
        this.nodewatchinfo.setPingPeriod(com.getNodeInformation().getPingPeriod());
        this.nodewatchinfo.setPingThreshold(com.getNodeInformation().getPingThreshold());
        this.nodewatchinfo.setSnmpPeriod(com.getNodeInformation().getSnmpPeriod());
        this.nodewatchinfo.setSnmpLevel(com.getNodeInformation().getSnmpLevel());
        this.nodewatchinfo.setSnmpROCommunity(com.getNodeInformation().getRoCommunity());
        this.nodewatchinfo.setSnmpRWCommunity(com.getNodeInformation().getRwCommunity());
        this.nodewatchinfo.setHttpUrl(com.getNodeInformation().getHttpUrl());
        this.nodewatchinfo.setHttpPeriod(com.getNodeInformation().getHttpPeriod());
        this.nodewatchinfo.setHttpTimeout(com.getNodeInformation().getHttpTimeout());
        this.nodewatchinfo.setPopPeriod(com.getNodeInformation().getPopPeriod());
        this.nodewatchinfo.setPopUser(com.getNodeInformation().getPopUser());
        this.nodewatchinfo.setPopPassword(com.getNodeInformation().getPopPassword());
        this.nodewatchinfo.setPopPort(com.getNodeInformation().getPopPort());
        this.nodewatchinfo.setPopTimeout(com.getNodeInformation().getPopTimeout());
        this.nodewatchinfo.setSmtpPeriod(com.getNodeInformation().getSmtpPeriod());
        this.nodewatchinfo.setSmtpPort(com.getNodeInformation().getSmtpPort());
        this.nodewatchinfo.setSmtpTimeout(com.getNodeInformation().getSmtpTimeout());
        this.nodewatchinfo.setSmtpTestAddress(com.getNodeInformation().getSmtpSendAddress());
        this.nodewatchinfo.setSmtpCheckPop3Host(com.getNodeInformation().getSmtpCheckHost());
        this.nodewatchinfo.setSmtpCheckPop3User(com.getNodeInformation().getSmtpCheckUser());
        this.nodewatchinfo.setSmtpCheckPop3Password(com.getNodeInformation().getSmtpCheckPassword());
        this.nodewatchinfo.setSmtpCheckPop3Port(com.getNodeInformation().getSmtpCheckPort());
        this.nodewatchinfo.setSmtpCheckPop3Timeout(com.getNodeInformation().getSmtpCheckTimeout());
        this.setThreadList(this.nodewatchinfo, true);
    }

    public void addNode(NodeInformation nodeInfomation, boolean isInitDatabaseTable) {
        logger = Logger.getLogger(this.getClass().getName());
        String ipaddress = nodeInfomation.getIpaddress();
        AlarmRecovery alarmRecovery = AlarmRecovery.getInstance();
        alarmRecovery.setArarmrecoveryCheck(ipaddress);
        if (isInitDatabaseTable) {
            DBTableNodeRegister nodeRegister = DBTableNodeRegister.getInstance();
            DBTablePingResponse pingRes = DBTablePingResponse.getInstance();
            DBTableSystemMIB systemMib = DBTableSystemMIB.getInstance();
            DBTableInterfaceMIB interfaceMib = DBTableInterfaceMIB.getInstance();
            DBTableStatisticsMIBControl statisticsMibTable = DBTableStatisticsMIBControl.getInstance();
            DBTablePrintMIB printMib = DBTablePrintMIB.getInstance();
            try {
                try {
                    nodeRegister.registerNode(nodeInfomation);
                    pingRes.createTable(ipaddress);
                    systemMib.createTable(ipaddress);
                    interfaceMib.createTable(ipaddress);
                    printMib.createTable(ipaddress);
                    statisticsMibTable.createStatisticsMibConfigTable(ipaddress);
                    statisticsMibTable.createStatisticsMibDataTable(ipaddress);
                    statisticsMibTable.createMibInstanceTable(ipaddress);
                }
                catch (DatabaseConnectionException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            finally {
                nodeRegister = null;
                pingRes = null;
                systemMib = null;
                interfaceMib = null;
                statisticsMibTable = null;
            }
        }
        this.nodewatchinfo = new NodeWatchInfo();
        String snmpVersion = nodeInfomation.getSnmpVersion();
        if (snmpVersion.equals("SNMPV1")) {
            this.nodewatchinfo.setSnmpVersion(0);
        } else if (snmpVersion.equals("SNMPV2C")) {
            this.nodewatchinfo.setSnmpVersion(1);
        } else if (snmpVersion.equals("SNMPV3")) {
            this.nodewatchinfo.setSnmpVersion(3);
        } else {
            logger.warning("Bad snmp version : " + snmpVersion);
        }
        logger.info("Snmp version : " + snmpVersion);
        this.nodewatchinfo.setIpaddress(nodeInfomation.getIpaddress());
        this.nodewatchinfo.setNodename(nodeInfomation.getNodename());
        this.nodewatchinfo.setNodeKind(nodeInfomation.getNodeKind());
        this.nodewatchinfo.setPingPeriod(nodeInfomation.getPingPeriod());
        this.nodewatchinfo.setPingThreshold(nodeInfomation.getPingThreshold());
        this.nodewatchinfo.setSnmpPeriod(nodeInfomation.getSnmpPeriod());
        this.nodewatchinfo.setSnmpLevel(nodeInfomation.getSnmpLevel());
        this.nodewatchinfo.setSnmpROCommunity(nodeInfomation.getRoCommunity());
        this.nodewatchinfo.setSnmpRWCommunity(nodeInfomation.getRwCommunity());
        this.nodewatchinfo.setHttpUrl(nodeInfomation.getHttpUrl());
        this.nodewatchinfo.setHttpPeriod(nodeInfomation.getHttpPeriod());
        this.nodewatchinfo.setHttpTimeout(nodeInfomation.getHttpTimeout());
        this.nodewatchinfo.setPopPeriod(nodeInfomation.getPopPeriod());
        this.nodewatchinfo.setPopUser(nodeInfomation.getPopUser());
        this.nodewatchinfo.setPopPassword(nodeInfomation.getPopPassword());
        this.nodewatchinfo.setPopPort(nodeInfomation.getPopPort());
        this.nodewatchinfo.setPopTimeout(nodeInfomation.getPopTimeout());
        this.nodewatchinfo.setSmtpPeriod(nodeInfomation.getSmtpPeriod());
        this.nodewatchinfo.setSmtpPort(nodeInfomation.getSmtpPort());
        this.nodewatchinfo.setSmtpTimeout(nodeInfomation.getSmtpTimeout());
        this.nodewatchinfo.setSmtpTestAddress(nodeInfomation.getSmtpSendAddress());
        this.nodewatchinfo.setSmtpCheckPop3Host(nodeInfomation.getSmtpCheckHost());
        this.nodewatchinfo.setSmtpCheckPop3User(nodeInfomation.getSmtpCheckUser());
        this.nodewatchinfo.setSmtpCheckPop3Password(nodeInfomation.getSmtpCheckPassword());
        this.nodewatchinfo.setSmtpCheckPop3Port(nodeInfomation.getSmtpCheckPort());
        this.nodewatchinfo.setSmtpCheckPop3Timeout(nodeInfomation.getSmtpCheckTimeout());
        this.nodewatchinfo.setDatabaseWatcherInfo(nodeInfomation.getDatabaseWatcherInfo());
        this.setThreadList(this.nodewatchinfo, isInitDatabaseTable);
    }

    private void setThreadList(NodeWatchInfo nodewatchinfo, boolean isInitDatabaseTable) {
        DatabaseWatcherInfo databaseWatcherInfo;
        NodeWatchInfo nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(nodewatchinfo.getIpaddress());
        if (nodeInfo == null) {
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
            nodeInfo = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(nodewatchinfo.getIpaddress());
            nodeInfo.setSystemMIBStatus("Pending");
            nodeInfo.setInterfaceMIBStatus("Pending");
            nodeInfo.setStatisticsMIBStatus("Pending");
            nodeInfo.setPrintMIBStatus("Pending");
            nodeInfo.setIpaddress(nodewatchinfo.getIpaddress());
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
        } else {
            nodewatchinfo.setSystemMIBStatus("Pending");
            nodewatchinfo.setInterfaceMIBStatus("Pending");
            nodewatchinfo.setStatisticsMIBStatus("Pending");
            nodewatchinfo.setPrintMIBStatus("Pending");
            nodewatchinfo.setIpaddress(nodewatchinfo.getIpaddress());
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
        }
        String ipaddress = nodewatchinfo.getIpaddress();
        String nodeName = nodewatchinfo.getNodename();
        int version = nodewatchinfo.getSnmpVersion();
        String roCommunity = nodewatchinfo.getSnmpROCommunity();
        String pingPeriod = nodewatchinfo.getPingPeriod();
        String threshHold = nodewatchinfo.getPingThreshold();
        int pingPeriodData = 0;
        if (!pingPeriod.equals("--")) {
            try {
                pingPeriodData = Integer.parseInt(pingPeriod);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("ping period : " + pingPeriod);
            }
        }
        if (pingPeriodData > 0) {
            NodeWatchInfo info = new NodeWatchInfo();
            info.setPingPeriod(pingPeriod);
            info.setSnmpROCommunity(roCommunity);
            info.setPingThreshold(threshHold);
            info.setIpaddress(ipaddress);
            info.setNodename(nodeName);
            ListQueuePingControl.getInstance().setPingNode(ipaddress, info);
        }
        this.setSNMPThread(isInitDatabaseTable, nodewatchinfo, ipaddress, nodeName, version, roCommunity);
        int httpPeriod = 0;
        try {
            httpPeriod = Integer.parseInt(nodewatchinfo.getHttpPeriod());
        }
        catch (NumberFormatException e) {
            logger.warning("http period " + e.getMessage());
        }
        if (httpPeriod > 0) {
            NodeWatchInfo info = new NodeWatchInfo();
            info.setIpaddress(ipaddress);
            info.setNodename(nodeName);
            info.setHttpPeriod(nodewatchinfo.getHttpPeriod());
            info.setHttpTimeout(nodewatchinfo.getHttpTimeout());
            info.setHttpUrl(nodewatchinfo.getHttpUrl());
            ListQueueHTTPControl.getInstance().setHTTPNode(ipaddress, info);
        }
        int popPeriod = 0;
        try {
            popPeriod = Integer.parseInt(nodewatchinfo.getPopPeriod());
        }
        catch (NumberFormatException e) {
            logger.warning("pop period " + e.getMessage());
        }
        if (popPeriod > 0) {
            NodeWatchInfo info = new NodeWatchInfo();
            info.setIpaddress(ipaddress);
            info.setNodename(nodeName);
            info.setPopPeriod(nodewatchinfo.getPopPeriod());
            info.setPopUser(nodewatchinfo.getPopUser());
            info.setPopPassword(nodewatchinfo.getPopPassword());
            info.setPopPort(nodewatchinfo.getPopPort());
            info.setPopTimeout(nodewatchinfo.getPopTimeout());
            ListQueuePopControl.getInstance().setPop3Node(ipaddress, info);
        }
        int smtpPeriod = 0;
        try {
            smtpPeriod = Integer.parseInt(nodewatchinfo.getSmtpPeriod());
        }
        catch (NumberFormatException e) {
            logger.warning("http period " + e.getMessage());
        }
        if (smtpPeriod > 0) {
            NodeWatchInfo info = new NodeWatchInfo();
            info.setIpaddress(ipaddress);
            info.setNodename(nodeName);
            info.setSmtpPeriod(nodewatchinfo.getSmtpPeriod());
            info.setSmtpPort(nodewatchinfo.getSmtpPort());
            info.setSmtpTimeout(nodewatchinfo.getSmtpTimeout());
            info.setSmtpTestAddress(nodewatchinfo.getSmtpTestAddress());
            info.setSmtpCheckPop3Host(nodewatchinfo.getSmtpCheckPop3Host());
            info.setSmtpCheckPop3User(nodewatchinfo.getSmtpCheckPop3User());
            info.setSmtpCheckPop3Password(nodewatchinfo.getSmtpCheckPop3Password());
            info.setSmtpCheckPop3Port(nodewatchinfo.getSmtpCheckPop3Port());
            info.setSmtpCheckPop3Timeout(nodewatchinfo.getSmtpCheckPop3Timeout());
            ListQueueSmtpControl.getInstance().setSmtpNode(ipaddress, info);
        }
        if ((databaseWatcherInfo = nodewatchinfo.getDatabaseWatcherInfo()) != null) {
            String databaseInfoPeriod = databaseWatcherInfo.getWatcherPeriod();
            int databaseInfoPeriodData = 0;
            if (databaseInfoPeriod == null || !databaseInfoPeriod.equals("--")) {
                try {
                    databaseInfoPeriodData = Integer.parseInt(databaseInfoPeriod);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.warning("database watch period : " + databaseInfoPeriod);
                }
            }
            if (databaseInfoPeriodData > 0) {
                NodeWatchInfo info = new NodeWatchInfo();
                info.setIpaddress(ipaddress);
                info.setNodename(nodeName);
                info.setDatabaseWatcherInfo(nodewatchinfo.getDatabaseWatcherInfo());
                ListQueueDatabaseWatchControl.getInstance().setDatabaseNode(ipaddress, info);
            }
        }
    }

    private void setSNMPThread(boolean isInitDatabaseTable, NodeWatchInfo nodewatchinfo, String ipaddress, String nodeName, int version, String roCommunity) {
        StatisticsMibInfo mibInfo;
        int snmpLevel = 0;
        try {
            snmpLevel = Integer.parseInt(nodewatchinfo.getSnmpLevel());
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("SNMP level : " + snmpLevel);
        }
        int snmpPeriod = 0;
        if (!nodewatchinfo.getSnmpPeriod().equals("--")) {
            try {
                snmpPeriod = Integer.parseInt(nodewatchinfo.getSnmpPeriod());
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("SNMP period : " + nodewatchinfo.getSnmpPeriod());
            }
        }
        if (snmpPeriod == 0) {
            return;
        }
        if (snmpLevel > 0) {
            nodewatchinfo.setSystemMIBStatus("Pending");
            nodewatchinfo.setInterfaceMIBStatus("Pending");
            nodewatchinfo.setPrintMIBStatus("Pending");
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
            if (isInitDatabaseTable) {
                Thread thread = new Thread(new NodeSnmpRegisterInitializeThread(ipaddress, version, snmpPeriod, roCommunity, snmpLevel, nodewatchinfo.getNodeKind()));
                thread.setDaemon(true);
                thread.setName("SNMP Init Thread : " + ipaddress);
                thread.start();
            } else {
                nodewatchinfo.setSystemMIBStatus("OK");
                nodewatchinfo.setInterfaceMIBStatus("OK");
                nodewatchinfo.setStatisticsMIBStatus("OK");
                nodewatchinfo.setPrintMIBStatus("OK");
                BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodewatchinfo);
            }
            NodeWatchInfo info2 = new NodeWatchInfo();
            info2.setSnmpVersion(version);
            info2.setSnmpPeriod(nodewatchinfo.getSnmpPeriod());
            info2.setSnmpROCommunity(roCommunity);
            info2.setIpaddress(ipaddress);
            info2.setNodename(nodeName);
            info2.setNodeKind(nodewatchinfo.getNodeKind());
            ListQueueDefaultSnmpMibControl.getInstance().setDefaultSnmpNode(ipaddress, info2);
        }
        if (snmpLevel == 2) {
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setNodeName(nodeName);
            mibInfo.setVersion(version);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.2.1.2.2.1.10", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setNodeName(nodeName);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.2.1.2.2.1.16", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
        }
        if (snmpLevel == 3) {
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setNodeName(nodeName);
            mibInfo.setVersion(version);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.4.1.2021.10.1.3", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
        }
        if (snmpLevel == 4) {
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setNodeName(nodeName);
            mibInfo.setVersion(version);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.6", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.7", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
            mibInfo = StatisticsMibInfo.getInstance(ipaddress);
            mibInfo.setCommunity(roCommunity);
            mibInfo.setOidList("1.3.6.1.4.1.2021.9.1.8", nodewatchinfo.getSnmpPeriod(), "0", "");
            ListQueueStatisticsMibControl.getInstance().setStatisticsMibGetNode(ipaddress, mibInfo);
        }
    }

    public static NodeAdd getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ NodeAdd(NodeAdd nodeAdd) {
        this();
    }

    private static class SingletonResource {
        static final NodeAdd RESOURCE = new NodeAdd(null);

        private SingletonResource() {
        }
    }
}

