/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.MediaResource;
import org.osgi.framework.Bundle;

public final class NodeDetectFile {
    private static Logger logger;

    private NodeDetectFile() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public HashMap getNodeDetectMap() {
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
        String fileName = "resources/nodeDetect.data";
        HashMap<String, String> nodeDectMap = new HashMap<String, String>();
        int cnt = 0;
        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                String lineString;
                URL url = this.getDocumentURL(fileName);
                instream = url.openStream();
                instreamReader = new InputStreamReader(instream);
                bufReader = new BufferedReader(instreamReader);
                while ((lineString = bufReader.readLine()) != null) {
                    if (lineString.indexOf("#") >= 0) continue;
                    Pattern pattern = Pattern.compile("=");
                    String[] sysDescJudgeArray = pattern.split(lineString);
                    try {
                        if (sysDescJudgeArray.length != 2) {
                            logger.info(lineString);
                        } else {
                            logger.info("SysDesc strcat string = " + sysDescJudgeArray[0]);
                            logger.info("Node Kind = " + sysDescJudgeArray[1]);
                            if (nodeIconMap.containsKey(sysDescJudgeArray[1])) {
                                nodeDectMap.put(sysDescJudgeArray[0], sysDescJudgeArray[1]);
                            } else {
                                logger.warning("Not found node kind = " + sysDescJudgeArray[1]);
                            }
                        }
                    }
                    catch (Exception e1) {
                        logger.warning(lineString);
                        e1.printStackTrace();
                    }
                    ++cnt;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instreamReader != null) {
                try {
                    instreamReader.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
        return nodeDectMap;
    }

    public URL getDocumentURL(String fileName) {
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);
        if (url == null) {
            logger.severe("sysDesc defined file : " + fileName);
        }
        return url;
    }

    public static NodeDetectFile getInstance() {
        return SingletonResource.INSTANCE;
    }

    /* synthetic */ NodeDetectFile(NodeDetectFile nodeDetectFile) {
        this();
    }

    private static class SingletonResource {
        static final NodeDetectFile INSTANCE = new NodeDetectFile(null);

        private SingletonResource() {
        }
    }
}

