/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.bit.SnmpBitString;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpUnknownObject;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpNSAPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpobject.opaque.SnmpOpaque;

public class SnmpSequence
extends AbstractSnmpObject {
    protected List sequenceList;
    protected List sequenceContentsList = Collections.synchronizedList(new ArrayList());

    public SnmpSequence() {
        this.sequenceList = Collections.synchronizedList(new ArrayList());
        this.tag = (byte)48;
        this.tagDescription = "SEQUENCE";
    }

    public SnmpSequence(List contentList) throws SnmpBadValueException {
        Iterator e = contentList.iterator();
        while (e.hasNext()) {
            if (e.next() instanceof AbstractSnmpObject) continue;
            throw new SnmpBadValueException("Non-SNMPObject supplied to SNMPSequence.");
        }
        this.sequenceList = contentList;
        this.tag = (byte)48;
        this.tagDescription = "SEQUENCE";
    }

    public SnmpSequence(byte[] enc) throws SnmpBadValueException {
        this.extractFromBEREncoding(enc);
        this.tag = (byte)48;
        this.tagDescription = "SEQUENCE";
    }

    public Object getValue() {
        return this.sequenceList;
    }

    public void setTLV(SNMPTLV nextTLV) throws SnmpBadValueException {
        this.extractFromBEREncoding(nextTLV.getValue());
    }

    public void setValue(Object newSequence) throws SnmpBadValueException {
        if (newSequence instanceof List) {
            Iterator e = ((List)newSequence).iterator();
            while (e.hasNext()) {
                if (e.next() instanceof AbstractSnmpObject) continue;
                throw new SnmpBadValueException("Non-SNMPObject supplied to SNMPSequence.");
            }
        } else {
            throw new SnmpBadValueException(" Sequence: bad object supplied to set value ");
        }
        this.sequenceList = (List)newSequence;
    }

    public int size() {
        return this.sequenceList.size();
    }

    public void addSNMPObject(AbstractSnmpObject newObject) {
        this.sequenceList.add(this.sequenceList.size(), newObject);
    }

    public void addSNMPObject(AbstractSnmpObject newObject, int index) {
        this.sequenceList.remove(index);
        this.sequenceList.add(index, newObject);
    }

    public void clearSNMPObjectList() {
        this.sequenceList.clear();
    }

    public AbstractSnmpObject getSNMPObjectAt(int index) {
        return (AbstractSnmpObject)this.sequenceList.get(index);
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outWork = null;
        try {
            byte[] data = this.encodeContentsList();
            byte[] len = this.encodeLength(data.length);
            outBytes.write(this.tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);
            outWork = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outWork;
    }

    private byte[] encodeContentsList() {
        ByteArrayOutputStream outStreamBytes = new ByteArrayOutputStream();
        byte[] outBytes = null;
        try {
            int numElements = this.sequenceList.size();
            int i = 0;
            while (i < numElements) {
                byte[] nextBytes = ((AbstractSnmpObject)this.sequenceList.get(i)).getBEREncoding();
                outStreamBytes.write(nextBytes, 0, nextBytes.length);
                ++i;
            }
            outBytes = outStreamBytes.toByteArray();
        }
        finally {
            try {
                outStreamBytes.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outBytes;
    }

    protected void extractFromBEREncoding(byte[] enc) throws SnmpBadValueException {
        List<AbstractSnmpObject> newContentsList = Collections.synchronizedList(new ArrayList());
        int totalLength = enc.length;
        int position = 0;
        this.sequenceContentsList.clear();
        while (position < totalLength) {
            SNMPTLV nextTLV = this.extractNextTLV(enc, position);
            if (nextTLV != null) {
                this.sequenceContentsList.add(this.extractNextTLV(enc, position));
                newContentsList.add(newContentsList.size(), this.extractEncoding(nextTLV));
                position += nextTLV.getTotalLength();
                continue;
            }
            ++position;
        }
        this.sequenceList = newContentsList;
    }

    public List getSequenceContentsList() {
        return this.sequenceContentsList;
    }

    public AbstractSnmpObject extractEncoding(SNMPTLV theTLV) throws SnmpBadValueException {
        switch (theTLV.getTag()) {
            case 2: {
                return new SnmpInteger(theTLV.getValue());
            }
            case 48: {
                return new SnmpSequence(theTLV.getValue());
            }
            case 6: {
                return new SnmpObjectIdentifier(theTLV.getValue());
            }
            case 4: {
                return new SnmpOctetString(theTLV.getValue());
            }
            case 64: {
                return new SnmpIPAddress(theTLV.getValue());
            }
            case 65: {
                return new SnmpCounter32(theTLV.getValue());
            }
            case 66: {
                return new SnmpGauge32(theTLV.getValue());
            }
            case 67: {
                return new SnmpTimeTicks(theTLV.getValue());
            }
            case 69: {
                return new SnmpNSAPAddress(theTLV.getValue());
            }
            case 70: {
                return new SnmpCounter64(theTLV.getValue());
            }
            case 71: {
                return new SnmpUInteger32(theTLV.getValue());
            }
            case -96: 
            case -95: 
            case -94: 
            case -93: {
                return new SnmpPDU(theTLV.getValue(), theTLV.getTag());
            }
            case -92: {
                return new SnmpTrapPDU(theTLV.getValue());
            }
            case -89: {
                return new SnmpTrap2PDU(theTLV.getValue());
            }
            case 68: {
                System.out.println("SNMPOPAQUE_TAG : " + theTLV.getTag());
                return new SnmpOpaque(theTLV.getValue());
            }
            case 3: {
                System.out.println("SNMPBITSTRING_TAG : " + theTLV.getTag());
                return new SnmpBitString(theTLV.getValue());
            }
            case -88: 
            case 5: {
                return new SnmpPDU(theTLV.getValue(), theTLV.getTag());
            }
        }
        System.out.println("Unrecognized tag : " + theTLV.getTag());
        return new SnmpUnknownObject(theTLV.getValue());
    }

    public String toString() {
        String valueString = "(";
        int i = 0;
        while (i < this.sequenceList.size()) {
            valueString = String.valueOf(valueString) + " " + ((AbstractSnmpObject)this.sequenceList.get(i)).toString() + " ";
            ++i;
        }
        valueString = String.valueOf(valueString) + ")";
        return valueString;
    }
}

