/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.util.logging.Logger;
import netjfwatcher.snmpagent.AbstractAgentView;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AgentCommunicationMonitorView
extends AbstractAgentView {
    public static final int AGENT_MONITOR_TIMER = 1000;
    private static Logger logger;
    private Text moniterText;
    private Display display;
    private TimerProcessorThread timerProcessor;
    private Button monitorResetButton;
    private Button startButton;
    private Button stopButton;

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.display = parent.getDisplay();
        this.timerProcessor = new TimerProcessorThread();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite(parent, 0);
        gridData = new GridData();
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.monitorResetButton = new Button(composite, 2048);
        this.monitorResetButton.setText("Reset");
        this.startButton = new Button(composite, 2048);
        this.startButton.setText("Start");
        this.stopButton = new Button(composite, 2048);
        this.stopButton.setText("Stop");
        GridLayout gridLayout2 = new GridLayout(1, true);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)gridLayout2);
        this.moniterText = new Text(composite2, 2626);
        this.moniterText.setText("");
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.moniterText.setLayoutData((Object)gridData);
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.monitorResetButton.setEnabled(true);
        this.monitorResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AgentCommunicationMonitorView.logger = Logger.getLogger(this.getClass().getName());
                AgentCommunicationMonitorView.this.moniterText.setText("");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                logger.info("Snmp Agent monitor start");
                AgentMonitorMessageQueue.getInstance().setMonitor(true);
                AgentCommunicationMonitorView.this.display.timerExec(1000, (Runnable)AgentCommunicationMonitorView.this.timerProcessor);
                AgentCommunicationMonitorView.this.startButton.setEnabled(false);
                AgentCommunicationMonitorView.this.stopButton.setEnabled(true);
                AgentCommunicationMonitorView.this.monitorResetButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                logger.info("Snmp Agent monitor stop");
                AgentMonitorMessageQueue.getInstance().setMonitor(false);
                AgentCommunicationMonitorView.this.display.timerExec(-1, (Runnable)AgentCommunicationMonitorView.this.timerProcessor);
                AgentCommunicationMonitorView.this.startButton.setEnabled(true);
                AgentCommunicationMonitorView.this.stopButton.setEnabled(false);
                AgentCommunicationMonitorView.this.monitorResetButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public Display getDisplay() {
        return this.display;
    }

    public TimerProcessorThread getTimerProcessor() {
        return this.timerProcessor;
    }

    public class TimerProcessorThread
    implements Runnable {
        public void run() {
            String message = (String)AgentMonitorMessageQueue.getInstance().popAgentMessage();
            while (message != null) {
                AgentCommunicationMonitorView.this.moniterText.append(String.valueOf(message) + System.getProperty("line.separator"));
                AgentCommunicationMonitorView.this.moniterText.append(System.getProperty("line.separator"));
                message = (String)AgentMonitorMessageQueue.getInstance().popAgentMessage();
            }
            AgentCommunicationMonitorView.this.display.timerExec(1000, (Runnable)this);
        }
    }
}

