/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import java.util.logging.Logger;
import netjfwatcher.snmpmanager.SnmpManagerQueue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SnmpManagerMonitorView
extends ViewPart {
    public static final int TIMER = 1000;
    private static Logger logger;
    private Text moniterText;
    private Display display;
    private Button resetButton;
    private Button startButton;
    private Button stopButton;
    private TimerProcessor timerProcessor;

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.timerProcessor = new TimerProcessor();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite(parent, 0);
        gridData = new GridData();
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.resetButton = new Button(composite, 2048);
        this.resetButton.setText("Reset");
        this.startButton = new Button(composite, 2048);
        this.startButton.setText("Start");
        this.stopButton = new Button(composite, 2048);
        this.stopButton.setText("Stop");
        GridLayout gridLayout2 = new GridLayout(1, true);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)gridLayout2);
        this.moniterText = new Text(composite2, 2626);
        this.moniterText.setText("");
        gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.moniterText.setLayoutData((Object)gridData);
        this.resetButton.setEnabled(true);
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.resetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpManagerMonitorView.logger = Logger.getLogger(this.getClass().getName());
                SnmpManagerMonitorView.this.moniterText.setText("");
                logger.info("Snmp Manager monitor reset");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.startButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpManagerMonitorView.logger = Logger.getLogger(this.getClass().getName());
                SnmpManagerQueue.getInstance().setMonitor(true);
                SnmpManagerMonitorView.this.display.timerExec(1000, (Runnable)SnmpManagerMonitorView.this.timerProcessor);
                logger.info("Snmp Manager monitor start");
                SnmpManagerMonitorView.this.resetButton.setEnabled(true);
                SnmpManagerMonitorView.this.startButton.setEnabled(false);
                SnmpManagerMonitorView.this.stopButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.stopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SnmpManagerMonitorView.logger = Logger.getLogger(this.getClass().getName());
                SnmpManagerQueue.getInstance().setMonitor(false);
                SnmpManagerMonitorView.this.display.timerExec(-1, (Runnable)SnmpManagerMonitorView.this.timerProcessor);
                logger.info("Snmp Manager monitor stop");
                SnmpManagerMonitorView.this.resetButton.setEnabled(true);
                SnmpManagerMonitorView.this.startButton.setEnabled(true);
                SnmpManagerMonitorView.this.stopButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void setFocus() {
    }

    public class TimerProcessor
    implements Runnable {
        public void run() {
            String message = SnmpManagerQueue.getInstance().popSnmpManagerQueue();
            while (message != null) {
                SnmpManagerMonitorView.this.moniterText.append(String.valueOf(message) + System.getProperty("line.separator"));
                SnmpManagerMonitorView.this.moniterText.append(System.getProperty("line.separator"));
                message = SnmpManagerQueue.getInstance().popSnmpManagerQueue();
            }
            SnmpManagerMonitorView.this.display.timerExec(1000, (Runnable)this);
        }
    }
}

