/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.AlarmMessageQueue;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.socketclient.XMLSocketAlarmReceiveMessageQueue;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ConnectionEngineThread
extends DataStringDisplay
implements Runnable {
    private Map engineConnectStateMap;
    private static final int WAIT_SLEEP_TIME = 1000;
    private static final int MARK_RESET = 0;
    private Socket socket = null;
    private InputStream inputStream = null;
    private BufferedInputStream bufferInStream = null;
    private String engineAddressString = "";
    private String enginePortString = "";
    private boolean isThreadRun = true;
    private boolean isAlarm = false;
    private static Logger logger = null;

    public ConnectionEngineThread(Map engineConnectStateMap) {
        logger = Logger.getLogger(this.getClass().getName());
        this.engineConnectStateMap = engineConnectStateMap;
    }

    public void setXMLSocket(String engineAddress, int enginePort, int timeOut) throws IOException {
        this.engineAddressString = engineAddress;
        this.enginePortString = Integer.toString(enginePort);
        try {
            InetAddress dstInetAddr = InetAddress.getByName(engineAddress);
            this.socket = new Socket(dstInetAddr, enginePort);
            this.socket.setSoTimeout(timeOut);
            OutputStream os = this.socket.getOutputStream();
            XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
            outputter.output(this.createDocument(), os);
            this.inputStream = this.socket.getInputStream();
        }
        catch (UnknownHostException ex) {
            logger.warning("UnknownHostException : " + ex.getMessage() + " EngineAddress=" + engineAddress + " Port=" + this.enginePortString);
            throw ex;
        }
        catch (ConnectException ex) {
            logger.warning("ConnectException : " + ex.getMessage() + " EngineAddress=" + engineAddress + " Port=" + this.enginePortString);
            throw ex;
        }
        catch (IOException ex) {
            logger.warning("IOException : " + ex.getMessage() + " EngineAddress=" + engineAddress + " Port=" + this.enginePortString);
            throw ex;
        }
    }

    public void run() {
        try {
            this.bufferInStream = new BufferedInputStream(this.inputStream);
            while (this.isThreadRun) {
                try {
                    if (this.parseInputStream(this.bufferInStream)) {
                        this.bufferInStream.mark(0);
                        this.inputStream.mark(0);
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    break;
                }
            }
        }
        finally {
            if (this.engineConnectStateMap.containsKey(this.engineAddressString)) {
                this.engineConnectStateMap.put(this.engineAddressString, " Unconnect");
                logger.warning("Disconnect engine IP=" + this.engineAddressString);
            }
            if (this.bufferInStream != null) {
                try {
                    this.bufferInStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    private boolean parseInputStream(BufferedInputStream buffInStream) {
        boolean isParse = false;
        try {
            int availableCount = buffInStream.available();
            if (availableCount <= 1) {
                return isParse;
            }
            buffInStream.mark(availableCount);
            byte[] receiveBuff = new byte[availableCount];
            buffInStream.read(receiveBuff, 0, availableCount);
            int startCount = 0;
            int i = 0;
            while (i < receiveBuff.length) {
                if (receiveBuff[i] == 0) {
                    isParse = true;
                    byte[] parseBuff = new byte[i - 1 - startCount];
                    System.arraycopy(receiveBuff, startCount, parseBuff, 0, parseBuff.length);
                    this.parseDocument(parseBuff);
                    startCount = i + 1;
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return isParse;
    }

    private void parseDocument(byte[] receiveBuff) {
        Document doc = null;
        try {
            ByteArrayInputStream byteArrayInStream = new ByteArrayInputStream(receiveBuff);
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)byteArrayInStream);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            logger.warning("ConnectException : " + e.getMessage() + " EngineAddress=" + this.engineAddressString + " Port=" + this.enginePortString);
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            logger.warning("ConnectException : " + e.getMessage() + " EngineAddress=" + this.engineAddressString + " Port=" + this.enginePortString);
        }
        if (doc == null) {
            return;
        }
        try {
            Element root = doc.getRootElement();
            String response_text = root.getAttributeValue("resp_str");
            if (!response_text.equals("Connection_Check") && response_text.indexOf("CONNECT") != 0) {
                Pattern pattern = Pattern.compile(":[ ]");
                String[] xmlAlarmArray = pattern.split(response_text, 2);
                this.setAlarmInfo(this.engineAddressString, xmlAlarmArray[0], xmlAlarmArray[1]);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void setAlarmInfo(String engineAddress, String ipaddress, String message) {
        AlarmCodeInformation alarminfo = new AlarmCodeInformation();
        alarminfo.setEngineAddress(engineAddress);
        alarminfo.setIpaddress(ipaddress);
        alarminfo.setMessage(message);
        AlarmMessageQueue.getInstance().pushAlarmData(alarminfo);
        this.isAlarm = true;
        XMLSocketAlarmReceiveMessageQueue.getInstance().pushXMLAlarmData(alarminfo);
    }

    private Document createDocument() {
        Element confElement = new Element("send_info");
        Document doc = new Document(confElement);
        confElement.setAttribute("send_text", "Eclipse RCP");
        return doc;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void close() {
        if (this.bufferInStream != null) {
            try {
                this.bufferInStream.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
    }

    public void setThreadRun(boolean isThreadRun) {
        this.isThreadRun = isThreadRun;
    }

    public boolean isAlarm() {
        return this.isAlarm;
    }

    public void setAlarm(boolean isAlarm) {
        this.isAlarm = isAlarm;
    }

    public String getEngineAddress() {
        return this.engineAddressString;
    }
}

