/*
 * Created on 2004/04/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.control;


/**
 * f[^x[XŗL̃NXɌp钊ۃNXłB
 * f[^x[XɑΉSQL̕ێ܂B
 * Ήf[^x[X͈ȉ̒ʂłB
 * EMySQL
 * EPostgreSQL
 * EHSQLDB
 * EApache Derby
 * EORACLE
 * EAxion
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractDataAccessObject {

    /**
     * f[^x[X
     */
    public static final String USE_DATABASE = "nodewatch/";
    /**
     * f[^x[X URL suffix
     */
    public static final String DATABASE_URL = "nodewatch";
    /**
     * MySQLp̃f[^x[X
     */
    public static final String MYSQL_USE_DATABASE = "nodewatch";
    /**
     * PostgreSQLp̃f[^x[X
     */
    public static final String POSTGRESQL_USE_DATABASE = "nodewatch";

    /** f[^x[XʔpMySQLʎq */
    public static final String MYSQL = "MySQL";

    /** f[^x[XʔpPostgreSQLʎq */
    public static final String POSTGRESQL = "Postgresql";

    /** f[^x[XʔpOracleʎq */
    public static final String ORACLE = "Oracle";

    /** f[^x[XʔpDB2ʎq */
    public static final String DB2 = "DB2";

    /** f[^x[XʔpHSQLDBʎq */
    public static final String HSQLDB = "HSQLDB";

    /** f[^x[XʔpApache Derbyʎq */
    public static final String DERBY = "Apache Derby";

    /** f[^x[XʔpApache Derby Embeddedʎq */
    public static final String EMBEDDED_DERBY = "Embedded Derby";

    /** f[^x[XʔpAxionʎq */
    public static final String AXION = "Axion";

    /** CommitLq */
    public static final String COMMIT = "commit";

    /** Apache Derby   */
    public static final String INT8 = "INT8";

    /** Apache DerbyȊO̐ */
    public static final String BIGINT = "BIGINT";

    /** MySQL DoubleLq */
    public static final String MYSQL_DOUBLE = "DOUBLE";

    /** Postgresql DoubleLq */
    public static final String POSTGRESQL_DOUBLE = "double precision";

    /** HSQLDB DoubleLq */
    public static final String HSQLDB_DOUBLE = "REAL";

    /** Apache Derby DoubleLq */
    public static final String APACHE_DERBY_DOUBLE = "double precision";

    /** TimeX^v */
    public static final String TIMESTAMP = "TIMESTAMP";

    /** JEg */
    public static final String COUNT = "count(*)";

    /** ől */
    public static final String MAX = "max";

    /** ŏl */
    public static final String MIN = "min";

    /**
     * vf[^̎Ȃǂ̓i[JŊee[uŎgp܂B
     * ́Af[^ʊǗŗLmF̂߂ɓJʓI
     * Ǘ邽߂łB
     */
    public static final String CUR_DATE = "curdate";

    /* e[uǗe[uV[PX폜SQL */
    private static final String DROP_TABLE_MANAGEMENT_SEQUENCE =
        "DROP SEQUENCE tableManagement_id_seq";

    /* f[^x[XeXge[uV[PX폜SQL */
    private static final String DROP_DATABASE_TEST_SEQUENCE =
        "DROP SEQUENCE database_test_id_seq";

    /* A[e[uV[PX폜SQL */
    private static final String DROP_ALARM_TABLE_SEQUENCE =
        "DROP SEQUENCE alarm_table_id_seq";

    /* A[tB^[e[uV[PX폜SQL */
    private static final String DROP_ALARM_FILTER_TABLE_SEQUENCE =
        "DROP SEQUENCE alarm_filter_table_id_seq";

    /* ^XNXPW[e[uV[PX폜SQL */
    private static final String DROP_TASK_SCHEDULE_TABLE_SEQUENCE =
        "DROP SEQUENCE task_schedule_id_seq";

    /* m[hMap Linke[uV[PX폜SQL */
    private static final String DROP_NODE_MAP_LINK_TABLE_SEQUENCE =
        "DROP SEQUENCE nodeMapLink_table_id_seq";

    /* GarbageCollectione[uV[PX폜SQL */
    private static final String DROP_GARBAGECOLLECTION_TABLE_SEQUENCE =
        "DROP SEQUENCE garbageCollection_table_id_seq";

    /** f[^x[XUrl */
    protected String databaseurl;

    /** f[^x[XhCo */
    private String driver;

    /** f[^x[X[U[ */
    private String user;

    /** f[^x[XpX[h */
    private String password;

    /**
     * A[e[uSQLԂ܂B
     *
     * @return A[e[uSQL
     */
    public abstract String getCreateAlarmTable();

    /**
     * m[ho^EĎe[uSQLԂ܂B
     *
     * @return SQL
     */
    public abstract String getCreateNoderegisterTable();

    /**
     * f[^x[XURLԂ܂B
     *
     * @return URL
     */
    public final String getDatabaseurl() {
        return databaseurl;
    }

    /**
     * f[^x[XhCoԂ܂B
     *
     * @return f[^x[XhCo
     */
    public final String getDriver() {
        return driver;
    }

    /**
     * f[^x[XURLԂ܂B
     *
     * @return f[^x[XURL
     */
    public String getUrl() {
        return databaseurl + USE_DATABASE;
    }

    /**
     * f[^x[XUserԂ܂B
     *
     * @return f[^x[XUser
     */
    public final String getUser() {
        return user;
    }

    /**
     * f[^x[XpX[hԂ܂B
     *
     * @return f[^x[XpX[h
     */
    public final String getPassword() {
        return password;
    }

    /**
     * f[^x[XhCoZbg܂B
     *
     * @param string@f[^x[XhCo
     */
    public final void setDriver(final String string) {
        driver = string;
    }

    /**
     * f[^x[XURLZbg܂B
     *
     * @param string@f[^x[XURL
     */
    public final void setDatabaseurl(final String string) {
        databaseurl = string;
    }

    /**
     * f[^x[XpX[hZbg܂B
     *
     * @param string f[^x[XpX[h
     */
    public final void setPassword(final String string) {
        password = string;
    }

    /**
     * f[^x[XUserZbg܂B
     *
     * @param string@f[^x[XUser
     */
    public final void setUser(final String string) {
        user = string;
    }

    /**
     * A[e[u폜SQLԂ܂B
     *
     * @return String A[e[u폜SQLԂ܂B
     */
    public abstract String getDropAlarmTableSQL();

    /**
     * A[V[PXe[u폜SQLԂ܂B
     *
     * @return A[V[PXe[u폜SQL
     */
    public final String getDropAlarmTableSequenceSQL() {
        return DROP_ALARM_TABLE_SEQUENCE;
    }

    /**
     * ^XNXPW[폜SQLԂ܂B
     *
     * @return ^XNXPW[폜SQL
     */
    public final String getDropTaskScheduleTableSequenceSQL() {
        return DROP_TASK_SCHEDULE_TABLE_SEQUENCE;
    }

    /**
     * ^XNXPW[e[uSQLԂ܂B
     *
     * @return ^XNXPW[e[uSQL
     */
    public abstract String getCreateTaskSCheduleTable();

    /**
     * ^XNXPW[e[u폜SQLԂ܂B
     *
     * @return ^XNXPW[e[u폜SQL
     */
    public abstract String getDropTaskSCheduleTable();

    /**
     * GarbageCollectione[u폜SQLԂ܂B
     *
     * @return GarbageCollectione[u폜SQL
     */
    public abstract String getDropGarbageCollectionTableSQL();

    /**
     * GarbageCollectione[uSQLԂ܂B
     *
     * @return GarbageCollectione[uSQL
     */
    public abstract String getCreateGarbageCollectionTableSQL();

    /**
     * m[hĎe[u폜SQLԂ܂B
     *
     * @return String m[hĎe[u폜SQL
     */
    public abstract String getDropNoderegisterTableSQL();

    /**
     * m[hMape[uSQLԂ܂B
     *
     * @return m[hMape[uSQL
     */
    public abstract String getCreateNodeMapLinkTableSQL();

    /**
     * m[hMape[u폜SQLԂ܂B
     *
     * @return m[hMape[u폜SQL
     */
    public abstract String getDropNodeMapLinkTableSQL();

    /**
     * m[hMape[uV[PX폜SQLԂ܂B
     *
     * @return m[hMape[uV[PX폜SQL
     */
    public final String getDropNodeMapLinkTableSequenceSQL() {
        return DROP_NODE_MAP_LINK_TABLE_SEQUENCE;
    }

    /**
     * A[tB^e[uSQLԂ܂B
     *
     * @return A[tB^e[uSQL
     */
    public abstract String getCreateAlarmFilterTableSQL();

    /**
     * A[tB^e[u폜SQLԂ܂B
     *
     * @return A[tB^e[u폜SQL
     */
    public abstract String getDropAlarmFilterTableSQL();

    /**
     * A[tB^V[PXe[u폜SQLԂ܂B
     *
     * @return A[tB^V[PXe[u폜SQL
     */
    public final String getDropAlarmFilterTableSequenceSQL() {
        return DROP_ALARM_FILTER_TABLE_SEQUENCE;
    }

    /**
     * f[^x[XeXge[uSQLԂ܂B
     *
     * @return f[^x[XeXge[uSQL
     */
    public abstract String getCreateDatabaseTestTableSQL();

    /**
     * f[^x[XeXge[u폜SQLԂ܂B
     *
     * @return drop_test_table f[^x[XeXge[u폜SQL
     */
    public abstract String getDropDatabaseTestTableSQL();

    /**
     * f[^x[XeXgV[PXe[u폜SQLԂ܂B
     *
     * @return f[^x[XeXgV[PXe[u폜SQL
     */
    public final String getDropDatabaseTestSequenceSQL() {
        return DROP_DATABASE_TEST_SEQUENCE;
    }

    /**
     * GarbageCollectionV[PXe[u폜SQLԂ܂B
    *
    * @return GarbageCollectionV[PXe[u폜SQL
    */
    public final String getDropGarbageCollectionSequenceSQL() {
        return DROP_GARBAGECOLLECTION_TABLE_SEQUENCE;
    }

    /**
     * e[uǗe[uSQLԂ܂B
     *
     * @return create_tableManagement_table@e[uǗe[uSQL
     */
    public abstract String getCreateTableManagementTableSQL();

    /**
     * e[uǗV[PXe[u폜SQLԂ܂B
     *
     * @return e[uǗV[PXe[u폜SQL
     */
    public final String getDropTableManagementSequenceSQL() {
        return DROP_TABLE_MANAGEMENT_SEQUENCE;
    }

    /**
     * e[uǗe[u폜SQLԂ܂B
     *
     * @return e[uǗe[u폜SQL
     */
    public abstract String getDropTableManagementTableSQL();

    /**
     * SNMPvMIBe[uSQLԂ܂B
     *
     * @return SNMPvMIBe[uSQL
     */
    public abstract String getItemSnmpStatisticsTableSQL();

    /**
     *  I[gCNgSQLԂ܂B
     *
     * @return String I[gCNgSQL
     */
    public abstract String getAutoIncrement();
}
