/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableMapLink;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.ConnectionNodeMapLink;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.jdom.Document;
import org.osgi.framework.Bundle;


/**
 * NodeXgViewł̃ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class ActionBuilderNodeList {
    /* MO */
    private static Logger logger;

    /*
     * m[hViewō\\EditorPartEditorPart
     * JxɁAUEditorPartCloseĂOpen
     */
    private IEditorPart editorNodeConfigView;

    /* Node Liste[u\XVANV */
    private IAction showNodeListTableAction = new ActionShowNodeListTable();

    /* Nodeꊇo^ANV */
    private IAction importNodeListAction = new ActionImportNodeListFile();

    /* lbg[NoRłNodeꊇo^ANV */
    private IAction importNodeListActionSocket =
        new ActionImportNodeListFileSocket();

    /* NodeĎ񃊃XgCSVo̓ANV */
    private IAction exportNodeListAction = new ActionExportNodeListFile();

    /* lbg[NoRłNodeĎ񃊃XgCSVo̓ANV */
    private IAction exportNodeListActionSocket =
        new ActionExportNodeListFileSocket();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * NodeXgViewł̃ANVNXCX^X
     * ܂B
     *
     */
    public ActionBuilderNodeList() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Nodeꊇo^ANVԂ܂B
     *
     * @return importNodeList Nodeꊇo^ANV
     */
    public IAction getActionImportNodeListFile() {
        return importNodeListAction;
    }

    /**
     * lbg[NoRłNodeꊇo^ANVԂ܂B
     *
     * @return importNodeListActionSocket lbg[NoRłNodeꊇo^ANV
     */
    public IAction getActionImportNodeListFileSocket() {
        return importNodeListActionSocket;
    }

    /**
     * m[hĎGNX|[gANVԂ܂B
     *
     * @return exportNodeList m[hĎGNX|[gANV
     */
    public IAction getActionExportNodeListFile() {
        return exportNodeListAction;
    }

    /**
     * lbg[NoRł̃m[hĎGNX|[gANVԂ܂B
     *
     * @return exportNodeListActionSocket lbg[NoRł̃m[hĎ
     * GNX|[gANV
     */
    public IAction getActionExportNodeListFileSocket() {
        return exportNodeListActionSocket;
    }

    /**
     * Node liste[u\ANVԂ܂B
     *
     * @return Node liste[u\ANV
     */
    public IAction getActionShowNodeListTable() {
        return showNodeListTableAction;
    }

    /**
     * m[hListe[u\XVANVm[hꊇo^ANV
     * Ă΂܂B
     * ł́A܂񂪂̃NXpNXŃI[o[ChA
     * ۂ̃m[hListe[u\XVLq܂B
     *
     */
    protected void refreshAlarmTable() {
    }

    /*
     * m[ho^s܂B
     *
     * @param isSocket lbg[NoRō̎悷邩ۂtO
     */
    private void registerNode(boolean isSocket) {
        Shell shell = new Shell();
        FileDialog openDialog = new FileDialog(shell, SWT.OPEN);
        String openFileName = openDialog.open();

        if (openFileName != null) {
            NodeUploadFile impFile = new NodeUploadFile();

            try {
                impFile.upload(openFileName);
            } catch (FileNotFoundException e) {
                MessageDialog.openError(
                    shell, "Node list import error", e.getMessage());
                logger.warning("Node list import error " + e.getMessage());
                e.printStackTrace();

                if (shell != null) {
                    shell.dispose();
                }

                return;
            } catch (Exception e) {
                MessageDialog.openError(
                    shell, "Node list import error", e.getMessage());
                logger.warning("Node list import error " + e.getMessage());
                e.printStackTrace();

                if (shell != null) {
                    shell.dispose();
                }

                return;
            }

            ArrayList nodeList = getNodeList(isSocket);

            ArrayList nodeInfoList = impFile.getNodeInfoList();
            ArrayList linkList = impFile.getLinkList();
            boolean isLocalhostAddress = false;
            String engineLocalAddress;

            try {
                engineLocalAddress =
                    InetAddress.getLocalHost().getHostAddress();

                if (
                    MessageDialog.openQuestion(
                            shell, "Check Engine Address",
                            "Engine Address is = " + engineLocalAddress + " ?")) {
                    isLocalhostAddress = true;
                }
            } catch (UnknownHostException e) {
                logger.warning(e.getMessage());
            }

            int successNode = 0;
            int duplicateNode = 0;

            for (int k = 0; k < nodeInfoList.size(); k++) {
                String[] nodeInfoArray = (String[]) nodeInfoList.get(k);
                NodeInformation nodeInfo =
                    impFile.createNodeInfo(nodeInfoArray, isLocalhostAddress);

                boolean isDuplicateIPAddress = false;

                for (int j = 0; j < nodeList.size(); j++) {
                    NodeInformation checkNode =
                        (NodeInformation) nodeList.get(j);

                    if (
                        checkNode.getIpaddress().equals(
                                nodeInfo.getIpaddress())) {
                        isDuplicateIPAddress = true;
                        duplicateNode++;
                    }
                }

                if (!isDuplicateIPAddress) {
                    if (!isSocket) {
                        NodeAdd nodeAddInstance = NodeAdd.getInstance();
                        nodeAddInstance.addNode(nodeInfo, true);

                        successNode++;
                    } else {
                        String engineAddress =
                            ClientEngineInfo.getClientEngineInfoInstance()
                                            .getEngineAddress();
                        ConnectionNodeControl threadstop =
                            new ConnectionNodeControl(engineAddress);

                        try {
                            String responseCode =
                                threadstop.requestThread(
                                    nodeInfo.getIpaddress(),
                                    CommandMappingTableResource.THREAD_START_COMMAND_ID,
                                    nodeInfo);

                            if (
                                !responseCode.equals(
                                        CommandMappingTableResource.ACK_RESPONSE)) {
                            } else {
                                successNode++;
                            }
                        } catch (EngineConnectException e1) {
                            logger.warning(
                                "EngineConnectException " + e1.getMessage());
                            e1.printStackTrace();
                        } catch (IOException e1) {
                            logger.warning("IOException " + e1.getMessage());
                            e1.printStackTrace();
                        }
                    }
                }
            }

            /* Linkf[^x[XɊi[ */
            ArrayList node0addressList = new ArrayList();
            ArrayList node1addressList = new ArrayList();

            for (int i = 0; i < linkList.size(); i++) {
                String[] address = (String[]) linkList.get(i);
                node0addressList.add(address[0]);
                node1addressList.add(address[1]);
            }

            NodeMapLinkInformation nodeMapLinkInfo =
                new NodeMapLinkInformation();
            nodeMapLinkInfo.setNode0address(node0addressList);
            nodeMapLinkInfo.setNode1address(node1addressList);

            try {
                if (!isSocket) {
                    DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();
                    nodeMapLinkDBTable.updateNodeMapLink(
                        nodeMapLinkInfo, false);
                } else {
                    String engineAddress =
                        ClientEngineInfo.getClientEngineInfoInstance()
                                        .getEngineAddress();
                    ConnectionNodeMapLink connectNodeInfo =
                        new ConnectionNodeMapLink(engineAddress);
                    connectNodeInfo.updateNodeMapInformation(nodeMapLinkInfo);
                }
            } catch (SQLException e1) {
                MessageDialog.openError(
                    shell, "Node register error", e1.getMessage());
                logger.warning("Node registre error " + e1.getMessage());
                e1.printStackTrace();

                return;
            } catch (DatabaseConnectionException e1) {
                MessageDialog.openError(
                    shell, "Node register error", e1.getMessage());
                logger.warning("Node registre error " + e1.getMessage());
                e1.printStackTrace();

                return;
            } catch (EngineConnectException e1) {
                MessageDialog.openError(
                    shell, "Node register error", e1.getMessage());
                logger.warning("Node registre error " + e1.getMessage());
                e1.printStackTrace();

                return;
            } catch (IOException e1) {
                MessageDialog.openError(
                    shell, "Node register error", e1.getMessage());
                logger.warning("Node registre error " + e1.getMessage());
                e1.printStackTrace();

                return;
            } finally {
                refreshAlarmTable();

                if (shell != null) {
                    shell.dispose();
                }
            }

            String errMessage = "";

            if (duplicateNode != 0) {
                errMessage = " Duplicate node=" + duplicateNode;
            }

            MessageDialog.openInformation(
                shell, "result",
                "total node=" + nodeInfoList.size() + " success node="
                + successNode + errMessage);
        }

        if (shell != null) {
            shell.dispose();
        }
    }

    /*
     * m[hĎ񃊃XgGNX|[g܂B
     *
     * @param isSocket lbg[NoRō̎悷邩ۂtO
     */
    private void exportNodeInfo(boolean isSocket) {
        Shell shell = new Shell();
        FileDialog openDialog = new FileDialog(shell, SWT.SAVE);
        String xmlFile = openDialog.open();
        System.out.println("openFile : " + xmlFile);

        logger.info("XML file name : " + xmlFile);

        shell.dispose();

        if (xmlFile == null) {
            return;
        }

        ArrayList nodeList = getNodeList(isSocket);
        NodeMapLinkInformation linkInfo = getNodeLinkList(isSocket);

        NodeListExport export = new NodeListExport();
        Document doc = export.updateDocument(nodeList, linkInfo);

        export.outputXMLFile(xmlFile, doc);
    }

    /**
     * m[hĎ񃊃Xg擾܂B
     *
     * @param isSocket lbg[NoRō̎悷邩ۂtO
     * @return nodeList m[hĎ񃊃Xg
     */
    private ArrayList getNodeList(boolean isSocket) {
        ArrayList nodeList = null;
        Shell shell = null;

        try {
            if (!isSocket) {
                DBTableNodeRegister nodeRegisterDBTable =
                    DBTableNodeRegister.getInstance();
                nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
            } else {
                String engineAddress =
                    ClientEngineInfo.getClientEngineInfoInstance()
                                    .getEngineAddress();

                ConnectionNodeInformation connectNodeInfo =
                    new ConnectionNodeInformation(engineAddress);

                nodeList = connectNodeInfo.getNodeInformationList(null, null);
            }
        } catch (SQLException e1) {
            shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
        } catch (Exception e1) {
            shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (shell != null) {
                shell.dispose();
            }
        }

        return nodeList;
    }

    /**
    * m[hMap Link擾܂B
    *
    * @param isSocket lbg[NoRō̎悷邩ۂtO
    * @return nodMapLinkinfo m[hMap Link
    */
    private NodeMapLinkInformation getNodeLinkList(boolean isSocket) {
        NodeMapLinkInformation nodMapLinkinfo = null;

        Shell shell = null;

        try {
            if (!isSocket) {
                DBTableMapLink nodeMapLinkDBTable = new DBTableMapLink();
                nodMapLinkinfo = nodeMapLinkDBTable.findAll();
            } else {
                String engineAddress =
                    ClientEngineInfo.getClientEngineInfoInstance()
                                    .getEngineAddress();
                ConnectionNodeMapLink connectNodeInfo =
                    new ConnectionNodeMapLink(engineAddress);

                nodMapLinkinfo = connectNodeInfo.getNodeMapInformation();
            }
        } catch (SQLException e1) {
            logger.warning("Node List import error " + e1.getMessage());

            shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            shell.dispose();

            e1.printStackTrace();
        } catch (Exception e1) {
            logger.warning("Node List import error " + e1.getMessage());

            shell = new Shell();
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            shell.dispose();

            e1.printStackTrace();
        } finally {
            if (shell != null) {
                shell.dispose();
            }
        }

        return nodMapLinkinfo;
    }

    /**
     * Node liste[uViewɊւANVNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeListAction extends Action {
        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();
    }

    /**
     * Node ListǂݍŃe[u\ANVNXłB
     */
    protected class ActionShowNodeListTable extends AbstractNodeListAction {
        /**
         * Node ListǂݍŃe[u\ANṼACR
         * ImageDescriptorԂ܂B
         *
         * @return Node ListǂݍŃe[u\ANV
         * ̃ACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/reload.gif"));
        }

        /**
         * Node ListǂݍŃe[u\ANVText
         * Ԃ܂B
         *
         * @return Node ListǂݍŃe[u\ANV
         * Text
         */
        public String getText() {
            return "Node list table show";
        }

        /**
         * Node ListǂݍŃe[u\ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Node liste[u\܂";
        }

        /**
         * Node liste[u\܂B
         *
         */
        protected void doTask() {
            refreshAlarmTable();
        }
    }

    /**
     * m[hꊇo^sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @value 1.0
     */
    protected class ActionImportNodeListFile extends AbstractNodeListAction {
        /**
         * m[hꊇo^sANṼACRImageDescriptorԂ܂B
         *
         * @return m[hꊇo^sANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/import_wiz.gif"));
        }

        /**
         * m[hꊇo^sANVTextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Import Node List";
        }

        /**
         * m[hꊇo^sANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "Import Node List";
        }

        /**
         * m[hꊇo^s܂B
         *
         */
        protected void doTask() {
            BusyIndicator.showWhile(
                PlatformUI.getWorkbench().getDisplay(),
                new Runnable() {
                    public void run() {
                        /*
                         * m[hꊇo^(SocketoRȂ)
                         */
                        registerNode(false);
                    }
                });
        }
    }

    /**
     * lbg[NoRł̃m[hꊇo^sANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @value 1.0
     */
    protected class ActionImportNodeListFileSocket
        extends ActionImportNodeListFile {
        /**
         * m[hꊇo^s܂B
         *
         */
        protected void doTask() {
            /*
             * m[hꊇo^(SocketoR)
             */
            registerNode(true);
        }
    }

    /**
     * m[hĎGNX|[gANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected class ActionExportNodeListFile extends AbstractNodeListAction {
        /**
         * m[hĎGNX|[gANṼACR
         * ImageDescriptorԂ܂B
         *
         * @return m[hĎGNX|[gANV
         * ACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/export_wiz.gif"));
        }

        /**
         * m[hĎGNX|[gANVTextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Export Node list file";
        }

        /**
         * m[hĎGNX|[gANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "m[hĎGNX|[g܂";
        }

        /**
         * m[hĎGNX|[g܂B
         *
         */
        protected void doTask() {
            exportNodeInfo(false);
        }
    }

    /**
     * lbg[NoRł̃m[hĎGNX|[gANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    protected class ActionExportNodeListFileSocket
        extends ActionExportNodeListFile {
        /**
         * m[hĎGNX|[g܂B
         *
         */
        protected void doTask() {
            exportNodeInfo(true);
        }
    }
}
