/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.ConstructDatabase;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;



/**
 * f[^x[XANZX𐧌䂷NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabaseControl {
    /* MO */
    private static Logger logger;

    /* f[^x[XANZXJnς݃tO */
    private boolean isDatabaseStart;

    /*
     * f[^x[X𐧌䂷NXCX^X𐶐܂B
     */
    private DatabaseControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XANZXJn܂B
     *
     * @param isInitFlag f[^x[XFlag
     *
     */
    public void startDatabase(boolean isInitFlag) {
        if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.HSQLDB)) {
            /*
             * f[^x[XʂHSQLDB̏ꍇ́A
             * HSQLDBN
             */
            try {
                HsqldbControl.getInstance().startHsqlDB();
                logger.info("Hsqldb start.");
            } catch (HsqldbException e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort HSQLDB start ", e.getMessage());
                logger.warning("Abort HSQLDB star " + e.getMessage());
                shell.dispose();
            }
        } else if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.DERBY)) {
            /*
             * f[^x[XʂApache Derby̏ꍇ́A
             * Apache DerbyN
             */
            try {
                ApacheDerbyNetworkServer.getInstance().startDerbyNetworkServer();
                logger.info("Apache Derby start.");
            } catch (Exception e) {
                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Error", "Abort start Apache Derby "
                    + e.getMessage());
                logger.warning("Abort Apache Derby star " + e.getMessage());
                shell.dispose();
            }
        } else if (
            DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
                    AbstractDataAccessObject.EMBEDDED_DERBY)) {
            /*
             * f[^x[XʂEmbedded Apache Derby̏ꍇ́A
             * Embedded Apache DerbyN
             */
            if (!ApacheDerbyEmbeddedDerby.getInstance().isEmbeddedDerby()) {
                logger.info("Embedded Apache Derby Start");

                try {
                    ApacheDerbyEmbeddedDerby.getInstance().startEmbeddedDerby();
                } catch (Exception e) {
                    Shell shell = new Shell();
                    MessageDialog.openError(
                        shell, "Error",
                        "Abort start Embedded Apache Derby " + e.getMessage());
                    logger.warning(
                        "Abort Embedded Apache Derby star " + e.getMessage());
                    shell.dispose();
                }
            }
        }

        /*
         * f[^x[XRlNVPool𐶐Ae[uCX^X
         * 
         */
        ConstructDatabase databaseControl = new ConstructDatabase();

        /* f[^x[X`FbN */
        if (isInitFlag) {
            /* f[^x[Xe[u */
            databaseControl.createDatabase();
        }

        // Database ANZXPool
        databaseControl.createPool();

        /* f[^x[X`FbN */
        if (isInitFlag) {
            /* f[^x[Xe[u */
            databaseControl.createTable();
        }

        isDatabaseStart = true;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabaseControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * f[^x[XANZXJnς݂ۂtOԂ܂B
     *
     * @return isDatabaseStart f[^x[XANZXJnς݂ۂtO
     */
    public boolean isDatabaseStart() {
        return isDatabaseStart;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DatabaseControl RESOURCE = new DatabaseControl();
    }
}
