/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;



/**
 * A[yѓv̕ێԐݒvtFXy[WNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PreservationPeriodPreferancePage
    extends AbstractEnginePreferancePage implements IWorkbenchPreferencePage {
    /** eLXg */
    public static final int TEXT_WIDTH = 120;

    /** ێԕ\^Cg */
    public static final String PRESERVATION_PERIOD = "Preservation period day";

    /** ێő僉C\^Cg */
    public static final String MAX_LINE = "Preservation max line";

    /** 'ێԐȂ'\^Cg */
    public static final String UNRESTRICTED = "Unrestricted";

    /* ێCombo Boxݒl */
    private static final String[] PERIOD = { "90", "60", "30", "7", "1" };

    /* MO */
    private static Logger logger;

    /* \[X */
    private ResourceInfo info;

    /* A[ێCombo Box */
    private Combo alarmHoldPeriodDayComb;

    /* A[ő吔\Text */
    private Text alarmMaxlineText;

    /* SNMPvێCombo Box */
    private Combo statisticsHoldPeriodDayComb;

    /* SNMPvőێC\Text */
    private Text statisticsMaxLineText;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        /*
        * eCompositezueLayout
        * ieCompositec1ɔzuj
        */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Group alarmGroup = new Group(composite, SWT.NONE);
        alarmGroup.setText("Alarm");
        alarmGroup.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        alarmGroup.setLayoutData(gridData);

        Label label = new Label(alarmGroup, SWT.NONE);
        label.setText(PRESERVATION_PERIOD);
        label.setLayoutData(new GridData());
        alarmHoldPeriodDayComb = new Combo(alarmGroup, SWT.DROP_DOWN);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        alarmHoldPeriodDayComb.setLayoutData(gridData);

        /* ێԃR{Zbg */
        alarmHoldPeriodDayComb.add(UNRESTRICTED);

        for (int i = 0; i < PERIOD.length; i++) {
            alarmHoldPeriodDayComb.add(PERIOD[i]);
        }

        label = new Label(alarmGroup, SWT.NONE);
        label.setText(MAX_LINE);
        gridData = new GridData();
        label.setLayoutData(gridData);

        alarmMaxlineText = new Text(alarmGroup, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        alarmMaxlineText.setLayoutData(gridData);

        Group statisticsGroup = new Group(composite, SWT.NONE);
        statisticsGroup.setText("Statistics");
        statisticsGroup.setLayout(new GridLayout(2, false));
        gridData = new GridData(GridData.FILL_HORIZONTAL);
        gridData.horizontalSpan = 2;
        statisticsGroup.setLayoutData(gridData);

        label = new Label(statisticsGroup, SWT.NONE);
        label.setText(PRESERVATION_PERIOD);
        gridData = new GridData();
        label.setLayoutData(gridData);

        statisticsHoldPeriodDayComb = new Combo(statisticsGroup, SWT.DROP_DOWN);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        statisticsHoldPeriodDayComb.setLayoutData(gridData);

        /* vێԃR{Zbg */
        statisticsHoldPeriodDayComb.add(UNRESTRICTED);

        for (int i = 0; i < PERIOD.length; i++) {
            statisticsHoldPeriodDayComb.add(PERIOD[i]);
        }

        label = new Label(statisticsGroup, SWT.NONE);
        label.setText(MAX_LINE);
        label.setLayoutData(new GridData());
        statisticsMaxLineText = new Text(statisticsGroup, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        statisticsMaxLineText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        setShow();

        /* Alarmێ CombBoxI */
        alarmHoldPeriodDayComb.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                }
            });

        /* vێ CombBoxI */
        statisticsHoldPeriodDayComb.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                }
            });

        return composite;
    }

    /*
     *
     */
    private void setShow() {
        if (info.getAlarmHoldPeriodDay().equals("0")) {
            alarmHoldPeriodDayComb.setText(UNRESTRICTED);
        } else {
            alarmHoldPeriodDayComb.setText(info.getAlarmHoldPeriodDay());
        }

        alarmMaxlineText.setText(info.getAlarmMax());

        if (info.getStatisticsHoldPeriodDay().equals("0")) {
            statisticsHoldPeriodDayComb.setText(UNRESTRICTED);
        } else {
            statisticsHoldPeriodDayComb.setText(
                info.getStatisticsHoldPeriodDay());
        }

        statisticsMaxLineText.setText(info.getStatisticsMax());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        info =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        setShow();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        if (alarmHoldPeriodDayComb.getText().equals(UNRESTRICTED)) {
            info.setAlarmHoldPeriodDay("0");
        } else {
            info.setAlarmHoldPeriodDay(alarmHoldPeriodDayComb.getText());
        }

        info.setAlarmMax(alarmMaxlineText.getText());

        if (statisticsHoldPeriodDayComb.getText().equals(UNRESTRICTED)) {
            info.setStatisticsHoldPeriodDay("0");
        } else {
            info.setStatisticsHoldPeriodDay(
                statisticsHoldPeriodDayComb.getText());
        }

        info.setStatisticsMax(statisticsMaxLineText.getText());

        saveResourceXMLInfo(info);

        return super.performOk();
    }
}
