/*
 * Created on 2004/05/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * IɃm[hSMTPĎ삷m[hĎ񃊃Xgm[hIPAhX
 * L[ƂĕێASMTPĎsThread𐧌䂷邽߂̃Xgێ
 * NXłB
 * ʃXbhł̃Xg̃JE^PbŃJEg_E0([)
 * ȂƎsL[Push܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ListQueueSmtpControl {
    /* IPAhXKeyƂSMTPĎێMap */
    private Map<String, NodeWatchInfo> smtpHashMap;

    /*
     * IPAhXL[Ƃm[hĎێMap𐶐
     * ܂B
     */
    private ListQueueSmtpControl() {
        smtpHashMap = Collections.synchronizedMap(new LinkedHashMap<String, NodeWatchInfo>());
    }

    /**
     * w肳ꂽIPAhXL[ƂāAm[hĎMapɊi[
     * ܂B
     * ̎ASMTPĎJE^ɃZbg܂B
     *
     * @param ip m[hIPAhX
     * @param nodeInfo m[hĎ
     */
    public void setSmtpNode(String ip, NodeWatchInfo nodeInfo) {
        nodeInfo.setCountSmtpPeriod(nodeInfo.getSmtpPeriod());

        // Xgɒǉ
        smtpHashMap.put(ip, nodeInfo);
    }

    /**
     * wm[hIPAhXSMTPĎԂ܂B
     *
     * @param ip m[hIPAhX
     * @return m[hĎ
     */
    public NodeWatchInfo getSmtpNode(String ip) {
        return (NodeWatchInfo) smtpHashMap.get(ip);
    }

    /**
     * wm[hIPAhXSMTPĎ폜܂B
     *
     * @param ip SMTPĎ
     */
    public void removeSmtpNode(String ip) {
        smtpHashMap.remove(ip);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ListQueueSmtpControl getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /**
     * m[hSMTPĎێMapԂ܂B
     *
     * @return m[hSMTPĎێMap
     */
    public Map getSmtpHashMap() {
        return smtpHashMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final ListQueueSmtpControl DBPOOL = new ListQueueSmtpControl();
    }
}
