/*
 * Created on 2004/05/04
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.database.access.model.StatisticsInfo;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

/**
 * vMIB̎悵AO̎f[^Ɣr臒lĂ邩`FbNA Ăꍇɂ̓A[ʒms\bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ExecuteStatisticsMibGet {
	/** SNMPvĎ^Cvɂ'ĎȂ'R[h */
	public static final String THRESHOLD_TYPE_NONE = "none";

	/** SNMPvĎ^Cvɂ'lĎ'R[h */
	public static final String THRESHOLD_TYPE_DIFFERENCE = "difference";

	/** SNMPvĎ^Cvɂ'ώZlĎ'R[h */
	public static final String THRESHOLD_TYPE_INTEGRAL = "integrale";

	/* Logging */
	private static Logger logger = null;

	/* SNMPve[uCX^X */
	private DBTableStatisticsMIBControl statisticsDatabaseTable = DBTableStatisticsMIBControl
			.getInstance();

	/* ŐV`FbNXVe[uCX^X */
	private LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate
			.getInstance();

	/* MIb̎CX^X */
	private MibGetNextInfo mibget;

	/**
	 * m[hSNMPvMIB̎悷CX^X𐶐܂B
	 * 
	 */
	public ExecuteStatisticsMibGet() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * Oƍ̓vMIBr`FbNA臒l𒴂ꍇɂ̓A[ʒm܂B
	 * 
	 * @param targetip
	 *            AgentAhX
	 * @param version
	 *            SNMPo[W
	 * @param community
	 *            R~jeB
	 * @param oid
	 *            OID
	 * @param threshHoldString
	 *            Ď臒l
	 * @param type
	 *            Ď^Cv
	 */
	public void execute(String targetip, int version, String community,
			String oid, String threshHoldString, String type) {
		if (threshHoldString == null || threshHoldString.equals("")) {
			threshHoldString = "0";
		}
		String ipAddressUunderbarConv = DBTableBase.IP
				+ targetip.replace('.', '_');
		ipAddressUunderbarConv = ipAddressUunderbarConv.replace('-', '_');
		String tableNameIpAddress = ipAddressUunderbarConv;
		ArrayList statisList = null;

		if (tableNameIpAddress == null) {
			return;
		}

		try {
			int checkCount = 0;
			mibget = null;

			while (mibget == null) {
				mibget = MibGetNextInfoQueue.getInstance()
						.popMibGetInstanceQueue(targetip,
								Thread.currentThread().getName());

				try {
					Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
				} catch (InterruptedException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				checkCount++;
				MibGetNextInfoQueue.getInstance().checkTimeout(targetip, oid,
						checkCount, version);
			}

			/*
			 * Ďm[hwOID̓vW
			 */
			logger.info("Mib get IP Address=" + targetip + " Version="
					+ version + " OID=" + oid);
			mibget.setMibGetNext(targetip, version, community);
			statisList = mibget.getNextMibValueList(oid);
		} catch (SocketException e1) {
			logger.warning(e1.getMessage() + " : " + targetip + " : " + oid
					+ " : " + community);
			e1.printStackTrace();
		} catch (UnknownHostException e1) {
			logger.warning(e1.getMessage() + " : IP=" + targetip + " Version="
					+ version + " : OID=" + oid + " : Community=" + community);
			e1.printStackTrace();
		} catch (SnmpMIBGetException e1) {
			logger.warning(e1.getMessage() + " : IP=" + targetip + " Version="
					+ version + " : OID=" + oid + " : Community=" + community);
			e1.printStackTrace();
		} finally {
			if (mibget != null) {
				MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
						targetip, Thread.currentThread().getName());
			}
		}

		if ((statisList == null) || (statisList.size() == 0)) {
			return;
		}

		try {
			double value = 0;
			double threshold = 0;
			threshold = Double.parseDouble(threshHoldString);

			/* O̓vMIB擾 */
			ArrayList databaseList = statisticsDatabaseTable.get(
					tableNameIpAddress, oid, statisList);

			for (int j = 0; j < statisList.size(); j++) {
				String valueString = ((MibValue) statisList.get(j))
						.getMibValue();
				String instanceName = ((MibValue) statisList.get(j))
						.getMibName();
				value = Double.parseDouble(valueString);

				if (type == null) {
					break;
				}

				/*
				 * ܂͐ώZl臒lrA臒l𒴂ꍇɂ A[ʒm
				 */
				if (type.equals(THRESHOLD_TYPE_INTEGRAL)) {
					/* ώZl`FbN */
					if (value > threshold) {
						/*
						 * ώZl臒l𒴂̂ŃA[ʒm
						 */
						AlarmMessageMake message = AlarmMessageMake
								.getInstance();
						message.setStatisticsMIBOver(targetip, oid,
								instanceName, "Integrale", value, threshold);
					}
				} else if (type.equals(THRESHOLD_TYPE_DIFFERENCE)) {
					/* l`FbN */
					StatisticsInfo info = (StatisticsInfo) databaseList.get(j);

					/* lZo */
					double diffData = checkDifference(value, info);

					if (diffData > threshold) {
						/*
						 * l臒l𒴂̃A[Zbg
						 */
						AlarmMessageMake message = AlarmMessageMake
								.getInstance();
						message
								.setStatisticsMIBOver(targetip, oid,
										instanceName, "Difference", diffData,
										threshold);
					}
				}
			}

			/*
			 * ̓vMIBf[^x[XɊi[A OƂ
			 */
			statisticsDatabaseTable.put(tableNameIpAddress, oid, statisList);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage() + " : IP=" + targetip + " Version="
					+ version + " : OID=" + oid + " : Community=" + community);
			e.printStackTrace();
		} catch (SQLException e) {
			logger.warning(e.getMessage() + " : IP=" + targetip + " Version="
					+ version + " : OID=" + oid + " : Community=" + community);
			e.printStackTrace();
		}

		try {
			/* Ďm[hŏI`FbNXV */
			updateLastCheckTime.updateCheckTime(targetip);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (SQLException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}
	}

	/*
	 * Oƍ̎擝v̍lZo܂B
	 * 
	 * @param value ̎擝v @param info O̎擝v @return f[^
	 */
	private double checkDifference(double value, StatisticsInfo info) {
		/* Of[^o */
		String preValueString = info.getInstance();
		long preValue = 0;

		try {
			preValue = Long.parseLong(preValueString);
		} catch (NumberFormatException e) {
			logger.warning("NumberFormatException " + e.getMessage() + " "
					+ preValueString);
		}

		// ̎
		Date nowDate = Calendar.getInstance().getTime();
		long nowTime = nowDate.getTime();

		// O̎
		long preTime = info.getDate().getTime();

		/*
		 * Pʎԓ̍f[^Zo
		 */
		double diffData = (value - preValue) / ((nowTime - preTime) / 1000);

		return diffData;
	}
}
