/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.common.view.TableListViewColor;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAlarmSocket;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAllAlarm;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionConfirmAllAlarmSocket;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionExportAlarmInfo;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionExportAlarmInfoSocket;
import netjfwatcher.engine.model.action.ActionBuilderDataExport.ActionExportAlarm;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * m[hAlarmEditorPartɕ\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeAlarm extends AbstractEditorNodeView {
	/** A[e[uView ^CgSuffix */
	public static final String TITLE_SUFFIX = " Alarm View";

	/** A[\Text */
	protected static final int COUNT_TEXT_WIDTH = 100;

	/* MO */
	private static Logger logger;

	/* A[e[uJRatio */
	private static final float COLUMN0NO = 0.05f;

	private static final float COLUMN1ALARMDETECT = 0.15f;

	private static final float COLUMN2NODE_NAME = 0.1f;

	private static final float COLUMN3NODE_GROUP = 0.1f;

	private static final float COLUMN4IPADDRESSP = 0.1f;

	private static final float COLUMN5ALARM_MESSAGE = 0.5f;

	/* AlarmɊւANV */
	private AlarmAction alarmAction = new AlarmAction();

	/** f[^GNX|[gANV */
	protected ActionBuilderDataExport exportAction = new ActionBuilderDataExport();

	/** A[e[u\[gJ */
	protected String sortColumn = null;

	/** A[e[u\[g */
	protected String sortDirection = null;

	/** m[hĎ */
	protected NodeInformation targetNodeInfo;

	/** A[\Text */
	protected Text alarmCountText;

	/** XV{^ */
	protected Button refreshButton;

	/** TableViewer */
	protected TableViewer viewer;

	/** m[heLXg\BackGroundFi[ */
	protected Color textBackColor;

	/** G[x̃A[ŃXe[^XC\p */
	protected int errorCount;

	/** xx̃A[ŃXe[^XC\p */
	protected int warningCount;

	/** 񃌃x̃A[ŃXe[^XC\p */
	protected int infoCount;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorNodeAlarm() {
		logger = Logger.getLogger(this.getClass().getName());

		
		
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		textBackColor = WHITE_COLOR;
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		createImage(parent);

		AlarmTable alarmTable = new AlarmTable();
		table = alarmTable.createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		createContextMenu();

		setNodeAlarmeView(targetNodeInfo.getIpaddress(), sortColumn,
				sortDirection);

		/*
		 * TableōsNbNꂽꍇ̏
		 */
		table.addSelectionListener(new TableColumnControlTableListener(table,
				AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE));
	}

	/**
	 * Alarm\Xge[u̕\XV܂B
	 * 
	 * @param ipAddress
	 *            m[hIPAhX
	 * @param sortColumn
	 *            e[u\[gJ
	 * @param sortDirection
	 *            e[u\[g
	 */
	public void setNodeAlarmeView(String ipAddress, String sortColumn,
			String sortDirection) {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		/* Alarm擾 */
		ArrayList alarmInfoList = getAlarmList(ipAddress, sortColumn,
				sortDirection);

		if (alarmInfoList != null) {
			/* AlarmZbg */
			alarmCountText.setText(Integer.toString(alarmInfoList.size()));
		} else {
			return;
		}

		errorCount = 0;
		warningCount = 0;
		infoCount = 0;

		/* AlarmXg\e[uZbg */
		for (int i = 0; i < alarmInfoList.size(); i++) {
			String[] alarmCellArray = new String[AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS.length];

			AlarmInformation alarmInfo = (AlarmInformation) alarmInfoList
					.get(i);
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO] = alarmInfo
					.getAlarmID();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE] = alarmInfo
					.getAlarmDate();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME] = alarmInfo
					.getNodename();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP] = alarmInfo
					.getGroup();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS] = alarmInfo
					.getIpaddress();
			alarmCellArray[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE] = alarmInfo
					.getAlarmMessage();

			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(alarmCellArray);
			item.setData(alarmCellArray);

			/* AlarmxAlarm\Foreground colorZbg */
			if (alarmInfo.getAlarmLevel().equals(AlarmViewFilter.ERROR_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmErrorLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								errorImage);
				errorCount++;
			} else if (alarmInfo.getAlarmLevel().equals(
					AlarmViewFilter.WARNING_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmWarningLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								warningImage);
				warningCount++;
			} else if (alarmInfo.getAlarmLevel().equals(
					AlarmViewFilter.INFO_LEVEL)) {
				item.setForeground(TableListViewColor.getInstance()
						.getAlarmInfoLevelColor());
				item
						.setImage(
								AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
								infoImage);
				infoCount++;
			} else {
				logger.warning("Unknown alarm level : "
						+ alarmInfo.getAlarmLevel());
			}
		}

		setStatusLine();
	}

	/**
	 * Alarm񃊃Xgf[^x[X擾ĕԂ܂B
	 * 
	 * @param ipAddress
	 *            m[hIPAhX
	 * @param sortColumn
	 *            \[gJ
	 * @param sortDirection
	 *            \[g
	 * @return alarmInfoList Alarm񃊃Xg
	 */
	public ArrayList getAlarmList(String ipAddress, String sortColumn,
			String sortDirection) {
		/* A[񃊃Xg */
		ArrayList alarmInfoList = null;

		if (!isSocket) {
			DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();

			try {
				/* A[擾 */
				alarmInfoList = alarmDBTable.findAllAlarm(0, ipAddress,
						sortColumn, sortDirection);
			} catch (SQLException e) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Alarm List import error", e.getMessage());
				logger.warning("Alarm List import error " + e.getMessage());
			} catch (DatabaseConnectionException e) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Alarm List import error", e.getMessage());
				logger.warning("Alarm List import error " + e.getMessage());
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionAlarmInformation connectAlarmInfo = new ConnectionAlarmInformation(
					engineAddress);

			try {
				alarmInfoList = connectAlarmInfo.getAlarmInformationList(0,
						ipAddress, null, null);
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e
						.getMessage());
				logger.warning("Node List import error" + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Node List import error", e
						.getMessage());
				logger.warning("Node List import error" + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			}
		}

		return alarmInfoList;
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* j[}l[WZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(alarmAction.getActionShowNodeAlarmListTable());

		/* Alarme[ȗI񒊏o */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			TableItem[] item = table.getSelection();
			String[] alarmInfo = (String[]) item[0].getData();

			if (!isSocket) {
				/* AlarmmFANVZbg */
				((ActionConfirmAlarm) alarmAction.getActionConfirmAlarm())
						.setConfirmAlarm(
								alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO],
								alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
				manager.add(alarmAction.getActionConfirmAlarm());

				/* e[u\Alarm CSVo̓ANVZbg */
				((ActionExportAlarm) exportAction.getActionExportAlarm())
						.setTable(table);
				manager.add(exportAction.getActionExportAlarm());

				/* Im[hAlarm ExportANVZbg */
				((ActionExportAlarmInfo) alarmAction.getActionExportAlarm())
						.setIpAddress(targetNodeInfo.getIpaddress());
				manager.add(alarmAction.getActionExportAlarm());
			} else {
				/* AlarmmFANVZbg */
				((ActionConfirmAlarmSocket) alarmAction
						.getActionConfirmAlarmSocket())
						.setConfirmAlarm(
								alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO],
								alarmInfo[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
				manager.add(alarmAction.getActionConfirmAlarmSocket());

				/* e[u\Alarm CSVo̓ANVZbg */
				((ActionExportAlarm) exportAction.getActionExportAlarm())
						.setTable(table);
				manager.add(exportAction.getActionExportAlarm());

				/* Im[hAlarm ExportANVZbg */
				((ActionExportAlarmInfoSocket) alarmAction
						.getActionExportAlarmSocket())
						.setIpAddress(targetNodeInfo.getIpaddress());
				manager.add(alarmAction.getActionExportAlarmSocket());
			}
		}

		if (!isSocket) {
			/* SAlarm ExportANVZbg */
			((ActionExportAlarmInfo) alarmAction.getActionExportAlarm())
					.setIpAddress(targetNodeInfo.getIpaddress());
			manager.add(alarmAction.getActionExportAlarm());

			/* SAlarmmFANVZbg */
			((ActionConfirmAllAlarm) alarmAction.getActionConfirmAllAlarm())
					.setAlarmIPAddress(targetNodeInfo.getIpaddress());
			manager.add(alarmAction.getActionConfirmAllAlarm());
		} else {
			/* SAlarm ExportANVZbg */
			((ActionExportAlarmInfoSocket) alarmAction
					.getActionExportAlarmSocket()).setIpAddress(targetNodeInfo
					.getIpaddress());
			manager.add(alarmAction.getActionExportAlarmSocket());

			/* SAlarmmFANVZbg */
			((ActionConfirmAllAlarmSocket) alarmAction
					.getActionConfirmAllAlarmSocket())
					.setAlarmIPAddress(targetNodeInfo.getIpaddress());
			manager.add(alarmAction.getActionConfirmAllAlarmSocket());
		}
	}

	/**
	 * J0iNo.j̕Ԃ܂B
	 * 
	 * @return J0iNo.j̕
	 */
	protected int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0NO);
	}

	/**
	 * J1iAlarmoj̕Ԃ܂B
	 * 
	 * @return J1iAlarmoj
	 */
	protected int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1ALARMDETECT);
	}

	/**
	 * J2iNode Namej̕Ԃ܂B
	 * 
	 * @return J2iNode Namej̕
	 */
	protected int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2NODE_NAME);
	}

	/**
	 * J3iNode Groupj̕Ԃ܂B
	 * 
	 * @return J3iNode Groupj̕
	 */
	protected int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3NODE_GROUP);
	}

	/**
	 * J4iIP Addressj̕Ԃ܂B
	 * 
	 * @return J4iIP Addressj
	 */
	protected int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4IPADDRESSP);
	}

	/***************************************************************************
	 * J5iAlarm Messagej̕Ԃ܂B
	 * 
	 * @return J5iAlarm Messagej
	 */
	protected int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5ALARM_MESSAGE);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Alarm View Error=" + errorCount
				+ " Warning=" + warningCount + " Info=" + infoCount);
	}

	/*
	 * A[xɑΉĐ\J[j܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* Alarmx\Imagej */
		if (errorImage != null) {
			errorImage.dispose();
		}

		if (warningImage != null) {
			warningImage.dispose();
		}

		if (infoImage != null) {
			infoImage.dispose();
		}

		if (table != null) {
			table.dispose();
		}
	}

	/**
	 * A[Liste[uViewNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class AlarmTable extends AbstractTableView {
		/* e[uColumn clcik\[g */
		private boolean isCol0Direction = false;

		private boolean isCol1Direction = true;

		private boolean isCol2Direction = true;

		private boolean isCol3Direction = true;

		private boolean isCol4Direction = true;

		private boolean isCol5Direction = true;

		private TableColumn col0;

		private TableColumn col1;

		private TableColumn col2;

		private TableColumn col3;

		private TableColumn col4;

		private TableColumn col5;

		/* e[uColumnImage܂Column(e[u\[gŎgp) */
		private int[] imageColumn = { AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE };

		/**
		 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
		 * 
		 * @param parent
		 *            Composite
		 */
		private Table createTable(Composite parent) {
			GridLayout gridLayout = new GridLayout();
			gridLayout.numColumns = 1;
			parent.setLayout(gridLayout);

			Composite composite = new Composite(parent, SWT.NONE);
			composite.setLayout(new RowLayout(SWT.HORIZONTAL));

			GridData data = new GridData();
			data.horizontalAlignment = GridData.FILL;
			data.grabExcessHorizontalSpace = true;
			composite.setLayoutData(data);

			Label labelAddress = new Label(composite, SWT.NONE);
			labelAddress.setText("Alarm count");

			alarmCountText = new Text(composite, SWT.BORDER | SWT.RIGHT
					| SWT.READ_ONLY);
			alarmCountText.setLayoutData(new RowData(COUNT_TEXT_WIDTH, -1));

			alarmCountText.setEditable(false);
			alarmCountText.setEnabled(false);
			alarmCountText.setBackground(textBackColor);

			refreshButton = new Button(composite, SWT.NONE);
			refreshButton.setText("Refresh");

			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			/*
			 * XV{^Xi[
			 */
			refreshButton.addSelectionListener(new SelectionListener() {
				public void widgetSelected(SelectionEvent event) {
					refreshButton.setEnabled(false);
					setNodeAlarmeView(targetNodeInfo.getIpaddress(),
							sortColumn, sortDirection);
					refreshButton.setEnabled(true);
				}

				public void widgetDefaultSelected(SelectionEvent event) {
				}
			});

			/*
			 * e[uJ
			 */
			col0 = new TableColumn(table, SWT.CENTER);
			col0
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO]);
			col0.setWidth(computeCol0Width());

			col1 = new TableColumn(table, SWT.CENTER);
			col1
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE]);
			col1.setWidth(computeCol1Width());

			col2 = new TableColumn(table, SWT.CENTER);
			col2
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME]);
			col2.setWidth(computeCol2Width());

			col3 = new TableColumn(table, SWT.CENTER);
			col3
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP]);
			col3.setWidth(computeCol3Width());

			col4 = new TableColumn(table, SWT.CENTER);
			col4
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS]);
			col4.setWidth(computeCol4Width());

			col5 = new TableColumn(table, SWT.CENTER);
			col5
					.setText(AlarmListTableViewLabelProvider.ALARM_LIST_TABLE_COLUMNS[AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE]);
			col5.setWidth(computeCol5Width());

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
						}

						/*
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							/*
							 * e[u\Ԃł΃e[uJZbg
							 */
							setResizedTableColumnWidth();
						}
					});

			col0.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol0Direction = sortIntegerTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NO,
							isCol0Direction, imageColumn);
				}
			});

			col1.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol1Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_DETECT_DATE,
							isCol1Direction, imageColumn);
				}
			});
			col2.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol2Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_NODENAME,
							isCol2Direction, imageColumn);
				}
			});
			col3.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol3Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_GROUP,
							isCol3Direction, imageColumn);
				}
			});
			col4.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol4Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_IPADDRESS,
							isCol4Direction, imageColumn);
				}
			});
			col5.addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isCol5Direction = sortTable(
							table,
							AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
							isCol5Direction, imageColumn);
				}
			});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					col0.setWidth(computeCol0Width());
					col1.setWidth(computeCol1Width());
					col2.setWidth(computeCol2Width());
					col3.setWidth(computeCol3Width());
					col4.setWidth(computeCol4Width());
					col5.setWidth(computeCol5Width());

				}
			}
		}

		/*
		 * X[p[NX̃e[uColumn Clickɂ\[g\bh
		 * I[o[ChāAe[uRowForegroundABackground J[yImage\[gɂĂێ܂B
		 * 
		 * @see rctf.rssr.common.view.AbstractTableView#setTableItem
		 *      (org.eclipse.swt.widgets.Table, org.eclipse.swt.widgets.
		 *      TableItem, java.lang.String[])
		 */
		protected TableItem setTableItem(Table table, TableItem item,
				String[] strs) {
			Object obj = item.getForeground();
			Image image1 = item
					.getImage(AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE);
			item.dispose();
			item = new TableItem(table, SWT.NONE);

			item.setText(strs);
			item.setData(strs);
			item.setForeground((org.eclipse.swt.graphics.Color) obj);
			item.setImage(
					AlarmListTableViewLabelProvider.ALARM_LIST_COLUMN_MESSAGE,
					image1);

			return item;
		}
	}

	/**
	 * A[Liste[ũANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * 
	 */
	private final class AlarmAction extends ActionBuilderAlarmList {
		/*
		 * A[e[uɕ\f[^擾Ae[u XVX[p[NX̃\bhI[o[ChāA
		 * w̃m[h̃A[ɂăe[u\܂B
		 * 
		 * @see rctf.rssr.engine.view.model.ActionBuilderAlarmList
		 *      #refreshNodeAlarmTable()
		 */
		public void refreshNodeAlarmTable() {
			/* A[Liste[uXV */
			setNodeAlarmeView(targetNodeInfo.getIpaddress(), sortColumn,
					sortDirection);
		}
	}
}
