/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.jvm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionGarbageCollectionView;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionGarbageCollectionViewSocket;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionGarbageCollection;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;



/**
 * JVM GarbageCollection[e[u\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorGarbageCollection extends AbstractEditorNodeView {
    /* eLXg */
    private static final int TEXT_WIDTH = 200;

    /* Thread Alive Description */
    private static final String ALIVE = "Alive";

    /* Thread No Alive Description */
    private static final String NOALIVE = "No Alive";

    /* MO */
    private static Logger logger;

    /* Pingf[^e[uJRatio */
    private static final float COLUMN0_DATE_RATIO = 0.15f;
    private static final float COLUMN1_DATA_RATIO = 0.15f;

    /* ThreadXe[^X\Text */
    private Text treadStateText;

    /* Thread */
    private Text treadIntervalText;

    /* Max[\Text */
    private Text maxMemoryText;

    /* g[^[\Text */
    private Text totalDataCountText;

    /* ̎Jn\Text */
    private Text collectStartDateText;

    /* ̎ŐV\Text */
    private Text collectEndDateText;

    /* Free[ŏl\Text */
    private Text freeMemoryMinDataText;

    /* Free[ől\Text */
    private Text freeMemoryMaxDataText;

    /* g[^[ŏl\Text */
    private Text totalMemoryMinDataText;

    /* g[^[ől\Text */
    private Text totalMemoryMaxDataText;

    /* Jn{^ */
    private Button startButton;

    /* ~{^ */
    private Button stopButton;

    /* \XV{^ */
    private Button refreshButton;

    /* TableViewer */
    private TableViewer viewer;

    /* Ot\ANV */
    private ActionBuilderChart actionChart = new ActionBuilderChart();

    /* Ot`p̃f[^i[Xgyэ̎f[^i[Xg */
    private ArrayList dateList = new ArrayList();

    /* t[[f[^Xg */
    private ArrayList freeMemoryDataList = new ArrayList();

    /* g[^[f[^Xg */
    private ArrayList totalMemoryDataList = new ArrayList();

    /* ̎Xg */
    private ArrayList dataListList = new ArrayList();

    /* OtXg */
    private ArrayList nameList = new ArrayList();

    /* Ot`p̃f[^őlyэŏl */
    private String[] maxData = new String[2];
    private String[] minData = new String[2];

    /**
     * EditorEBhEɃuEU\邽߂̃CX^X
     * 𐶐܂B
     *
     */
    public EditorGarbageCollection() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isDirty()
     */
    public boolean isDirty() {
        return false;
    }

    /**
     * uEUɃtH[JXZbg܂B
     */
    public void setFocus() {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhE𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        setStatusLine();

        EditorInputNodeView nodeViewEditorInput =
            (EditorInputNodeView) getEditorInput();
        isSocket = nodeViewEditorInput.isSocket();

        /* ScrolledComposite */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);


        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));


        gridLayout0 = new GridLayout(2, false);

        Composite subBaseComposite = new Composite(baseComposite, SWT.LEFT);
        subBaseComposite.setLayout(gridLayout0);
        subBaseComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));

        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite leftComposite = new Composite(subBaseComposite, SWT.LEFT);
        leftComposite.setLayout(gridLayout);
        leftComposite.setLayoutData(
            new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        gridData = new GridData();

        gridLayout = new GridLayout(1, true);

        Composite rightComposite = new Composite(subBaseComposite, SWT.FILL);
        rightComposite.setLayout(gridLayout);

        gridData =
            new GridData(
                GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL);
        rightComposite.setLayoutData(gridData);

        /* Refresh Button */
        refreshButton = new Button(leftComposite, SWT.NONE);
        refreshButton.setText("Refresh");
        refreshButton.setLayoutData(new GridData());

        /* Dummy column */
        Label label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Start Button */
        startButton = new Button(leftComposite, SWT.NONE);
        startButton.setText("Start");
        startButton.setLayoutData(new GridData());

        /* Dummy column */
        label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* Stop Button */
        stopButton = new Button(leftComposite, SWT.NONE);
        stopButton.setText("Stop ");
        stopButton.setLayoutData(new GridData());

        /* Dummy column */
        label = new Label(leftComposite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        // LeftLayout
        label = new Label(leftComposite, SWT.NONE);
        label.setText("Thread state");
        label.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_BEGINNING));
        treadStateText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        treadStateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Thread Interval(sec)");
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        label.setLayoutData(gridData);
        treadIntervalText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        treadIntervalText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Max memory");
        label.setLayoutData(new GridData());
        maxMemoryText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        maxMemoryText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total data count");
        gridData = new GridData();
        label.setLayoutData(gridData);

        totalDataCountText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalDataCountText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Start date");
        label.setLayoutData(new GridData());
        collectStartDateText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        collectStartDateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("End date");
        label.setLayoutData(new GridData());
        collectEndDateText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        collectEndDateText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Free memory max data");
        label.setLayoutData(new GridData());
        freeMemoryMaxDataText = new Text(leftComposite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        freeMemoryMaxDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Free memory min data");
        label.setLayoutData(new GridData());
        freeMemoryMinDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        freeMemoryMinDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total memory max data");
        label.setLayoutData(new GridData());
        totalMemoryMaxDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalMemoryMaxDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText("Total memory min data");
        label.setLayoutData(new GridData());
        totalMemoryMinDataText = new Text(leftComposite, SWT.BORDER);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        totalMemoryMinDataText.setLayoutData(gridData);

        label = new Label(leftComposite, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /*
         * GarbageCollectionf[^e[u
         */
        GarbageCollectionDataTable statisticsTable =
            new GarbageCollectionDataTable();
        table = statisticsTable.createTable(rightComposite);
        viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);

        /* TextɏlZbg */
        setInitText();

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(1200, 800);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * XV{^Xi[
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    refreshButton.setEnabled(false);

                    try {
                        getGarbageCollection();
                    } finally {
                        refreshButton.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
        * GarbageCollection̎Jn{^Xi[
        */
        startButton.addSelectionListener(
            new SelectionListener() {
                /**
                 *
                 */
                public void widgetSelected(SelectionEvent event) {
                    startButton.setEnabled(false);

                    startGarbageCollection();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* GarbageCollection̎~{^Xi[ */
        stopButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    stopButton.setEnabled(false);
                    stopGarbageCollection();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /* ContextMenu𐶐 */
        createContextMenu();
    }

    /*
     * Textݒ肵܂B
     *
     */
    private void setInitText() {
        treadIntervalText.setText("60");

        if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
            treadStateText.setText(ALIVE);
            startButton.setEnabled(false);
            stopButton.setEnabled(true);
        } else {
            treadStateText.setText(NOALIVE);
            startButton.setEnabled(true);
            stopButton.setEnabled(false);
        }

        maxMemoryText.setText(Long.toString(Runtime.getRuntime().maxMemory()));
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[WZbg */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /*
         * ReLXgj[𐶐Zbg
         */
        Menu menu = mm.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, viewer);
    }

    /**
     * j[o[
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /*  */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* GarbageCollection[Ot\ANV */
        String title =
            "GarbageCollection " + AbstractEditorNodeChart.TITLE_SUFFIX;
        System.out.println("isSocket : " + isSocket);

        if (!isSocket) {
            System.out.println("no Socket : " + isSocket);
            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setTitle(title);

            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setMaxData(maxData);
            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setMinData(minData);
            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setDateList(dateList);

            dataListList.clear();
            dataListList.add(freeMemoryDataList);
            dataListList.add(totalMemoryDataList);
            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setDataList(dataListList);

            nameList.clear();
            nameList.add("Free memory");
            nameList.add("Total memory");
            ((ActionGarbageCollectionView) actionChart
            .getActionGarbageCollectionView()).setNameList(nameList);
            manager.add(actionChart.getActionGarbageCollectionView());
        } else {
            System.out.println("Socket : " + isSocket);
            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setTitle(title);

            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setMaxData(maxData);
            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setMinData(minData);
            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setDateList(dateList);

            dataListList.clear();
            dataListList.add(freeMemoryDataList);
            dataListList.add(totalMemoryDataList);
            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setDataList(dataListList);

            nameList.clear();
            nameList.add("Free memory");
            nameList.add("Total memory");
            ((ActionGarbageCollectionViewSocket) actionChart
            .getActionGarbageCollectionViewSocket()).setNameList(nameList);
            manager.add(actionChart.getActionGarbageCollectionViewSocket());
        }
    }

    /*
     * GarbageCollection̎Jn܂B
     *
     */
    private void startGarbageCollection() {
        GarbageCollectionControl garbageControl =
            new GarbageCollectionControl();

        if (!isSocket) {
            /* GarbageCollectionf[^WJn */
            logger.info("GarbageCollection start");

            DBTableGarbageCollection gar =
                DBTableGarbageCollection.getInstance();

            try {
                gar.createTable();
            } catch (DatabaseConnectionException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (SQLException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } finally {
                gar = null;
            }

            int intervalTime = 60000;
            intervalTime = Integer.parseInt(treadIntervalText.getText()) * 1000;
            GarbageCollectionMemoryJVM.getInstance().setSleepTime(intervalTime);
            GarbageCollectionMemoryJVM.getInstance().startThread();

            /**
            * K[x[WRNVf[^̎Jn
            */
            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());

            if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
                treadStateText.setText(ALIVE);
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
            } else {
                treadStateText.setText(NOALIVE);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
            }

            maxMemoryText.setText(
                Long.toString(Runtime.getRuntime().maxMemory()));
        } else {
            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

            ConnectionGarbageCollection garbage =
                new ConnectionGarbageCollection(engineAddress);

            try {
                garbageControl =
                    garbage.startGarbageCollection(treadIntervalText.getText());
                logger.info(
                    "isThreadState : " + garbageControl.isThreadState());
                logger.info("getMaxMemory : " + garbageControl.getMaxMemory());

                if (garbageControl.isThreadState()) {
                    treadStateText.setText(ALIVE);
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                } else {
                    treadStateText.setText(NOALIVE);
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                }

                maxMemoryText.setText(
                    Long.toString(garbageControl.getMaxMemory()));
            } catch (EngineConnectException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            } catch (IOException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            }
        }
    }

    /*
     * GarbageCollection[f[^̎悵܂B
     *
     */
    private void getGarbageCollection() {
        GarbageCollectionControl garbageControl = null;
        ArrayList garbageCollectionDataList = null;

        long totalMemoryMaxData = 0;

        long totalMemoryMinData = 0;

        long freeMemoryMaxData = 0;
        long freeMemoryMinData = 0;
        long totalDataCount = 0;

        if (!isSocket) {
            /*  */
            logger.info("GarbageCollection get info");

            /**
            * K[x[WRNVf[^̎
            */
            DBTableGarbageCollection garDBTable =
                DBTableGarbageCollection.getInstance();

            try {
                garbageCollectionDataList = garDBTable.findAll(null, null);
                garbageControl = garDBTable.getDataCount();
            } catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } finally {
                garDBTable = null;
            }

            if (garbageControl != null) {
                garbageControl.setThreadState(
                    GarbageCollectionMemoryJVM.getInstance().checkThread());
                garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            }

            if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
                treadStateText.setText(ALIVE);
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
            } else {
                treadStateText.setText(NOALIVE);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
            }

            treadIntervalText.setText(
                Long.toString(garbageControl.getIntervalTime()));
            maxMemoryText.setText(
                Long.toString(Runtime.getRuntime().maxMemory()));
        } else {
            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            garbageControl = null;

            ConnectionGarbageCollection garbage =
                new ConnectionGarbageCollection(engineAddress);

            try {
                garbageControl = garbage.getGarbageCollectionInfo(null, null);
            } catch (EngineConnectException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            } catch (IOException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            }

            garbageCollectionDataList =
                garbageControl.getGarbagCollectionMemoryList();

            if (garbageControl.isThreadState()) {
                treadStateText.setText(ALIVE);
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
            } else {
                treadStateText.setText(NOALIVE);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
            }

            treadIntervalText.setText(
                Long.toString(garbageControl.getIntervalTime()));
            maxMemoryText.setText(Long.toString(garbageControl.getMaxMemory()));
        }

        if (garbageControl != null) {
            garbageControl.setGarbagCollectionMemoryList(
                garbageCollectionDataList);

            totalMemoryMaxData = garbageControl.getTotalMemoryMaxData();
            totalMemoryMinData = garbageControl.getTotalMemoryMinData();
            freeMemoryMaxData = garbageControl.getFreeMemoryMaxData();
            freeMemoryMinData = garbageControl.getFreeMemoryMinData();

            if (garbageCollectionDataList != null) {
                totalDataCount = garbageCollectionDataList.size();
                totalDataCountText.setText(Long.toString(totalDataCount));
            }

            freeMemoryMaxDataText.setText(Long.toString(freeMemoryMaxData));
            freeMemoryMinDataText.setText(Long.toString(freeMemoryMinData));
            totalMemoryMaxDataText.setText(Long.toString(totalMemoryMaxData));
            totalMemoryMinDataText.setText(Long.toString(totalMemoryMinData));

            maxData[0] = Long.toString(freeMemoryMaxData);
            maxData[1] = Long.toString(totalMemoryMaxData);
            minData[0] = Long.toString(freeMemoryMinData);
            minData[1] = Long.toString(totalMemoryMinData);

            logger.info("maxData[0] : " + maxData[0]);
            logger.info("maxData[1] : " + maxData[1]);
            logger.info("minData[0] : " + minData[0]);
            logger.info("minData[1] : " + minData[1]);

            if (garbageControl.getStartDate() != null) {
                collectStartDateText.setText(
                    garbageControl.getStartDate().toString());
            }

            if (garbageControl.getEndDate() != null) {
                collectEndDateText.setText(
                    garbageControl.getEndDate().toString());
            }

            setTable(garbageCollectionDataList);
        }
    }

    /*
     * GarbageCollection̎~܂B
     *
     */
    private void stopGarbageCollection() {
        GarbageCollectionControl garbageControl =
            new GarbageCollectionControl();

        if (!isSocket) {
            /*
             * K[x[WRNVf[^̎~
             */
            GarbageCollectionMemoryJVM.getInstance().stopThread();

            logger.info("GarbageCollectionMemoryJVM thread stop");
            garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            garbageControl.setThreadState(
                GarbageCollectionMemoryJVM.getInstance().checkThread());

            logger.info(
                "GarbageCollectionMemoryJVM thread stop thread State : "
                + GarbageCollectionMemoryJVM.getInstance().checkThread());

            if (GarbageCollectionMemoryJVM.getInstance().checkThread()) {
                treadStateText.setText(ALIVE);
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
            } else {
                treadStateText.setText(NOALIVE);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
            }

            maxMemoryText.setText(
                Long.toString(Runtime.getRuntime().maxMemory()));
        } else {
            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

            ConnectionGarbageCollection garbage =
                new ConnectionGarbageCollection(engineAddress);

            try {
                garbageControl = garbage.stopGarbageCollection();
            } catch (EngineConnectException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            } catch (IOException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
                startButton.setEnabled(true);
                stopButton.setEnabled(true);

                Shell shell = new Shell();
                MessageDialog.openError(
                    shell, "Abort Node information get", e.getMessage());
                logger.warning("Abort Node information get" + e.getMessage());
                shell.dispose();

                return;
            }

            if (garbageControl.isThreadState()) {
                treadStateText.setText(ALIVE);
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
            } else {
                treadStateText.setText(NOALIVE);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
            }

            maxMemoryText.setText(Long.toString(garbageControl.getMaxMemory()));
        }
    }

    /*
     * e[u\Zbg܂B
     *
     * @param garbageCollectionDataList [f[^Xg
     */
    private void setTable(ArrayList garbageCollectionDataList) {
        if (
            (garbageCollectionDataList == null)
                || (garbageCollectionDataList.size() < 1)) {
            return;
        }

        /* e[ȗSč폜ătbV */
        table.removeAll();
        viewer.refresh();

        dateList.clear();
        freeMemoryDataList.clear();
        totalMemoryDataList.clear();

        logger.info(
            "garbageCollectionDataList.size() : "
            + garbageCollectionDataList.size());

        for (int i = 0; i < garbageCollectionDataList.size(); i++) {
            GarbageCollectionInfo garbageCollectionInfo =
                (GarbageCollectionInfo) garbageCollectionDataList.get(i);

            String[] garbageCollectionTableCellArray = new String[3];

            garbageCollectionTableCellArray[0] =
                garbageCollectionInfo.getCheckDate().toString();
            garbageCollectionTableCellArray[1] =
                Long.toString(garbageCollectionInfo.getFreeMemory());
            garbageCollectionTableCellArray[2] =
                Long.toString(garbageCollectionInfo.getTotalMemory());

            TableItem item = new TableItem(table, SWT.NULL);

            item.setText(garbageCollectionTableCellArray);
            item.setData(garbageCollectionTableCellArray);

            dateList.add(garbageCollectionTableCellArray[0]);
            freeMemoryDataList.add(garbageCollectionTableCellArray[1]);
            totalMemoryDataList.add(garbageCollectionTableCellArray[2]);

            logger.info(
                "garbageCollectionTableCellArray[0] : "
                + garbageCollectionTableCellArray[0]);
            logger.info(
                "garbageCollectionTableCellArray[1] : "
                + garbageCollectionTableCellArray[1]);
            logger.info(
                "garbageCollectionTableCellArray[2] : "
                + garbageCollectionTableCellArray[2]);
        }
    }

    /**
     * J0iPingf[^̎j̕Ԃ܂B
     *
     * @return J0iPingf[^̎j̕
     */
    private int computeCol0Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN0_DATE_RATIO);
    }

    /**
     * J1iPingf[^j̕Ԃ܂B
     *
     * @return J1iPingf[^j̕
     */
    private int computeCol1Width() {
        return (int) (getSite().getShell().getSize().x * COLUMN1_DATA_RATIO);
    }

    /**
     * Xe[^XCZbg܂B
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);
    }

    /**
     * Tablej܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (table != null) {
            table.dispose();
        }
    }

    /**
     * GarbageCollectione[uViewNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class GarbageCollectionDataTable extends AbstractTableView {
        /* J\[g */
        private boolean[] isColDirection;

        /*
         * Pingf[^\e[u𐶐ĕԂ܂B
         *
         * @return table Table
         */
        private Table createTable(Composite parent) {
            GridData data2 = new GridData();
            data2.horizontalAlignment = GridData.FILL;
            data2.verticalAlignment = GridData.FILL;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;

            table =
                new Table(
                    parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            table.setLayoutData(data2);

            isColDirection = new boolean[3];

            TableColumn[] col = new TableColumn[3];

            col[0] = new TableColumn(table, SWT.CENTER);
            col[0].setText("Date");
            col[0].setWidth(computeCol0Width());
            isColDirection[0] = true;

            col[0].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event e) {
                        // Object te = e.item.getData();
                        // System.out.println("test : " + te);

                        /* J\[gA\[gێ */
                        isColDirection[0] =
                            sortTable(table, 0, isColDirection[0]);
                    }
                });

            col[1] = new TableColumn(table, SWT.CENTER);
            col[1].setText("Free memory");
            col[1].setWidth(computeCol1Width());
            isColDirection[1] = true;

            col[1].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event e) {
                        /* J\[gA\[gێ */
                        isColDirection[1] =
                            sortIntegerTable(table, 1, isColDirection[1]);
                    }
                });

            col[2] = new TableColumn(table, SWT.CENTER);
            col[2].setText("Total memory");
            col[2].setWidth(computeCol0Width());
            isColDirection[2] = true;

            col[2].addListener(
                SWT.Selection,
                new Listener() {
                    public void handleEvent(Event e) {
                        /* J\[gA\[gێ */
                        isColDirection[2] =
                            sortIntegerTable(table, 2, isColDirection[2]);
                    }
                });

            /**
             * e[uړꍇ͂TCYꍇ̃Xi[łB
             *
             */
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
                      .addControlListener(
                new ControlListener() {
                    /**
                     * e[uړ̏łB
                     *
                     * @param event ControlEvent
                     */
                    public void controlMoved(ControlEvent event) {
                        // nothing
                    }

                    /**
                     * e[uTCY̏łB
                     *
                     * @param event ControlEvent
                     */
                    public void controlResized(ControlEvent event) {
                        // nothing
                    }
                });

            return table;
        }
        protected void setResizedTableColumnWidth() {
        	
        }
    }
}
