/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodeSnmpStatisticsChartView;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodeSnmpStatisticsChartViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable.ActionShowStatisticsData;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable.ActionShowStatisticsDataSocket;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodeSnmpStatisticsTable;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;



/**
 * j[}l[W⃁j[Ƀm[hSNMPv񃁃j[ǉ
 * \bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeSnmpStatisticsMenu {
    /* MO */
    private static Logger logger;

    /* 摜肷邽߂PluginResource bundle */
    private Bundle bundle;

    /* OtImage */
    private Image chartImage;

    /* Table Image */
    private Image tableImage;

    /* Ot`ANV */
    private ActionBuilderChart nodeChart = new ActionBuilderChart();

    /* m[hf[^e[uANV */
    private ActionBuilderNodeDataTable dataTableAction =
        new ActionBuilderNodeDataTable();

    /**
     * j[}l[W⃁j[Ƀm[hSNMPv񃁃j[ǉ
     * \bhNXCX^X𐶐܂B
     *
     */
    public NodeSnmpStatisticsMenu() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hSnmpv̎撆̏ꍇSnmpv\j[
     * j[}l[Wɒǉ܂B
     *
     * @param manager j[}l[W
     * @param targetNodeInfo m[hĎ
     * @param isSocket lbg[NoRŏ擾邩ۂtO
     */
    public void createSnmpStatisticsMenu(
        IMenuManager manager, NodeInformation targetNodeInfo, boolean isSocket) {
        String ipAddress = targetNodeInfo.getIpaddress();
        ArrayList nodeOidList = getStatisticsMibInfo(ipAddress, isSocket);

        if ((nodeOidList != null) && (nodeOidList.size() > 0)) {
            /* Menu}l[Wɐ */
            MenuManager snmpStatisticsMenu =
                new MenuManager(MenuPreference.NODE_SNMP_STATISTICS_DATA);
            manager.add(snmpStatisticsMenu);
            snmpStatisticsMenu.add(new Separator());

            /*
             * m[hSnmpvĎOID[vOID
             * j[
             */
            for (int j = 0; j < nodeOidList.size(); j++) {
                String oid = (String) nodeOidList.get(j);

                String oidDescription = "";

                /* OIDɑΉDescription */
                if (
                    ManagerMibTree.getInstance().getOidHashMap().containsKey(
                            oid)) {
                    MibInfo miboid =
                        (MibInfo) ManagerMibTree.getInstance().getOidHashMap()
                                                .get(oid);
                    oidDescription = miboid.getDescrip();
                }

                if (!isSocket) {
                    ActionShowStatisticsData snmpStatisticsOidAction =
                        ((ActionShowStatisticsData) dataTableAction
                        .actionShowStatisticsData());
                    snmpStatisticsOidAction.setNodeInfo(targetNodeInfo);
                    snmpStatisticsOidAction.setOid(oid);
                    snmpStatisticsOidAction.setText(
                        oidDescription + "  OID=" + oid);
                    snmpStatisticsOidAction.setToolTipText(
                        oidDescription + "  OID=" + oid);

                    snmpStatisticsMenu.add(snmpStatisticsOidAction);
                } else {
                    ActionShowStatisticsDataSocket snmpStatisticsOidAction =
                        ((ActionShowStatisticsDataSocket) dataTableAction
                        .actionShowStatisticsDataSocket());
                    snmpStatisticsOidAction.setNodeInfo(targetNodeInfo);
                    snmpStatisticsOidAction.setOid(oid);
                    snmpStatisticsOidAction.setText(
                        oidDescription + "  OID=" + oid);
                    snmpStatisticsOidAction.setToolTipText(
                        oidDescription + "  OID=" + oid);
                    snmpStatisticsMenu.add(snmpStatisticsOidAction);
                }

                /*
                 *
                 */
                ArrayList snmpStatisticsNameList = null;

                try {
                    snmpStatisticsNameList =
                        getStatisticsMibInfo(
                            targetNodeInfo.getIpaddress(), oid, isSocket);
                } catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());

                    return;
                } catch (SQLException e) {
                    logger.warning(e.getMessage());

                    return;
                }

                if (!isSocket) {
                    ActionNodeSnmpStatisticsChartView actionSnmpStatistics =
                        null;
                    actionSnmpStatistics =
                        (ActionNodeSnmpStatisticsChartView) nodeChart
                        .getNewActionNodeSnmpStatisticsChartView();

                    actionSnmpStatistics.setText(
                        oidDescription + "  OID=" + oid);
                    actionSnmpStatistics.setToolTipText(
                        oidDescription + "  OID=" + oid);

                    String title =
                        targetNodeInfo.getNodename() + "("
                        + targetNodeInfo.getIpaddress() + ") " + " OID=" + oid
                        + AbstractEditorNodeChart.TITLE_SUFFIX;
                    actionSnmpStatistics.setTitle(title);
                    actionSnmpStatistics.setNodeInfo(targetNodeInfo);
                    actionSnmpStatistics.setOid(oid);
                    actionSnmpStatistics.setNameList(snmpStatisticsNameList);

                    snmpStatisticsMenu.add(actionSnmpStatistics);
                } else {
                    ActionNodeSnmpStatisticsChartViewSocket actionSnmpStatistics =
                        null;
                    actionSnmpStatistics =
                        (ActionNodeSnmpStatisticsChartViewSocket) nodeChart
                        .getNewActionNodeSnmpStatisticsChartViewSocket();

                    actionSnmpStatistics.setText(
                        oidDescription + "  OID=" + oid);
                    actionSnmpStatistics.setToolTipText(
                        oidDescription + "  OID=" + oid);

                    String title =
                        targetNodeInfo.getNodename() + "("
                        + targetNodeInfo.getIpaddress() + ") " + " OID=" + oid
                        + AbstractEditorNodeChart.TITLE_SUFFIX;
                    actionSnmpStatistics.setTitle(title);
                    actionSnmpStatistics.setNodeInfo(targetNodeInfo);
                    actionSnmpStatistics.setOid(oid);
                    actionSnmpStatistics.setNameList(snmpStatisticsNameList);

                    snmpStatisticsMenu.add(actionSnmpStatistics);
                }
            }
        }
    }

    /**
     * m[hSNMPv̎撆̏ꍇSNMPv\j[
     * j[ɒǉ܂B
     *
     * @param popUpMenu Menu
     * @param targetNodeInfo m[hĎ
     * @param isSocket SocketoRŏ擾邩ۂtO
     */
    public void createSnmpStatisticsMenu(
        Menu popUpMenu, NodeInformation targetNodeInfo, boolean isSocket) {
        /*
         * m[hSnmpv̎撆OIDXgƂĎ擾
         */
        String ipAddress = targetNodeInfo.getIpaddress();
        ArrayList nodeOidList = getStatisticsMibInfo(ipAddress, isSocket);

        /*
         * OIDɃj[𐶐
         */
        if ((nodeOidList != null) && (nodeOidList.size() > 0)) {
            MenuItem snmpStatisticsMenuItem =
                new MenuItem(popUpMenu, SWT.CASCADE);
            snmpStatisticsMenuItem.setText(
                MenuPreference.NODE_SNMP_STATISTICS_DATA);

            Menu submenu = new Menu(snmpStatisticsMenuItem);
            snmpStatisticsMenuItem.setMenu(submenu);

            MenuItem[] menuItemSnmpStatistics =
                new MenuItem[nodeOidList.size() * 2];

            /* 摜肷邽߂PluginResource bundle */
            bundle = NetJFWatcherPlugin.getInstance().getBundle();

            ImageDescriptor chartImageDescriptor =
                ImageDescriptor.createFromURL(
                    bundle.getEntry(MenuPreference.CHART_IMAGE_FILE));
            ImageDescriptor tableImageDescriptor =
                ImageDescriptor.createFromURL(
                    bundle.getEntry(MenuPreference.TABLE_IMAGE_FILE));

            if (chartImage == null) {
                chartImage = chartImageDescriptor.createImage();
            }

            if (tableImage == null) {
                tableImage = tableImageDescriptor.createImage();
            }

            for (int j = 0; j < nodeOidList.size(); j++) {
                String oid = (String) nodeOidList.get(j);

                String oidDescription = "";

                /* OIDɑΉDescription */
                if (
                    ManagerMibTree.getInstance().getOidHashMap().containsKey(
                            oid)) {
                    MibInfo miboid =
                        (MibInfo) ManagerMibTree.getInstance().getOidHashMap()
                                                .get(oid);
                    oidDescription = miboid.getDescrip();
                }

                /*
                 * e[u\j[
                 */
                menuItemSnmpStatistics[j] = new MenuItem(submenu, SWT.PUSH);
                menuItemSnmpStatistics[j].setText(
                    oidDescription + "  OID=" + oid + " Table");
                menuItemSnmpStatistics[j].setImage(tableImage);

                NodeMapMenuNodeSnmpStatisticsTable nodeSnmp =
                    new NodeMapMenuNodeSnmpStatisticsTable(
                        targetNodeInfo, isSocket, oid);
                menuItemSnmpStatistics[j].addSelectionListener(nodeSnmp);

                /*
                 * Ot\j[
                 */
                ArrayList snmpStatisticsNameList = null;

                try {
                    snmpStatisticsNameList =
                        getStatisticsMibInfo(
                            targetNodeInfo.getIpaddress(), oid, isSocket);
                } catch (DatabaseConnectionException e) {
                    logger.warning(e.getMessage());
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                }

                menuItemSnmpStatistics[j * 2] = new MenuItem(submenu, SWT.PUSH);
                menuItemSnmpStatistics[j * 2].setText(
                    oidDescription + "  OID=" + oid + " Chart");
                menuItemSnmpStatistics[j * 2].setImage(chartImage);

                NodeMapMenuNodeSnmpStatisticsChart nodeSnmpChart =
                    new NodeMapMenuNodeSnmpStatisticsChart(
                        targetNodeInfo, isSocket, oid, snmpStatisticsNameList);
                menuItemSnmpStatistics[j * 2].addSelectionListener(
                    nodeSnmpChart);
            }
        }
    }

    /**
     * wIPAhXm[hSNMPv̎撆OIDf[^x[X
     * 擾ĕԂ܂B
     *
     * @param ipAddress m[hIPAhX
     * @param isSocket SocketoRŏ̎悷邩ۂtO
     * @return oidList SNMPv̎OIDXg
     */
    protected ArrayList getStatisticsMibInfo(
        String ipAddress, boolean isSocket) {
        ArrayList oidList = new ArrayList();
        ArrayList statisticsMibSetStatusList = null;

        if (!isSocket) {
            DBTableStatisticsMIBControl mibDBTable =
                DBTableStatisticsMIBControl.getInstance();

            try {
                statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
            } catch (SQLException e1) {
                logger.warning(e1.getMessage() + " IP=" + ipAddress);
            } catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage() + " IP=" + ipAddress);
            }
        } else {
            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand(
                StatisticsMibControl.STATISTICS_SET_STATUS_GET);
            control.setIpaddress(ipAddress);

            ConnectionStatisticsMibGet statisticsMibGet =
                new ConnectionStatisticsMibGet(engineAddress);

            try {
                StatisticsMibProperty mibproperty =
                    statisticsMibGet.getStatisticsMib(control);

                if (mibproperty != null) {
                    statisticsMibSetStatusList =
                        mibproperty.getStatisticsMibSetList();
                }
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }

        if (statisticsMibSetStatusList == null) {
            return null;
        }

        for (int i = 0; i < statisticsMibSetStatusList.size(); i++) {
            StatisticsMibSetStatus snmpStatisticsStatus =
                (StatisticsMibSetStatus) statisticsMibSetStatusList.get(i);

            oidList.add(snmpStatisticsStatus.getReadOid());
        }

        return oidList;
    }

    /*
     * m[h̎wOID̃CX^XListɂĕԂ܂B
     * OIDCX^XInterfacȅꍇɂifDescriptionListɂ
     * Ԃ܂B
     *
     * @param ipAddress m[hIP Address
     * @param selectOid OID
     * @return nameList OIDCX^XList
     * @throws DatabaseConnectionException
     * @throws SQLException
     */
    private ArrayList getStatisticsMibInfo(
        String ipAddress, String selectOid, boolean isSocket)
        throws DatabaseConnectionException, SQLException {
        ArrayList ifDescriptorList = null;

        if (!isSocket) {
            DBTableStatisticsMIBControl mibDBTable =
                DBTableStatisticsMIBControl.getInstance();

            ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
        } else {
            /* vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾邽߂̃CX^XZbg */
            StatisticsMibControl control = new StatisticsMibControl();
            control.setSubCommand(StatisticsMibControl.IF_DESCRIPTOR_GET);
            control.setIpaddress(ipAddress);

            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            ConnectionStatisticsMibGet statisticsMibGet =
                new ConnectionStatisticsMibGet(engineAddress);

            try {
                StatisticsMibProperty mibproperty =
                    statisticsMibGet.getStatisticsMib(control);
                ifDescriptorList = mibproperty.getMibIfDescriptorList();
            } catch (EngineConnectException e) {
                logger.warning("EngineConnectException " + e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning("IOException " + e.getMessage());
                e.printStackTrace();
            }
        }

        /* m[h̎wOID̃CX^Xi[List */
        ArrayList nameList = new ArrayList();

        /* wOID̃CX^X𒊏oăXgɊi[ */
        for (int i = 0; i < ifDescriptorList.size(); i++) {
            StatisticsMibIfDescriptor mibIfDesc =
                (StatisticsMibIfDescriptor) ifDescriptorList.get(i);
            String workOid = mibIfDesc.getOid();

            int checkPoint = "Oid=".length();

            if (checkPoint >= 0) {
                /* w肳ꂽOIDɈvCX^XXgɊi[ */
                if (workOid.substring(checkPoint).equals(selectOid)) {
                    if (mibIfDesc.getIfDescriptor().equals("")) {
                        /*  */
                        nameList.add(mibIfDesc.getInstance());
                        logger.info("mibIfDesc : " + mibIfDesc.getInstance());
                    } else {
                        /*  */
                        nameList.add(
                            mibIfDesc.getInstance() + " ("
                            + mibIfDesc.getIfDescriptor() + ")");
                        logger.info(
                            "mibIfDesc : " + mibIfDesc.getInstance() + " ("
                            + mibIfDesc.getIfDescriptor() + ")");
                    }
                }
            }
        }

        return nameList;
    }

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();

        if (chartImage != null) {
            chartImage.dispose();
        }

        if (tableImage != null) {
            tableImage.dispose();
        }
    }
}
