/*
 * Created on 2004/09/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpv3;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.crypto.Cipher;

import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.snmp.preference.SnmpV3Preference;


/**
 * UserName@SnmpEngineIDUSM(User based Security Model)
 * ǗVOgNXłB
 * [UauthPrivKeyȂǂ𐶐AXgɕێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class UsmUserManager {
    /** Auth/PrivɂF؂ȂÍȂ\R[h */
    public static final String AUTHPRIV_NOAUTH = "NOAUTH";

    /** Auth/PrivɂF؂AÍȂ\R[h */
    public static final String AUTHPRIV_AUTH = "AUTH";

    /** Auth/PrivɂF؂AÍ\R[h */
    public static final String AUTHPRIV_PRIV = "PRIV";

    /** F؂ɂMD5vgR */
    public static final String MSG_DIGEST_MD5 = "MD5";
    /** F؂ɂSHAvgR */
    public static final String MSG_DIGEST_SHA1 = "SHA-1";

    /** Cipher(Í)ɂDES Description */
    public static final String CIPHER_DES = "DES";

    /** F؂ɂMD5 Description */
    public static final String AUTH_PROTOCOL_MD5 = "MD5";
    /** F؂ɂSHA Description */
    public static final String AUTH_PROTOCOL_SHA = "SHA";
    /** ÍɂDES Description */
    public static final String PRIV_PROTOCOL_DES = "DES";


    /* MO */
    private static Logger logger;

    /* userName@snmpEngineID L[Ƃ UsmUserEntry ̃Xg */
    private Map userEntryList = Collections.synchronizedMap(new Hashtable());

    /* UsmUserEntry ̃Xg */
    private List usmUserEntryList =
        Collections.synchronizedList(new ArrayList());

    /*
     * <p>UsmUserManager ̃CX^X𐶐܂B</p>
     */
    private UsmUserManager() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static UsmUserManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * ^G[pUSM[UGg[܂B
     *
     * @param userName [U
     * @param snmpEngineID EngineID
     * @param usmUserEntry UsmUserEntry
     */
    public synchronized void testUsmUserEntry(
        String userName, String snmpEngineID, UsmUserEntry usmUserEntry) {
        // o^
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID);

        if (userEntryList.containsKey(sb.toString())) {
            userEntryList.put(sb.toString(), usmUserEntry);
            usmUserEntryList.add(usmUserEntry);
        } else {
            logger.warning("Notfound Regist userName : " + sb.toString());
        }
    }

    /**
     * SNMP}l[Wɂ郆[UAuthɊւvgRAKeyPriv
     * ւvgRAKeyo^܂B
     *
     * @param snmpEngineID engineIDCX^X
     * @param info Snmp}l[WǗG[WFgCX^X
     * @throws SnmpV3ConfigurationException F/Íx`̏ꍇ܂
     * F/ÍASY`̏ꍇ
     */
    public synchronized void registList(
        final SnmpEngineID snmpEngineID, final SnmpV3ManagerConfigInfo info)
        throws SnmpV3ConfigurationException {
        String userName = null;
        String authPriv = null;
        String authProtocol = null;
        String authPassPhrase = null;
        String privProtocol = null;
        String privPassPhrase = null;

        if (
            (info == null)
                || ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0) == null)) {
            logger.warning("SnmpV3 Manager Config undefined");
            throw new SnmpV3ConfigurationException(
                "SnmpV3 Manager Config undefined");
        }

        userName =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getUsername();
        authPriv =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getAuthPriv();
        authProtocol =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getAuthProtocol();
        authPassPhrase =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getAuthPassPhrase();
        privProtocol =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getPrivProtocol();
        privPassPhrase =
            ((SnmpV3ManagerUserConfigInfo) info.getUserList().get(0))
            .getPrivPassPhrase();

        if (authPriv == null) {
            logger.warning("AuthPriv undefined");
            throw new SnmpV3ConfigurationException("AuthPriv undefined");
        }

        boolean error = false;

        if ((userName == null) || (authPriv == null)) {
            error = true;
        }

        if (authPriv.equals(SnmpV3Preference.NOAUTH)) {
            authProtocol = null;
            privProtocol = null;
        } else if (authPriv.equals(SnmpV3Preference.AUTH)) {
            privProtocol = null;

            if (
                (authProtocol == null)
                    || !(authProtocol.equals(AUTH_PROTOCOL_MD5)
                    || authProtocol.equals(AUTH_PROTOCOL_SHA))) {
                error = true;
            }

            if (authPassPhrase == null) {
                error = true;
            }
        } else if (authPriv.equals(AUTHPRIV_PRIV)) {
            if (
                (privProtocol == null)
                    || !privProtocol.equals(PRIV_PROTOCOL_DES)) {
                error = true;
            }

            if (privPassPhrase == null) {
                error = true;
            }
        } else {
            error = true;
        }

        if (error) {
            logger.warning("AuthPriv undefined");
            throw new SnmpV3ConfigurationException("AuthPriv undefined");
        }

        // UsmUserEntry
        UsmUserEntry usmUserEntry = new UsmUserEntry();
        usmUserEntry.setUsmUserEngineID(snmpEngineID);
        usmUserEntry.setUsmUserName(userName);
        usmUserEntry.setUsmUserSecurityName(userName);
        usmUserEntry.setUsmUserCloneFrom(SnmpV3OID.ZERO_DOT_ZERO);

        try {
            if (authProtocol == null) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_NO_AUTH_PROTOCOL);
            } else if (authProtocol.equals(MSG_DIGEST_MD5)) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_HMAC_MD5_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(
                    new UsmLocalizeKey(
                        authPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_MD5));
            } else if (authProtocol.equals(AUTH_PROTOCOL_SHA)) {
                usmUserEntry.setUsmUserAuthProtocol(
                    UsmUserEntry.USM_HMAC_SHA_AUTH_PROTOCOL);
                usmUserEntry.setUsmUserAuthKey(
                    new UsmLocalizeKey(
                        authPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_SHA));
            }
        } catch (NoSuchAlgorithmException e) {
            throw new SnmpV3ConfigurationException(e.toString());
        }

        usmUserEntry.setUsmUserAuthKeyChange("");
        usmUserEntry.setUsmUserOwnAuthKeyChange("");

        try {
            if (privProtocol == null) {
                usmUserEntry.setUsmUserPrivProtocol(
                    UsmUserEntry.USM_NO_PRIV_PROTOCOL);
            } else if (privProtocol.equals(PRIV_PROTOCOL_DES)) {
                usmUserEntry.setUsmUserPrivProtocol(
                    UsmUserEntry.USM_DES_PRIV_PROTOCOL);

                if (authProtocol.equals(MSG_DIGEST_MD5)) {
                    usmUserEntry.setUsmUserPrivKey(
                        new UsmLocalizeKey(
                            privPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_MD5));
                } else if (authProtocol.equals(AUTH_PROTOCOL_SHA)) {
                    usmUserEntry.setUsmUserPrivKey(
                        new UsmLocalizeKey(
                            privPassPhrase, snmpEngineID, UsmLocalizeKey.KEY_GEN_ALGO_HMAC_SHA));
                }
            }
        } catch (NoSuchAlgorithmException e) {
            logger.warning(e.getMessage());
            throw new SnmpV3ConfigurationException(e.getMessage());
        }

        usmUserEntry.setUsmUserPrivKeyChange("");
        usmUserEntry.setUsmUserOwnPrivKeyChange("");
        usmUserEntry.setUsmUserPublic("");
        usmUserEntry.setUsmUserStorageType(UsmUserEntry.VOLATILE);
        usmUserEntry.setUsmUserStatus(UsmUserEntry.ACTIVE);

        // o^
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());

        userEntryList.put(sb.toString(), usmUserEntry);
        usmUserEntryList.add(usmUserEntry);
    }

    /**
     * w肳ꂽ snmpEngineID  userName  UsmUserEntry Ԃ܂B
     * vȂꍇ null Ԃ܂B
     *
     * @param snmpEngineID SnmpEngineID
     * @param userName [U
     * @return UsmUserEntry
     */
    public UsmUserEntry getUsmUserEntry(
        SnmpEngineID snmpEngineID, String userName) {
        StringBuffer sb = new StringBuffer();
        sb.append(userName).append("@");
        sb.append(snmpEngineID.toString());

        return (UsmUserEntry) userEntryList.get(sb.toString());
    }

    /**
     * 擪 n Ԗڂ UsmUserEntry Ԃ܂B
     * w肳ꂽԍ UsmUserEntry ݂Ȃꍇ null Ԃ܂B
     *
     * @param n 擪̔ԍ
     * @return UsmUserEntry
     */
    public UsmUserEntry getUsmUserEntry(int n) {
        if ((n < 0) || (n >= usmUserEntryList.size())) {
            return null;
        }

        return (UsmUserEntry) usmUserEntryList.get(n);
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final UsmUserManager RESOURCE = new UsmUserManager();
    }
}
