/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.io.FileNotFoundException;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentDataImportException;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.model.AgentTableListener;
import netjfwatcher.snmpagent.process.ThreadAgent;
import netjfwatcher.snmpmanager.OidTreeListener;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * SNMP Agente[ur[\NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentTableView extends AbstractTableView {
	/** Snmp AgentXbhAliveԕ\(Xe[^XCɕ\) */
	public final static String AGENT_THREAD_ALIVE_MESSAGE = "Agent thread status is active";

	/** Snmp AgentXbhDeadԕ\(Xe[^XCɕ\) */
	public final static String AGENT_THREAD_DEAD_MESSAGE = "Agent thread status is stop";

	/* Agente[u\f[^ĎThreadĎ(ms) */
	private final static int AGENT_INSTANCE_CHECK_THREAD_TIMER = 1000;

	/* e[u\\[gɂJ0\[g */
	private static boolean isCol0Direction = false;

	/* e[u\\[gɂJ1\[g */
	private static boolean isCol1Direction = true;

	/* e[u\\[gɂJ2\[g */
	private static boolean isCol2Direction = true;

	/* e[u\\[gɂJ3\[g */
	private static boolean isCol3Direction = true;

	/* e[u\\[gɂJ4\[g */
	private static boolean isCol4Direction = true;

	/* e[u\\[gɂJ5\[g */
	private static boolean isCol5Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;

	/* MO */
	private static Logger logger = null;

	/* AgentCX^Xe[uJRatio */
	private static final float COLUM0_INSTANCE_NO_RATIO = 0.03f;

	private static final float COLUM1_OID_DESC_RATIO = 0.25f;

	private static final float COLUM2_OID_RATIO = 0.15f;

	private static final float COLUM3_VALUE_RATIO = 0.35f;

	private static final float COLUM4_TYPE_RATIO = 0.1f;

	private static final float COLUM5_ACCESS_RATIO = 0.1f;

	/* Display */
	private Display display;

	/* Agent MIBCX^XXVĎThread */
	private AgentTableShowTimerProcessor agentTableShowThread;

	/* Agent MIBCX^XTable */
	private Table mibInstnaceTable;

	/* TableViewer */
	private TableViewer viewer;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* SNMP Agente[uViewANVr_[ */
	private ActionBuilderAgentTable actionAgentTableBuilder;

	/**
	 * SNMP agente[ur[\NXCX^X𐶐܂B
	 * 
	 */
	public AgentTableView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderAgentTable getActionBuilder() {
		return actionAgentTableBuilder;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* Agente[u\f[^ĎThreadĎNJn */
		agentTableShowThread = new AgentTableShowTimerProcessor();
		display = parent.getDisplay();
		display.timerExec(AGENT_INSTANCE_CHECK_THREAD_TIMER,
				agentTableShowThread);

		/* e[u */
		createTable(parent);
		viewer = new TableViewer(mibInstnaceTable);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new AgentTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new AgentTableViewLabelProvider());

		actionAgentTableBuilder = new ActionBuilderAgentTable(mibInstnaceTable,
				statusLineManager);

		/* ReLXgj[EZbg */
		createContextMenu();

		/* ANV */
		initActions();

		/* G[WFg̃ftHgCX^Xf[^ǂݍ */
		String csvFile = FilePreference.DEFAULT_AGENT_FILE;
		AgentDataImport importAgentData = new AgentDataImport();

		try {
			importAgentData.setDefaultAgentData(csvFile, mibInstnaceTable);
		} catch (FileNotFoundException e) {
			logger.warning("Snmp agent initial error " + e.getMessage());

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);

			alertMessageBox.setMessage("Snmp agent initial error "
					+ e.getMessage());
			alertMessageBox.open();
			e.printStackTrace();
		} catch (AgentDataImportException e) {
			logger.warning("Snmp agent initial error " + e.getMessage());

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);

			alertMessageBox.setMessage("Snmp agent initial error "
					+ e.getMessage());
			alertMessageBox.open();
			e.printStackTrace();
		}

		/* G[WFgMThreadN */
		startAgent();
	}

	/*
	 * G[WFgMThreadN܂B
	 * 
	 */
	private void startAgent() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		/* G[WFgMThreadN */
		ThreadAgent agentThread;
		agentThread = ThreadAgent.getInstance();

		boolean isSuccessAgentThread = false;

		try {
			isSuccessAgentThread = agentThread.startThread(false);
		} catch (SocketException e1) {
			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);

			alertMessageBox.setMessage("Abort start SNMP Agent : "
					+ e1.getMessage());
			alertMessageBox.open();

			/* TrapMXbhԂXe[^XCɕ\ */
			if (agentThread.checkThread()) {
				statusLineManager.setMessage(AGENT_THREAD_ALIVE_MESSAGE);
			} else {
				statusLineManager.setMessage(AGENT_THREAD_DEAD_MESSAGE);
			}

			return;
		}

		if (!isSuccessAgentThread) {
			if (getSite().getPage().isPartVisible(getSite().getPart())) {
				MessageBox alertMessageBox = new MessageBox(getViewSite()
						.getShell(), SWT.YES | SWT.ICON_WARNING);

				alertMessageBox.setMessage("Abort agent start");
				alertMessageBox.open();
			}
		}

		/* TrapMXbhԂXe[^XCɕ\ */
		if (agentThread.checkThread()) {
			statusLineManager.setMessage(AGENT_THREAD_ALIVE_MESSAGE);
		} else {
			statusLineManager.setMessage(AGENT_THREAD_DEAD_MESSAGE);
		}
	}

	/**
	 * J0iCX^XNo.j̕Ԃ܂B
	 * 
	 * @return J0iCX^XNo.j̕
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUM0_INSTANCE_NO_RATIO);
	}

	/**
	 * J1iOID Descriptionj̕Ԃ܂B
	 * 
	 * @return J1iOID Descriptionj̕
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUM1_OID_DESC_RATIO);
	}

	/**
	 * J2iOIDj̕Ԃ܂B
	 * 
	 * @return J2iOIDj̕
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUM2_OID_RATIO);
	}

	/**
	 * J3iValuej̕Ԃ܂B
	 * 
	 * @return J3iValuej̕
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUM3_VALUE_RATIO);
	}

	/**
	 * J4iTYpej̕Ԃ܂B
	 * 
	 * @return J4iTYpej̕
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUM4_TYPE_RATIO);
	}

	/**
	 * J5iAccessj̕Ԃ܂B
	 * 
	 * @return J5iAccessj̕
	 */
	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUM5_ACCESS_RATIO);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 */
	private void createTable(Composite parent) {
		mibInstnaceTable = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		mibInstnaceTable.setLinesVisible(true);
		mibInstnaceTable.setHeaderVisible(true);

		/* Column0 CX^XNo. */
		col0 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col0
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.AGENT_MIB_INSTANCE_NO]);
		col0.setWidth(computeCol0Width());

		/* Column1 OID Description */
		col1 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col1
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.OID_DESC]);
		col1.setWidth(computeCol1Width());

		/* Column2 OID */
		col2 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col2
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.OID]);
		col2.setWidth(computeCol1Width());

		/* Column3 OID Value */
		col3 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col3
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.VALUE]);
		col3.setWidth(computeCol1Width());

		/* Column4 OID Type */
		col4 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col4
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.TYPE]);
		col4.setWidth(computeCol1Width());

		/* Column5 OID Access */
		col5 = new TableColumn(mibInstnaceTable, SWT.LEFT);
		col5
				.setText(AgentTableViewLabelProvider.COLUMNS[AgentTableViewLabelProvider.ACCESS]);
		col5.setWidth(computeCol1Width());

		/*
		 * TableōsNbNꂽꍇ̏ōsAȂ킿OIDCX^X ̏擾
		 */
		mibInstnaceTable.addSelectionListener(new AgentTableListener(
				mibInstnaceTable));

		/*
		 * Window䃊Xi[Zbg
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					/*
					 * SNMPG[WFge[uResizedCxgŃJĐݒ肵܂B
					 * 
					 */
					public void controlResized(ControlEvent event) {
						/*
						 * SNMPG[WFge[u\Ԃł e[uJZbg
						 */
						setResizedTableColumnWidth();
					}
				});

		/**
		 * J0wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* Instance No.J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(mibInstnaceTable,
						AgentTableViewLabelProvider.AGENT_MIB_INSTANCE_NO,
						isCol0Direction);
			}
		});
		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* OID DescriptionJ\[gA\[gێ */
				isCol1Direction = sortTable(mibInstnaceTable,
						AgentTableViewLabelProvider.OID_DESC, isCol1Direction);
			}
		});
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* OIDJ\[gA\[gێ */
				isCol2Direction = sortTable(mibInstnaceTable,
						AgentTableViewLabelProvider.OID, isCol2Direction);
			}
		});
		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* ValueJ\[gA\[gێ */
				isCol3Direction = sortTable(mibInstnaceTable,
						AgentTableViewLabelProvider.VALUE, isCol3Direction);
			}
		});
		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* TypeJ\[gA\[gێ */
				isCol4Direction = sortTable(mibInstnaceTable,
						AgentTableViewLabelProvider.TYPE, isCol4Direction);
			}
		});
		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* AccessJ\[gA\[gێ */
				isCol5Direction = sortTable(mibInstnaceTable,
						AgentTableViewLabelProvider.ACCESS, isCol5Direction);
			}
		});
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());

			}

		}
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		manager.add(getActionBuilder().actionStartAgent());
		manager.add(getActionBuilder().actionStopAgent());
		manager.add(getActionBuilder().actionImportAgentFile());

		/*
		 * manager.add(getActionBuilder().actionMonitorStart());
		 * manager.add(getActionBuilder().actionMonitorStop());
		 * manager.add(getActionBuilder().actionMonitorRestart());
		 */
	}

	/**
	 * ReLXgj[𐶐AZbg܂B
	 * 
	 */
	private void createContextMenu() {
		/* Menu}l[W */
		MenuManager mm = new MenuManager();

		/* Menu}l[Wĕ\ */
		mm.setRemoveAllWhenShown(true);

		/* MenuXi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* MenuViewerɃZbg */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * ANV̏ƂToolBarZbg܂B
	 * 
	 */
	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		// AgentċNANV
		toolBarManager.add(getActionBuilder().actionRestartAgent());

		// Agent~ANV
		toolBarManager.add(getActionBuilder().actionStopAgent());

		// AgentNANV
		toolBarManager.add(getActionBuilder().actionStartAgent());

		// AgnetCX^Xf[^C|[gANV
		toolBarManager.add(getActionBuilder().actionImportAgentFile());

		/*
		 * // AgentMf[^j^[Jn
		 * toolBarManager.add(getActionBuilder().actionMonitorStart()); //
		 * AgentMf[^j^[~
		 * toolBarManager.add(getActionBuilder().actionMonitorStop()); //
		 * AgentMf[^j^[ċN
		 * toolBarManager.add(getActionBuilder().actionMonitorRestart());
		 */
	}

	/**
	 * 
	 * 
	 * @return table ߂܂B
	 */
	public Table getTable() {
		return mibInstnaceTable;
	}

	/**
	 * Snmp}l[WG[WFgւSet RequestC X^XXVɂG[WFgCX^X
	 * \e[uXV邽߂ɁAL[f[^I Ƀ`FbNAL[Ƀf[^ꍇɂ̓e[u \XVNXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public class AgentTableShowTimerProcessor implements Runnable {
		/**
		 * IɃG[WFge[u\f[^L[Ď L[Ƀf[^݂ꍇɂ̓e[u\s B
		 */
		public void run() {
			/*
			 * G[WFge[u\f[^L[f[^ Pop
			 */
			Object object = AgentInstanceDataRefreshQueue.getInstance()
					.popAgentQueue();

			if (object != null) {
				mibInstnaceTable.removeAll();

				/* G[WFgf[^ێĂHashMap擾 */
				Map tableAgentMap = AgentInstanceDataMap.getInstance()
						.getAgentInstanceMap();

				/*
				 * G[WFgf[^ǂݏoăe[uɍăZbg
				 */
				for (Iterator it = tableAgentMap.entrySet().iterator(); it
						.hasNext();) {
					Map.Entry ent = (Map.Entry) it.next();

					String rowOid = (String) ent.getKey();
					MibInfo oidInfo = (MibInfo) tableAgentMap.get(rowOid);

					String[] mib = new String[AgentTableViewLabelProvider.AGENT_ARRAY_COUNT];

					mib[AgentTableViewLabelProvider.AGENT_MIB_INSTANCE_NO] = Integer
							.toString(oidInfo.getInstanceNo());
					mib[AgentTableViewLabelProvider.OID_DESC] = oidInfo
							.getDescrip();
					mib[AgentTableViewLabelProvider.OID] = oidInfo.getOid();

					mib[AgentTableViewLabelProvider.VALUE] = oidInfo.getValue();
					mib[AgentTableViewLabelProvider.TYPE] = oidInfo.getSyntax();

					if (oidInfo.getAccess().equals(
							OidTreeListener.READ_ONLY_CODE)) {
						mib[AgentTableViewLabelProvider.ACCESS] = OidTreeListener.READ_ONLY_DESCRIPTION;
					} else if (oidInfo.getAccess().equals(
							OidTreeListener.READ_WRITE_CODE)) {
						mib[AgentTableViewLabelProvider.ACCESS] = OidTreeListener.READ_WRITE_DESCRIPTION;
					} else {
						mib[AgentTableViewLabelProvider.ACCESS] = OidTreeListener.NOT_ACCESSIBLE_DESCRIPTION;
					}

					TableItem tableItem = new TableItem(mibInstnaceTable,
							SWT.NULL);
					tableItem.setText(mib);
					tableItem.setData(mib);
				}

				/* e[uĕ\ */
				mibInstnaceTable.redraw();

				/* e[u\ԍJɂă\[g */
				sortIntegerTable(mibInstnaceTable, 0, false);

				// viewer.refresh();
			}

			// ^C}[p
			display.timerExec(1000, this);
		}
	}
}
