/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.bit.SnmpBit;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.AgentTableViewLabelProvider;
import netjfwatcher.snmpagent.process.ThreadAgent;
import netjfwatcher.snmpmanager.OidTreeListener;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.osgi.framework.Bundle;


/**
 * SnmpG[WFgƂẴCX^Xf[^t@ĆA
 * 擾ĕێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentDataImport {
    /** SysupTime OIDŃC|[glAgentғݒ */
    public static final String SYSUPTIME_OID = "1.3.6.1.2.1.1.3.0";

    /* Logging */
    private static Logger logger = null;
    private static final String IPADENTADDR_OID_DESC = "ipAdEntAddr";

    /* OID DescriptionKeyƂOidInfoi[Map */
    private HashMap agentOidDescriptionMap = null;

    /* OIDKeyƂOidInfoi[Map */
    private HashMap agentOidMap = null;

    /* Agent OIDi[ListTree`̂Ɏgp */
    private ArrayList agentOidInfoList = new ArrayList();

    /*
     * Agentf[^LqOID DescriptionOID`
     * HashMapHit܂ŒZAHitOID Description
     * ListɊi[B
     * ɂAAgentCX^XƏOID` Description
     * ƂJE^[ɂĘAgB
     */
    private ArrayList searchOidDescriptionList = new ArrayList();

    /*
     * XAgentf[^̑uIPAhXuIPAhXɏ
     * IPAhX
     */
    private String deviceAddress = "";

    /* SNMP AgentƂĂ̎uIPAhX */
    private String localIPAddr = "";

    /* uIPAhXϊ|̃bZ[W */
    private String messageChangeIPAddress = "";

    /**
     * SNMPG[WFgƂẴCX^Xf[^t@C
     * ́A擾ĕێNXCX^X𐶐܂B
     *
     */
    public AgentDataImport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ftHgSNMPG[WFgf[^wCSV
     * t@Cǂݍ݁E͂G[WFg̃C
     * X^Xf[^Zbg܂B
     * wCSVt@ĆAURLɌ܂B
     *
     * @param csvFile Agentf[^`CSVt@C
     * @param table Table
     * @throws AgentDataImportException AgentCX^Xf[^C|[g
     * ňُ킪ꍇ
     * @throws FileNotFoundException Agentf[^`CSVt@C
     * Ȃꍇ
     */
    public void setDefaultAgentData(String csvFile, Table table)
        throws AgentDataImportException, FileNotFoundException {
        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = bundle.getEntry(csvFile);

        if (url == null) {
            throw new FileNotFoundException("FileNotFound : " + csvFile);
        }

        URLConnection con = null;
        InputStream in = null;

        try {
            con = url.openConnection();
            in = con.getInputStream();
        } catch (IOException e) {
            logger.warning(e.getMessage());
            throw new AgentDataImportException(e.getMessage());
        }

        BufferedReader br = null;

        try {
            br = new BufferedReader(
                    new InputStreamReader(con.getInputStream()));

            parseAgentData(csvFile, br, table);
        } catch (IOException e) {
            logger.warning("BufferedReader : " + e.getMessage());
            throw new AgentDataImportException(
                "BufferedReader : " + e.getMessage());
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e1) {
                    logger.warning("BufferedReader close : " + e1.getMessage());
                    throw new AgentDataImportException(
                        "BufferedReader close : " + e1.getMessage());
                }
            }

            if (in != null) {
                try {
                    in.close();
                } catch (IOException e1) {
                    logger.warning(
                        "InputStreamReader close : " + e1.getMessage());
                    throw new AgentDataImportException(
                        "InputStreamReader close : " + e1.getMessage());
                }
            }
        }
    }

    /**
     * SNMPG[WFgf[^wCSVt@CpXǂݍ݁E
     * ͂G[WFg̃CX^Xf[^Zbg܂B
     *
     * @param csvFile Agentf[^`CSVt@CpX
     * @throws AgentDataImportException AgentCX^Xf[^C|[g
     * ňُ킪ꍇ
     * @throws FileNotFoundException Agentf[^`CSVt@C
     * Ȃꍇ
     */
    public String setAgentData(String csvFile)
        throws AgentDataImportException, FileNotFoundException {
        messageChangeIPAddress = "";

        FileReader fileReader = null;
        BufferedReader bufferReader = null;

        try {
            fileReader = new FileReader(csvFile);
            bufferReader = new BufferedReader(fileReader);

            parseAgentData(csvFile, bufferReader, null);
        } catch (FileNotFoundException e) {
            logger.warning(
                "Import agent data file : " + e.getMessage() + " , file: "
                + csvFile);
            throw e;
        } finally {
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                } catch (IOException e1) {
                    logger.warning("BufferedReader close : " + e1.getMessage());
                    throw new AgentDataImportException(
                        "BufferedReader close : " + e1.getMessage());
                }
            }

            if (fileReader != null) {
                try {
                    fileReader.close();
                } catch (IOException e2) {
                    logger.warning("FileReader close : " + e2.getMessage());
                    throw new AgentDataImportException(
                        "FileReader close : " + e2.getMessage());
                }
            }
        }

        return messageChangeIPAddress;
    }

    /**
     * CSVt@C͂Agentf[^ƂĊi[ƂƂɁAe[u\܂B
     * CSVt@Cɂ͈ȉ̂悤OID+CX^XƒlLqĂ邱ƑOƂ܂B
     * OID.CX^X=l
     *
     * OID.CX^XMIB`t@CĊYOID
     * iOIDAOIDAANZXA^Cvj擾AG[WFgf[^ƕێ
     * ܂B
     *
     * @param csvFile Agentf[^`CSVt@C
     * @param bufferReader BufferedReader
     * @param table Table
     * @throws AgentDataImportException AgentCX^Xf[^C|[g
     * ňُ킪ꍇ
     */
    private void parseAgentData(
        String csvFile, BufferedReader bufferReader, Table table)
        throws AgentDataImportException {
        /* Agentf[^ێXgUNA */
        agentOidInfoList.clear();
        searchOidDescriptionList.clear();

        try {
            localIPAddr = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e4) {
            logger.warning("UnknownHostException : " + e4.getMessage());
            e4.printStackTrace();
        }

        /* J}ŕz */
        String[] arrayLine = null;

        int agentDataCounter = 1;

        try {
            /* MIB`Mapǂݍ */
            AgentMibTree agentMibTable = AgentMibTree.getInstance();
            agentOidDescriptionMap = agentMibTable.getMibDescripHashMap();
            agentOidMap = agentMibTable.getOidHashMap();

            /**
             * t@C̍sƂẮAȉ̌`
             * (MIB Discription.CX^)=(CX^Xl)
             *
             * .
             * sysDescr.0="'LR-X6030' '-- V04.06-A07' '2002.04.12'"
             * sysObjectID.0="brouter3"
             * sysUpTime.0=1506675
             * sysContact.0="FUJITSU"
             * sysName.0="LR-X6030"
             * sysLocation.0="FPL"
             *
             */
            while (
                (arrayLine = splitReadLine(bufferReader.readLine(), "=")) != null) {
                /*
                 * Agentf[^̑uIPAhXuIPAhXɏ
                 */
                String[] workArrayLine = checkDeviceIPAddress(arrayLine);

                if (workArrayLine != null) {
                    arrayLine = workArrayLine;
                }

                /*
                 * MIBiDiscriptionjMapɓo^ĂOID
                 */
                int oidPositionWork = arrayLine[0].lastIndexOf(".");

                if (oidPositionWork < 0) {
                    logger.warning(
                        "Format error import file : " + csvFile + " : line ="
                        + agentDataCounter + "  " + arrayLine[0]);

                    continue;
                }

                String searchOidDescription =
                    arrayLine[0].substring(0, oidPositionWork);

                /*
                 * OIDCX^Xƒl'='ŕ
                 */
                boolean isFound = false;
                String searchOid = "";
                MibInfo agentOidInfo = null;

                /*
                 * OID DiscriptionkeyƂHashMap
                 * key݂Ȃ΁AG[WFgOID̒Z
                 * čēxAkey݃`FbN
                 * key݂܂oid̒ZĂ
                 * key݂΂ɂHashMap MIB Nameget
                 *
                 */
                for (int i = 0; i < arrayLine[0].length(); i++) {
                    /* HashMapOID DescriptionɂOID */
                    if (
                        agentOidDescriptionMap.containsKey(
                                searchOidDescription)) {
                        /*
                         * OID DiscriptionɈvOID񂪌
                         */
                        isFound = true;
                        agentOidInfo =
                            (MibInfo) agentOidDescriptionMap.get(
                                searchOidDescription);

                        /*
                         * OID DiscriptionɈvOID񂪌
                         * OIDƃCX^X̌A
                         * OIDƂčēxAOIDo^
                         * 邽߂OID쐬
                         */
                        searchOid =
                            agentOidInfo.getOid()
                            + arrayLine[0].substring(
                                searchOidDescription.length(),
                                arrayLine[0].length());

                        break;
                    }

                    if (oidPositionWork >= i) {
                        // vȂ΁AOID DiscriptionZāAēx
                        searchOidDescription =
                            arrayLine[0].substring(0, oidPositionWork - i);
                    } else {
                        logger.warning("oidPositionWork : " + oidPositionWork);
                        logger.warning("i : " + i);
                        throw new AgentDataImportException(
                            "Undefined OID, import file : " + csvFile
                            + " : line =" + agentDataCounter
                            + " OID description=" + arrayLine[0]);
                    }
                }

                /*
                 * G[WFgOID猟ĒoOIDƃG[WFgOID
                 * TtBbNX̂OIDɂčēx
                 *
                 *
                 */
                oidPositionWork = searchOid.lastIndexOf(".");

                if (oidPositionWork < 0) {
                    throw new AgentDataImportException(
                        "Undefined OID, import file : " + csvFile + " : line ="
                        + agentDataCounter + " OID=" + searchOid);
                }

                /*
                 * AgentCX^XɑΉĐOIDɂ
                 * OID`OID擾
                 */
                String workSearchOid = searchOid.substring(0, oidPositionWork);

                if (isFound) {
                    isFound = false;

                    for (int i = 0; i < searchOid.length(); i++) {
                        if (agentOidMap.containsKey(workSearchOid)) {
                            isFound = true;
                            agentOidInfo =
                                (MibInfo) agentOidMap.get(workSearchOid);

                            break;
                        }

                        /*
                         * OIDHitȂꍇOIDZ
                         * ēxA
                         */
                        int checkOidPos = workSearchOid.lastIndexOf(".");

                        if (checkOidPos >= 0) {
                            workSearchOid =
                                workSearchOid.substring(0, checkOidPos);
                        } else {
                            break;
                        }
                    }
                }

                /*
                 * ImportAgentf[^`킩`FbN
                 * (Agentf[^`OID`Hit)
                 */
                if (agentOidInfo == null) {
                    logger.warning(
                        "Undefined OID, import file : " + csvFile + " : line ="
                        + agentDataCounter);
                    throw new AgentDataImportException(
                        "Undefined OID, import file : " + csvFile + " : line ="
                        + agentDataCounter);
                }

                /*
                 * Agent SNMPIuWFNg
                 */
                AbstractSnmpObject agentSnmpObject = null;

                try {
                    if (arrayLine.length > 1) {
                        agentSnmpObject =
                            createAgentSnmpObject(
                                arrayLine[1], agentOidInfo.getSyntax());
                    } else {
                        agentSnmpObject =
                            createAgentSnmpObject("", agentOidInfo.getSyntax());
                    }

                    if (agentSnmpObject == null) {
                        continue;
                    }
                } catch (NumberFormatException e3) {
                    /* SnmpIuWFNgOɕ𐔒lϊŎs */
                    logger.warning("NumberFormatException " + e3.getMessage());
                    e3.printStackTrace();
                    throw new AgentDataImportException(
                        "Format error import file : " + csvFile + " : line ="
                        + agentDataCounter);
                } catch (SnmpBadValueException e3) {
                    logger.warning("SnmpBadValueException " + e3.getMessage());
                    e3.printStackTrace();
                    throw new AgentDataImportException(
                        "Format error import file : " + csvFile + " : line ="
                        + agentDataCounter);
                }

                String oidSuffix =
                    arrayLine[0].substring(
                        searchOidDescription.length(), arrayLine[0].length());

                try {
                    /*
                     * Agentf[^LqOID DescriptionOID`
                     * HashMapHit܂ŒZAHitOID Description
                     * ListɊi[B
                     * ɂAAgentCX^XƏOID` Description
                     * ƂJE^[ɂĘAgB
                     */
                    searchOidDescriptionList.add(searchOidDescription);

                    /*
                    * Agent OID Info
                    */
                    createAgentOidInfo(
                        agentOidInfo, oidSuffix, arrayLine[0], agentSnmpObject);

                    /*
                     * e[u\
                     */
                    String descriptionSuffix =
                        searchOid.substring(
                            workSearchOid.length(), searchOid.length());
                    showTable(
                        table, agentDataCounter, agentOidInfo, oidSuffix,
                        descriptionSuffix, agentSnmpObject);
                    agentDataCounter++;
                } catch (Exception e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                    throw new AgentDataImportException(
                        "Format error import file : " + csvFile + " : line ="
                        + agentDataCounter);
                }
            } // While parse line of CSV file loop end

            /*
             * G[WFg̃CX^Xf[^OID Treeɑgݍ
             */
            createAgentTree();

            /*
             * SysupTimeXV
             */
            setSysupTime();
        } catch (AgentDataImportException e) {
            throw e;
        } catch (Exception e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            throw new AgentDataImportException(
                "Abort import file : " + csvFile);
        } finally {
            if (bufferReader != null) {
                try {
                    bufferReader.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    /*
     * Agent OidInfo𐶐܂B
     *
     * @param miboid MIB
     * @param oidSuffix OID Suffix
     * @param agentDescription CX^X Description
     * @param agentSnmpObject CX^XSNMPIuWFNg
     * @throws Exception Agent OidInfo񐶐Ɏsꍇ
     */
    private void createAgentOidInfo(
        MibInfo miboid, String oidSuffix, String agentDescription,
        AbstractSnmpObject agentSnmpObject) throws Exception {
        /*
         * AgentCX^XpOidInfo
         */
        MibInfo agentMibInfo = new MibInfo();

        /* ValueZbg */
        agentMibInfo.setAgentMibValue(agentSnmpObject);

        /* OIDZbg */
        agentMibInfo.setOid(miboid.getOid() + oidSuffix);

        /* DescriptionZbg */
        agentMibInfo.setDescrip(agentDescription);

        /* AccessZbg */
        agentMibInfo.setAccess(miboid.getAccess());

        /* AgentCX^XtOZbg */
        agentMibInfo.setAgentInstance(true);

        /* YOID̃G[WFgXgɃG[WFgi[ */
        agentOidInfoList.add(agentMibInfo);
    }

    /*
     * AgentCX^Xe[uɕ\܂B
     *
     * @param table AgentCX^Xe[u
     * @param agentDataCounter CX^Xԍ
     * @param miboid MIB
     * @param oidSuffix OID Suffix
     * @param agentDescription CX^X Description
     * @param agentDescriptionSuffix  CX^X Description Suffix
     * @param agentSnmpObject CX^XSNMPIuWFNg
     */
    private void showTable(
        Table table, int agentDataCounter, MibInfo miboid, String oidSuffix,
        String agentDescriptionSuffix, AbstractSnmpObject agentSnmpObject) {
        /*
         * SNMP Agent GUIe[u\
         *
         */
        String[] agentTableArray =
            new String[AgentTableViewLabelProvider.AGENT_ARRAY_COUNT];

        /* CX^XԍZbg */
        agentTableArray[AgentTableViewLabelProvider.AGENT_MIB_INSTANCE_NO] =
            Long.toString(agentDataCounter);

        /* DescriptionZbg */
        agentTableArray[AgentTableViewLabelProvider.OID_DESC] =
            miboid.getDescrip() + agentDescriptionSuffix;

        /* OIDZbg */
        agentTableArray[AgentTableViewLabelProvider.OID] =
            miboid.getOid() + oidSuffix;

        /* ValueZbg */
        agentTableArray[AgentTableViewLabelProvider.VALUE] =
            agentSnmpObject.toString();

        /* TypeZbg */
        agentTableArray[AgentTableViewLabelProvider.TYPE] =
            String.valueOf(miboid.getSyntax());

        /* Access TypeZbg */
        if (miboid.getAccess().equals(OidTreeListener.READ_ONLY_CODE)) {
            agentTableArray[AgentTableViewLabelProvider.ACCESS] =
                OidTreeListener.READ_ONLY_DESCRIPTION;
        } else if (miboid.getAccess().equals(OidTreeListener.READ_WRITE_CODE)) {
            agentTableArray[AgentTableViewLabelProvider.ACCESS] =
                OidTreeListener.READ_WRITE_DESCRIPTION;
        } else {
            agentTableArray[AgentTableViewLabelProvider.ACCESS] =
                OidTreeListener.NOT_ACCESSIBLE_DESCRIPTION;
        }

        /* AgentCX^Xf[^MapɊi[ */
        MibInfo agentOidInfo = new MibInfo();
        agentOidInfo.setInstanceNo(agentDataCounter);
        agentOidInfo.setOid(agentTableArray[AgentTableViewLabelProvider.OID]);
        agentOidInfo.setDescrip(
            agentTableArray[AgentTableViewLabelProvider.OID_DESC]);
        agentOidInfo.setValue(
            agentTableArray[AgentTableViewLabelProvider.VALUE]);
        agentOidInfo.setSyntax(
            agentTableArray[AgentTableViewLabelProvider.TYPE]);
        agentOidInfo.setAccess(miboid.getAccess());
        agentOidInfo.setAgentInstance(true);

        AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(
            agentTableArray[AgentTableViewLabelProvider.OID], agentOidInfo);

        if (table == null) {
            /* AgentCX^Xe[u\ */
            Table agentTable =
                NetJFWatcherApplication.getAgentTableView().getTable();

            TableItem tableItem = new TableItem(agentTable, SWT.NULL);
            tableItem.setText(agentTableArray);
            tableItem.setData(agentTableArray);
        } else {
            TableItem tableItem = new TableItem(table, SWT.NULL);
            tableItem.setText(agentTableArray);
            tableItem.setData(agentTableArray);
        }
    }

    /*
     * SNMPIuWFNg𐶐܂B
     *
     * @param agentValue SNMPf[^
     * @param oidType SNMP^Cv
     * @return snmpObject SNMPIuWFNg
     * @throws NumberFormatException lłׂf[^lłȂꍇ
     * @throws SNMPBadValueException SNMPIuWFNgɎsꍇ
     */
    private AbstractSnmpObject createAgentSnmpObject(
        String agentValue, String oidType)
        throws NumberFormatException, SnmpBadValueException {
        /*
         * ftHgSNMPIuWFNg
         */
        AbstractSnmpObject snmpObject = new SnmpNull();

        /*
         * OIDCX^Xf[^'"'(_uNH[e[V)
         * ň͂܂Ăꍇ'"'
         */
        String checkValue = agentValue;
        String value;

        if (
            (checkValue.indexOf("\"") == 0)
                && (checkValue.lastIndexOf("\"") == (checkValue.length() - 1))) {
            value = checkValue.substring(1, checkValue.length() - 1);
        } else {
            value = agentValue;
        }

        /*
         * Typeɂ킹SnmpIuWFNg
         */
        if (oidType.equals(ManagerMibTree.INTEGER)) {
            snmpObject = new SnmpInteger(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.COUNTER32)) {
            snmpObject = new SnmpCounter32(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.COUNTER64)) {
            snmpObject = new SnmpCounter64(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.GAUGE32)) {
            snmpObject = new SnmpGauge32(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.OCTETSTRING)) {
            snmpObject = new SnmpOctetString(value);
        } else if (oidType.equals(ManagerMibTree.IPADDRESS)) {
            snmpObject = new SnmpIPAddress(agentValue);
        } else if (oidType.equals(ManagerMibTree.OBJECTID)) {
            /*
             * TypeObjectID̏ꍇŁAG[WFgf[^Dot`Ŗꍇ
             * CX^XMIBƂāAYOIDB
             * YOIDȂꍇɂ́AOctetString`ƂĈ
             */
            try {
                snmpObject = new SnmpObjectIdentifier(agentValue);
            } catch (SnmpBadValueException e2) {
                /*
                 * ObjectIDɑΉMIB(Description)Lڂ
                 * ꍇɂ́AYOID
                 */
                MibInfo workMibOid =
                    (MibInfo) agentOidDescriptionMap.get(
                        agentValue.substring(1, agentValue.length() - 1));
                String detectObjectID = null;

                if (workMibOid != null) {
                    detectObjectID = workMibOid.getOid();
                }

                if (detectObjectID != null) {
                    snmpObject = new SnmpObjectIdentifier(detectObjectID);
                } else {
                    snmpObject = new SnmpOctetString(value);
                }
            }
        } else if (oidType.equals(ManagerMibTree.TIMETICKS)) {
            snmpObject = new SnmpTimeTicks(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.UINTEGER32)) {
            snmpObject = new SnmpUInteger32(Integer.parseInt(agentValue));
        } else if (oidType.equals(ManagerMibTree.BITS)) {
            snmpObject = new SnmpBit(Integer.parseInt(value));
        } else if (oidType.equals(ManagerMibTree.OPAQUE)) {
            snmpObject = new SnmpBit(Integer.parseInt(value));
        } else if (oidType.equals(ManagerMibTree.DISPLAYSTRING)) {
            snmpObject = new SnmpOctetString(value);
        } else {
            return null;
        }

        return snmpObject;
    }

    /*
     * G[WFg̃CX^Xf[^OID Treeɑgݍ݂܂B
     *
     */
    private void createAgentTree() {
        /*
         * G[WFg̃CX^Xf[^OID Treeɑgݍ
         */
        int agentCount = 0;

        for (; agentCount < agentOidInfoList.size(); agentCount++) {
            MibInfo nextAgentMibInfo = null;

            if ((agentCount + 1) < agentOidInfoList.size()) {
                nextAgentMibInfo =
                    (MibInfo) agentOidInfoList.get(agentCount + 1);
            }

            /* OIDɑΉ`擾 */
            MibInfo oidDefineInfo =
                (MibInfo) agentOidDescriptionMap.get(
                    searchOidDescriptionList.get(agentCount));

            /* OIDɑΉAgentCX^X擾 */
            MibInfo agentMibInfo = (MibInfo) agentOidInfoList.get(agentCount);

            /* YOID̃G[WFgXgɃG[WFgi[ */
            oidDefineInfo.getAgaentMibInfoList().add(agentMibInfo);

            /*
             * OID`ɊYOIDɑΉAgenti[ɁA
             * Tree(`F[Fnext|C^)
             */
            if (oidDefineInfo.getAgaentMibInfoList().size() == 1) {
                /*
                 * OIDɑ΂ăG[WFg񂪈̏ꍇ́A
                 *
                 * (1) G[WFgNext OIDOID`Next OID
                 *     Zbg
                 * (2) OID`Next OID̓G[WFgOIDƂ
                 */
                if (nextAgentMibInfo == null) {
                    agentMibInfo.setNextMibOid(null);
                } else {
                    agentMibInfo.setNextMibOid(nextAgentMibInfo.getOid());
                }

                oidDefineInfo.setNextMibOid(agentMibInfo.getOid());
            }

            if (oidDefineInfo.getAgaentMibInfoList().size() > 1) {
                /*
                 * G[WFg񂪂Qȏ̏ꍇAO
                 * G[WFgNext OIDxOID
                 * ƂȂĂ̂Ō݂Next OIDƓւ
                 * ă`F[Ƃ
                 */
                MibInfo preAgentMibInfo =
                    (MibInfo) oidDefineInfo.getAgaentMibInfoList().get(
                        oidDefineInfo.getAgaentMibInfoList().size() - 2);

                if (nextAgentMibInfo == null) {
                    agentMibInfo.setNextMibOid(null);
                } else {
                    agentMibInfo.setNextMibOid(nextAgentMibInfo.getOid());
                }

                preAgentMibInfo.setNextMibOid(agentMibInfo.getOid());
                agentOidMap.put(preAgentMibInfo.getOid(), preAgentMibInfo);
            }

            /*
             * MIB`MapAgent OIDKeyƂAgentCX^Xf[^gݍ
             */
            agentOidMap.put(agentMibInfo.getOid(), agentMibInfo);
        } // for loop end.
    }

    /*
     * ImportSysupTimef[^Agent start timeݒ肵܂B
     *
     */
    private void setSysupTime() {
        /*
         * ImportSysupTimelAgent start timeƂĐݒ
         */
        AgentMibTree mibtable = AgentMibTree.getInstance();
        HashMap oidMap = mibtable.getOidHashMap();

        if (oidMap.containsKey(SYSUPTIME_OID)) {
            MibInfo miboid = (MibInfo) oidMap.get(SYSUPTIME_OID);

            if (miboid != null) {
                AbstractSnmpObject sysupTimeObject =
                    ((MibInfo) oidMap.get(SYSUPTIME_OID)).getAgentMibValue();

                long importSysupTime =
                    Long.parseLong(sysupTimeObject.getValue().toString());

                /*
                 * ImportSysupTime OIDf[^10msPʂł邽߂ɁA
                 * 10{msf[^ƂĂSysupTimeZoAgent Start
                 * TimeZbg
                 */
                long sysupTimeMills =
                    System.currentTimeMillis() - (importSysupTime * 10);
                ThreadAgent.getInstance().setStartEngineTime(sysupTimeMills);

                /*
                 * SNMP AgentViewSysupTimef[^\TextZbg
                 */

                // if (RssrApplication.getAgentOperationView() != null) {
                // RssrApplication.getAgentOperationView().setSysupTime();
                // }
            }
        }
    }

    /**
     * CSVt@Cǂݍ񂾍s","iJ}jŕAʂ
     * Ԃ܂B<BR>
     *
     * @param line 1s̕
     * @return ","iJ}jŕz
     */
    private String[] splitReadLine(final String line, final String delim) {
        String[] arrayLine = null;

        if (line != null) {
            arrayLine = line.split(delim);
        }

        return arrayLine;
    }

    /*
     * Agentf[^̑uIPAhXuIPAhXɏ܂B
     *
     * @param arrayLine OIDValuei[镶z
     * @return XVOIDValuei[镶z
     */
    private String[] checkDeviceIPAddress(String[] arrayLine) {
        if ((arrayLine == null) || (arrayLine.length != 2)) {
            return null;
        }

        if (deviceAddress.equals("")) {
            deviceAddress = getDeviceIPAddress(arrayLine[0]);

            if (!deviceAddress.equals("")) {
                String workOid =
                    updateOIDDeviceIPAddress(arrayLine[0], deviceAddress);

                if (!workOid.equals("")) {
                    arrayLine[0] = workOid;
                }

                String workValue =
                    updateValueDeviceIPAddress(arrayLine[1], deviceAddress);

                if (!workValue.equals("")) {
                    arrayLine[1] = workValue;
                }
            }
        } else {
            String workOid =
                updateOIDDeviceIPAddress(arrayLine[0], deviceAddress);

            if (!workOid.equals("")) {
                arrayLine[0] = workOid;
            }

            String workValue =
                updateValueDeviceIPAddress(arrayLine[1], deviceAddress);

            if (!workValue.equals("")) {
                arrayLine[1] = workValue;
            }
        }

        return arrayLine;
    }

    /*
     * OIDɕt鑕uIPAhX鑕uIPAhX𒊏o܂B
     * ipAdEntAddr OIDIPAhXԂ܂B
     * AAuIPAhXł͌ĂȂ0.0.0.0127.0.0.1̏ꍇɂ͕Ԃ܂B
     *
     * @param oid OID
     * @return OIDɕt鑕uIPAhX鑕uIPAhX
     */
    private String getDeviceIPAddress(String oid) {
        String deviceLocalIPAddress = "";
        int oidPositionWork = oid.indexOf(IPADENTADDR_OID_DESC);

        if (oidPositionWork >= 0) {
            deviceLocalIPAddress =
                oid.substring(IPADENTADDR_OID_DESC.length() + 1, oid.length());

            if (
                deviceLocalIPAddress.equals("0.0.0.0")
                    || deviceLocalIPAddress.equals("127.0.0.1")) {
                return "";
            }

            logger.info("deviceIPAddress : " + deviceLocalIPAddress);

            if (!localIPAddr.equals("127.0.0.1")) {
                messageChangeIPAddress =
                    "Replace Device IP Address : " + deviceLocalIPAddress
                    + " --> " + localIPAddr;
            }
        }

        return deviceLocalIPAddress;
    }

    /*
     * OIDɕt鑕uIPAhXuIPAhXɏĕԂ܂B
     *
     * @param oid OID
     * @param deviceAddress IPAhX
     * @return OIDɕt鑕uIPAhXuIPAhXɏOID
     */
    private String updateOIDDeviceIPAddress(String oid, String deviceAddress) {
        if (localIPAddr.equals("127.0.0.1")) {
            return "";
        }

        String deviceOIDIPAddress = "";
        int oidPositionWork = oid.indexOf(deviceAddress);

        if (oidPositionWork >= 0) {
            deviceOIDIPAddress = oid.replaceFirst(deviceAddress, localIPAddr);

            /*
            logger.info(
                "Replace Device IPAddress : " + oid + " --> "
                + deviceOIDIPAddress);
                */
        }

        return deviceOIDIPAddress;
    }

    /*
     * OIDɑΉValueɕt鑕uIPAhXuIPAhX
     * ĕԂ܂B
     *
     * @param value OIDɑΉValue
     * @param deviceAddress IPAhX
     * @return OIDɑΉValueɂɕt鑕uIPAhXuIPAhXɏValue
     */
    private String updateValueDeviceIPAddress(
        String value, String deviceAddress) {
        if (localIPAddr.equals("127.0.0.1")) {
            return "";
        }

        String deviceValueIPAddress = "";
        int oidPositionWork = value.indexOf(deviceAddress);

        if (oidPositionWork >= 0) {
            deviceValueIPAddress =
                value.replaceFirst(deviceAddress, localIPAddr);

            /*
            logger.info(
                "replace deviceIPAddress : " + value + " --> "
                + deviceValueIPAddress);
                */
        }

        return deviceValueIPAddress;
    }
}
