/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.util.logging.Logger;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;


/**
 * snmp managerɂ鑗Mf[^j^O邽߂̃\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpManagerMonitorView extends ViewPart {
    /** Snmp Managerł̑Mf[^i[L[̊Ď(ms) */
    public static final int TIMER = 1000;

    /* MO */
    private static Logger logger;

    /* Snmp Managerł̑Mf[^\eLXg */
    private Text moniterText;

    /* Display */
    private Display display;

    /* j^Zbg{^ */
    private Button resetButton;

    /* j^Jn{^ */
    private Button startButton;

    /* j^~{^ */
    private Button stopButton;

    /*
     * Snmp Managerł̑Mf[^i[L[IɊĎA
     * \Thread
     */
    private TimerProcessor timerProcessor;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        display = parent.getDisplay();

        // ^C}[̐
        timerProcessor = new TimerProcessor();

        // display.timerExec(TIMER, timerProcessor);

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite(parent, SWT.NULL);

        // Composite composite = new Composite(parent, SWT.NULL);
        gridData = new GridData();
        composite.setLayout(gridLayout);
        composite.setLayoutData(gridData);

        resetButton = new Button(composite, SWT.BORDER);
        resetButton.setText("Reset");

        startButton = new Button(composite, SWT.BORDER);
        startButton.setText("Start");

        stopButton = new Button(composite, SWT.BORDER);
        stopButton.setText("Stop");

        // eval.addSelectionListener(this); 
        GridLayout gridLayout2 = new GridLayout(1, true);
        Composite composite2 = new Composite(parent, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.FILL_BOTH));

        composite2.setLayout(gridLayout2);

        moniterText =
            new Text(
                composite2, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        moniterText.setText("");

        gridData = new GridData(GridData.FILL_BOTH);

        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;

        moniterText.setLayoutData(gridData);

        resetButton.setEnabled(true);
        startButton.setEnabled(true);
        stopButton.setEnabled(false);

        /**
         * j^\Zbg{^Xi[łB
         */
        resetButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * j^\Zbg܂B
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());
                    moniterText.setText("");
                    logger.info("Snmp Manager monitor reset");
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events
                 * .SelectionListener#widgetDefaultSelected(org.
                 * eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /**
         * j^\Jn{^Xi[łB
         */
        startButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * j^\Jn܂B
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());
                    SnmpManagerQueue.getInstance().setMonitor(true);
                    display.timerExec(TIMER, timerProcessor);
                    logger.info("Snmp Manager monitor start");
                    resetButton.setEnabled(true);
                    startButton.setEnabled(false);
                    stopButton.setEnabled(true);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /**
         * j^\~{^Xi[łB
         */
        stopButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * j^\~܂B
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());
                    SnmpManagerQueue.getInstance().setMonitor(false);
                    display.timerExec(-1, timerProcessor);
                    logger.info("Snmp Manager monitor stop");
                    resetButton.setEnabled(true);
                    startButton.setEnabled(true);
                    stopButton.setEnabled(false);
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.
                 * events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#setFocus()
     */
    public void setFocus() {
    }

    /**
     * Snmp Managerł̑Mf[^i[L[IɊĎAM
     * f[^݂ꍇɃeLXgGAɃbZ[W\邽߂̃Xb
     * hNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class TimerProcessor implements Runnable {
        /**
         * TrapML[IɊĎAL[Ƀf[^ꍇɂ̓f[^Pop
         * TrapMe[uɕ\܂B
         *
         */
        public void run() {
            /*
             * Snmp Manager̃bZ[WL[Ď
             */
            String message =
                (String) SnmpManagerQueue.getInstance().popSnmpManagerQueue();

            while (message != null) {
                /* L[ɃbZ[W𑶍݂ꍇɃeLXgGAɕ\ */
                moniterText.append(
                    message + System.getProperty("line.separator"));
                moniterText.append(System.getProperty("line.separator"));

                /* ̃bZ[Wǂݍ */
                message =
                    (String) SnmpManagerQueue.getInstance().popSnmpManagerQueue();
            }

            // ^C}[p
            display.timerExec(TIMER, this);
        }
    }
}
