/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 * XML SocketɂA[Mf[^𒆌pL[ƂȂNXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class XMLSocketAlarmReceiveMessageQueue {
    /* L[郊Xg */
    private static List xmlAlarmpQueueList;
    private static final int LIMIT = 100;

    private XMLSocketAlarmReceiveMessageQueue() {
        xmlAlarmpQueueList = Collections.synchronizedList(new LinkedList());
    }

    /**
     * XML Socket A[ML[Push܂B
     *
     * @param obj XML Socket A[Mi[ArrayList
     */
    public synchronized void pushXMLAlarmData(final Object obj) {
    	if(xmlAlarmpQueueList.size() > LIMIT) {
    		xmlAlarmpQueueList.remove(0);
    		xmlAlarmpQueueList.add(obj);
    	} else {
    		xmlAlarmpQueueList.add(obj);
    	}
    }

    /**
     * L[XML Socket A[MPop܂B
     *
     * @return xmlAlarmDataObj XML Socket A[M
     */
    public synchronized Object popXMLAlarmData() {
        Object xmlAlarmDataObj = null;

        if (xmlAlarmpQueueList.size() > 0) {
            xmlAlarmDataObj = xmlAlarmpQueueList.get(0);
            xmlAlarmpQueueList.remove(0);
        }

        return xmlAlarmDataObj;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static XMLSocketAlarmReceiveMessageQueue getInstance() {
        return SingletonResource.XML_ALARM_MESSAGE_QUEUE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final XMLSocketAlarmReceiveMessageQueue XML_ALARM_MESSAGE_QUEUE =
            new XMLSocketAlarmReceiveMessageQueue();
    }
}
