/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.view;

import java.util.logging.Logger;

import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;


/**
 * EditorEBhEɃuEU\邽߂̃NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class BrowserEditors extends EditorPart {
    /* MO */
    private static Logger logger;

    /* uEU */
    private Browser browser;

    /**
     * EditorEBhEɃuEU\邽߂̃CX^X
     * 𐶐܂B
     *
     */
    public BrowserEditors() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isDirty()
     */
    public boolean isDirty() {
        return false;
    }

    /**
     * uEUɃtH[JXZbg܂B
     */
    public void setFocus() {
        browser.setFocus();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
     */
    public boolean isSaveAsAllowed() {
        return false;
    }

    /**
     * EditorEBhE𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        try {
            /* uEU */
            browser = new Browser(parent, SWT.FILL);
        } catch (SWTError e) {
            logger.warning("Browser cannot be initialized.");

            /* uEUɎsꍇ */
            MessageBox messageBox =
                new MessageBox(parent.getShell(), SWT.ICON_ERROR | SWT.OK);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }

        try {
            setStatusLine();

            /* ͐ݒlURL擾 */
            UrlEditorInput urlEditorInput = (UrlEditorInput) getEditorInput();

            /* uEUXi[o^ */
            browser.addLocationListener(
                new BrowserLocationChangeListener(urlEditorInput.getName()));

            /* uEUANZXURLZbg */
            browser.setUrl(urlEditorInput.getUrl());
        } catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    private void setStatusLine() throws HttpAccessPreferenceException {
        /* Xe[^XC\L */
        SubStatusLineManager statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        statusLineManager.setMessage(
            "Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#doSave(org.eclipse.core.runtime.IProgressMonitor)
     */
    public void doSave(IProgressMonitor monitor) {
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.ui.ISaveablePart#doSaveAs()
     */
    public void doSaveAs() {
    }

    /**
     * EditorEBhEɏݒs܂B
     *
     * @param site TCg
     * @param input ͒l
     * @throws PartInitException ͒lݒ肪ُ̏ꍇ
     */
    public void init(IEditorSite site, IEditorInput input)
        throws PartInitException {
        /* ͒lݒ肪킩`FbN */
        if (!(input instanceof UrlEditorInput)) {
            logger.warning("Wrong input: " + input.getClass());
            throw new PartInitException("Wrong input: " + input.getClass());
        }

        setSite(site);
        setInput(input);
        setPartName(input.getName());
    }
}
