/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.common.view;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CalendarTable {
    private static final int DAY_WIDTH = 30;
    private static final String[] WEEK = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    private Color sundayColor = Display.getCurrent().getSystemColor(3);
    private Color saturdayColor = Display.getCurrent().getSystemColor(9);
    private Color todayColor = Display.getCurrent().getSystemColor(10);
    private Color whiteColor = Display.getCurrent().getSystemColor(1);
    private Table table;
    private Calendar displayCalendar;
    private int iThisYear;
    private int iThisMonth;
    private int iThisDate;
    private int iThisWeek;

    public CalendarTable(Composite parent, int style) {
        if (this.sundayColor == null || this.sundayColor.isDisposed()) {
            this.sundayColor = Display.getCurrent().getSystemColor(3);
        }
        if (this.saturdayColor == null || this.saturdayColor.isDisposed()) {
            this.saturdayColor = Display.getCurrent().getSystemColor(9);
        }
        if (this.todayColor == null || this.todayColor.isDisposed()) {
            this.todayColor = Display.getCurrent().getSystemColor(10);
        }
        if (this.whiteColor == null || this.whiteColor.isDisposed()) {
            this.whiteColor = Display.getCurrent().getSystemColor(1);
        }
        this.displayCalendar = new GregorianCalendar();
        this.iThisYear = this.displayCalendar.get(1);
        this.iThisMonth = this.displayCalendar.get(2);
        this.iThisDate = this.displayCalendar.get(5);
        this.iThisWeek = this.displayCalendar.get(7);
        this.table = new Table(parent, style);
        this.setupCalendarTable();
    }

    private void setupCalendarTable() {
        GridData tableGridData = new GridData(4);
        tableGridData.horizontalAlignment = 2;
        tableGridData.verticalAlignment = 2;
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[WEEK.length];
        int iCol = 0;
        while (iCol < WEEK.length) {
            col[iCol] = new TableColumn(this.table, 0x1000000);
            col[iCol].setText(WEEK[iCol]);
            col[iCol].setWidth(30);
            ++iCol;
        }
    }

    private String setCalendar() {
        String strYYMM = "";
        this.table.removeAll();
        strYYMM = " " + this.displayCalendar.get(1) + "\u5e74 " + (this.displayCalendar.get(2) + 1) + "\u6708 ";
        Calendar tmpCal = (Calendar)this.displayCalendar.clone();
        tmpCal.set(5, 1);
        int iDispMonth = this.displayCalendar.get(2);
        TableItem item = new TableItem(this.table, 0);
        while (iDispMonth == tmpCal.get(2)) {
            if (tmpCal.get(7) == 1) {
                item = new TableItem(this.table, 0);
            }
            item.setText(tmpCal.get(7) - 1, Integer.toString(tmpCal.get(5)));
            item.setForeground(0, this.sundayColor);
            item.setForeground(6, this.saturdayColor);
            if (this.iThisYear == this.displayCalendar.get(1) && this.iThisMonth + 1 == this.displayCalendar.get(2) + 1 && this.iThisDate == tmpCal.get(5)) {
                item.setForeground(tmpCal.get(7) - 1, this.whiteColor);
                item.setBackground(tmpCal.get(7) - 1, this.todayColor);
            }
            tmpCal.add(5, 1);
        }
        return strYYMM;
    }

    public String getSelectYear() {
        String strYear = Integer.toString(this.displayCalendar.get(1));
        return strYear;
    }

    public String getSelectMonth() {
        String strMonth = Integer.toString(this.displayCalendar.get(2) + 1);
        return strMonth;
    }

    public String getTodaysYYMMDD() {
        String strYear = Integer.toString(this.iThisYear);
        String strMonth = Integer.toString(this.iThisMonth + 1);
        String strDate = Integer.toString(this.iThisDate);
        String strDayOfWeek = WEEK[this.iThisWeek - 1];
        String strYYMMDD = String.valueOf(strYear) + " " + strMonth + "/" + strDate + " [" + strDayOfWeek + "]";
        return strYYMMDD;
    }

    public String getTodaysYY() {
        String strYear = Integer.toString(this.iThisYear);
        return strYear;
    }

    public String getTodaysMM() {
        String strMonth = Integer.toString(this.iThisMonth + 1);
        return strMonth;
    }

    public String getTodaysDD() {
        String strDate = Integer.toString(this.iThisDate);
        return strDate;
    }

    public String setNextMonth() {
        this.displayCalendar.add(2, 1);
        return this.setCalendar();
    }

    public String setPrevMonth() {
        this.displayCalendar.add(2, -1);
        return this.setCalendar();
    }

    public String setThisMonth() {
        this.displayCalendar.set(this.iThisYear, this.iThisMonth, this.iThisDate);
        return this.setCalendar();
    }

    public String setSpecifiedMonth(int iYear, int iMonth) {
        this.displayCalendar.set(iYear, iMonth, this.iThisDate);
        return this.setCalendar();
    }

    public Table getTable() {
        return this.table;
    }
}

