/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.MibGetResponse;
import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;

public class CommandMibGet
extends TemplateCommandImpl {
    private static Logger logger;

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        String mibGetResult = "OK";
        MibGetNextInfo mibGetInstance = null;
        ArrayList mibGetStatisticsList = new ArrayList();
        if (com.getMibInfo().getVersion() == 3 && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(com.getIpaddress()) == null) {
            mibGetResult = "Not found SNMP V3 Agent Address = " + com.getIpaddress();
            logger.warning(mibGetResult);
            MibGetResponseList mibGetResponseList = new MibGetResponseList();
            mibGetResponseList.setResultCode(mibGetResult);
            this.sendResponse(mibGetResponseList, ois, oos);
            return;
        }
        try {
            try {
                int checkCount = 0;
                while (mibGetInstance == null) {
                    mibGetInstance = MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(com.getIpaddress(), Thread.currentThread().getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        logger.warning(e1.getMessage());
                        e1.printStackTrace();
                    }
                    MibGetNextInfoQueue.getInstance().checkTimeout(com.getIpaddress(), "Command Mib Get", ++checkCount, com.getMibInfo().getVersion());
                }
                mibGetInstance.setMibGetNext(com.getIpaddress(), com.getMibInfo().getVersion(), com.getMibInfo().getRoCommunity());
                mibGetStatisticsList = mibGetInstance.getNextMibValueList(com.getMibInfo().getRequestMibOid());
            }
            catch (UnknownHostException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                mibGetResult = e1.getMessage();
            }
            catch (SocketException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
                mibGetResult = e1.getMessage();
            }
            catch (SnmpMIBGetException e1) {
                logger.warning(String.valueOf(com.getIpaddress()) + e1.getMessage());
                mibGetResult = e1.getMessage();
            }
        }
        finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(com.getIpaddress(), Thread.currentThread().getName());
            }
        }
        MibGetResponseList mibGetResponseList = new MibGetResponseList();
        mibGetResponseList.setResultCode(mibGetResult);
        int j = 0;
        while (j < mibGetStatisticsList.size()) {
            MibGetResponse mibgetresponse = new MibGetResponse();
            mibgetresponse.setMibName(((MibValue)mibGetStatisticsList.get(j)).getMibName());
            mibgetresponse.setMibOid(((MibValue)mibGetStatisticsList.get(j)).getMibOid());
            mibgetresponse.setMibValue(((MibValue)mibGetStatisticsList.get(j)).getMibValue());
            mibgetresponse.setMibType(((MibValue)mibGetStatisticsList.get(j)).getMibType());
            mibgetresponse.setMibAccess(((MibValue)mibGetStatisticsList.get(j)).getMibAccess());
            mibGetResponseList.listadd(mibgetresponse);
            ++j;
        }
        this.sendResponse(mibGetResponseList, ois, oos);
    }
}

