/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.node.EditorNodeConfig;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperation;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderNodeOperation
extends Action {
    private static IEditorPart editorNodeConfigView;
    private static Logger logger;
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
    private IAction showNodeView = new ActionShowNodeView();
    private IAction showNodeViewSocket = new ActionShowNodeViewSocket();
    private IAction nodeOperationAction = new ActionNodeOperation();
    private IAction nodeOperationActionSocket = new ActionNodeOperationSocket();

    public ActionBuilderNodeOperation() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionShowNodeView() {
        return this.showNodeView;
    }

    public IAction getActionShowNodeViewSocket() {
        return this.showNodeViewSocket;
    }

    public IAction getActionNodeOperation() {
        return this.nodeOperationAction;
    }

    public IAction getActionNodeOperationSocket() {
        return this.nodeOperationActionSocket;
    }

    private abstract class AbstractNodeAction
    extends Action {
        private AbstractNodeAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeOperation.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Node View";
        }

        public String getToolTipText() {
            return "Node View";
        }
    }

    public final class ActionShowNodeView
    extends AbstractNodeAction {
        private NodeInformation nodeInfo;

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Node View", this.nodeInfo, false), EditorNodeConfig.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public final class ActionShowNodeViewSocket
    extends AbstractNodeAction {
        private NodeInformation nodeInfo;

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Node View" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true), EditorNodeConfig.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionNodeOperation
    extends AbstractNodeAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNodeOperation.this.bundle.getEntry("icons/configs.gif"));
        }

        public String getText() {
            return "Node Add/Edit/Delete";
        }

        public String getToolTipText() {
            return "Node Add/Edit/Delete";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.nodeInfo == null) {
                this.nodeInfo = new NodeInformation();
                this.nodeInfo.setIpaddress(null);
            }
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView("Node Add/Edit/Delete", this.nodeInfo, false), EditorNodeOperation.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionNodeOperationSocket
    extends ActionNodeOperation {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (this.nodeInfo == null) {
                this.nodeInfo = new NodeInformation();
                this.nodeInfo.setIpaddress(null);
            }
            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }
                editorNodeConfigView = activePage.openEditor((IEditorInput)new EditorInputNodeView("Node Add/Edit/Delete" + NetworkClientNodeTreeView.getTitleSuffixEngineAddress(), this.nodeInfo, true), EditorNodeOperation.class.getName());
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

