/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;

public class SnmpMessage
extends SnmpSequence {
    public static final int MESSAGE_SEQUENCE_VERSION_POS = 0;
    public static final int MESSAGE_SEQUENCE_COMMUNITY_POS = 1;
    public static final int MESSAGE_SEQUENCE_PDU_POS = 2;
    public static final int VERSION_POS = 0;
    public static final int COMMUNITY_POS = 1;
    public static final int PDU_POS = 2;
    private List contentsList;

    public SnmpMessage() {
        this.contentsList = Collections.synchronizedList(new ArrayList());
    }

    public SnmpMessage(int version, String community, SnmpPDU pdu) {
        this.contentsList = Collections.synchronizedList(new ArrayList());
        this.contentsList.add(0, new SnmpInteger(version));
        this.contentsList.add(1, new SnmpOctetString(community));
        this.contentsList.add(2, pdu);
        try {
            this.setValue(this.contentsList);
        }
        catch (SnmpBadValueException snmpBadValueException) {}
    }

    public SnmpMessage(int version, String community, SnmpTrapPDU trapPdu) {
        this.contentsList = Collections.synchronizedList(new ArrayList());
        this.contentsList.add(0, new SnmpInteger(version));
        this.contentsList.add(1, new SnmpOctetString(community));
        this.contentsList.add(2, trapPdu);
        try {
            this.setValue(this.contentsList);
        }
        catch (SnmpBadValueException snmpBadValueException) {}
    }

    public SnmpMessage(byte[] enc) throws SnmpBadValueException {
        super(enc);
    }

    public void setSNMPMessage(int version, String community, SnmpPDU pdu) {
        this.contentsList.clear();
        this.contentsList.add(0, new SnmpInteger(version));
        this.contentsList.add(1, new SnmpOctetString(community));
        this.contentsList.add(2, pdu);
        try {
            this.setValue(this.contentsList);
        }
        catch (SnmpBadValueException snmpBadValueException) {}
    }

    public void setTLV(SNMPTLV nextTLV) throws SnmpBadValueException {
        this.extractFromBEREncoding(nextTLV.getValue());
    }

    public SnmpPDU getPDU() throws SnmpBadValueException {
        List contents = (List)this.getValue();
        Object pdu = contents.get(2);
        if (!(pdu instanceof SnmpPDU)) {
            throw new SnmpBadValueException("Wrong PDU type in message: expected SNMPPDU, have " + pdu.getClass().toString());
        }
        return (SnmpPDU)pdu;
    }

    public SnmpTrapPDU getTrapPDU() throws SnmpBadValueException {
        List contents = (List)this.getValue();
        Object pdu = contents.get(2);
        if (!(pdu instanceof SnmpTrapPDU)) {
            throw new SnmpBadValueException("Wrong PDU type in message: expected SNMPTrapPDU, have " + pdu.getClass().toString());
        }
        return (SnmpTrapPDU)pdu;
    }

    public byte getCommand() {
        List sequenceContentsList = this.getSequenceContentsList();
        return ((SNMPTLV)sequenceContentsList.get(2)).getTag();
    }

    public byte[] getCommunity() {
        List sequenceContentsList = this.getSequenceContentsList();
        return ((SNMPTLV)sequenceContentsList.get(1)).getValue();
    }

    public byte[] getVersion() {
        List sequenceContentsList = this.getSequenceContentsList();
        return ((SNMPTLV)sequenceContentsList.get(0)).getValue();
    }
}

