/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class SnmpManagerQueue {
    private static List<String> snmpManagerQueueList;
    private static final int QUEUE_LIMIT = 1000;
    private boolean isMonitor = false;

    private SnmpManagerQueue() {
        snmpManagerQueueList = Collections.synchronizedList(new LinkedList());
    }

    public synchronized void pushSnmpManagerQueue(String obj) {
        if (this.isMonitor) {
            if (snmpManagerQueueList.size() > 1000) {
                snmpManagerQueueList.remove(0);
                snmpManagerQueueList.add(obj);
            } else {
                snmpManagerQueueList.add(obj);
            }
        }
    }

    public synchronized String popSnmpManagerQueue() {
        String snmpManagerData = null;
        if (snmpManagerQueueList.size() > 0) {
            snmpManagerData = snmpManagerQueueList.get(0);
            snmpManagerQueueList.remove(0);
        }
        return snmpManagerData;
    }

    public void setMonitor(boolean isMonitor) {
        snmpManagerQueueList.clear();
        this.isMonitor = isMonitor;
    }

    public static SnmpManagerQueue getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ SnmpManagerQueue(SnmpManagerQueue snmpManagerQueue) {
        this();
    }

    private static class SingletonResource {
        static final SnmpManagerQueue RESOURCE = new SnmpManagerQueue(null);

        private SingletonResource() {
        }
    }
}

