/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;
import org.osgi.framework.Bundle;

public class EnterpriseOIDConfig {
    private static Logger logger = null;
    private Map<String, EnterpriseOIDInfo> enterpriseOidHashMap;

    private EnterpriseOIDConfig() {
        logger = Logger.getLogger(this.getClass().getName());
        this.enterpriseOidHashMap = Collections.synchronizedMap(new LinkedHashMap());
        URL url = this.getDocument("resources/enterprise_oid.txt");
        if (url != null) {
            this.parseFile(url);
        }
    }

    private URL getDocument(String filePath) {
        URL url = null;
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        url = bundle.getEntry(filePath);
        if (url == null) {
            logger.severe("Not found file url : " + filePath);
            return null;
        }
        return url;
    }

    public void parseFile(URL url) {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("file : " + url.getFile());
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return;
        }
        BufferedReader buffReader = null;
        try {
            try {
                String str;
                InputStreamReader ti = new InputStreamReader(is);
                buffReader = new BufferedReader(ti);
                while ((str = buffReader.readLine()) != null) {
                    Pattern pattern = Pattern.compile("[ \t]");
                    String[] item = pattern.split(str, 2);
                    if (item.length < 2) continue;
                    EnterpriseOIDInfo enterpriseOidInfo = new EnterpriseOIDInfo();
                    enterpriseOidInfo.setEnterpriseOID(item[0]);
                    String company = item[1].replaceAll("\t", " ");
                    enterpriseOidInfo.setCompany(company);
                    this.enterpriseOidHashMap.put(item[0], enterpriseOidInfo);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public Map getEnterpriseOidHashMap() {
        return this.enterpriseOidHashMap;
    }

    public static EnterpriseOIDConfig getInstance() {
        return SingletonResource.ENTERPRISE_OID_INSTANCE;
    }

    /* synthetic */ EnterpriseOIDConfig(EnterpriseOIDConfig enterpriseOIDConfig) {
        this();
    }

    private static class SingletonResource {
        static final EnterpriseOIDConfig ENTERPRISE_OID_INSTANCE = new EnterpriseOIDConfig(null);

        private SingletonResource() {
        }
    }
}

