/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import netjfwatcher.snmpmanager.trap.TrapForwardResourceFileParse;

public class TrapForward {
    private boolean isForward = true;
    private String forwardAddress;
    private HashMap enterpriseOIDHashMap;
    private String privateOID;
    private static Logger logger;

    private TrapForward() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public String extractEnterpriseOid(String privateOID) {
        String returnEnterpriseOid = null;
        String keyOid = "1.3.6.1.4.1.";
        int pos = privateOID.indexOf(keyOid);
        if (pos < 0) {
            return returnEnterpriseOid;
        }
        String workOid = privateOID.substring(keyOid.length());
        String[] arrayOid = workOid.split("[.]");
        if (arrayOid == null || arrayOid.length <= 0) {
            return returnEnterpriseOid;
        }
        returnEnterpriseOid = arrayOid[0];
        return returnEnterpriseOid;
    }

    public boolean filterTrapForward(String privateOID) {
        if (!TrapForwardResourceFileParse.getInstance().getForwardFlag().equals("true")) {
            this.isForward = false;
            return this.isForward;
        }
        this.isForward = true;
        this.privateOID = privateOID;
        if (privateOID == null) {
            return false;
        }
        this.enterpriseOIDHashMap = TrapForwardResourceFileParse.getInstance().getEnterpriseOidHashMap();
        if (this.enterpriseOIDHashMap.size() == 0) {
            return true;
        }
        return this.enterpriseOIDHashMap.containsKey(privateOID);
    }

    public void forwardTrap(String community, SnmpSequence trapPDUSequence, int version, String sourceAddress) {
        this.forwardAddress = TrapForwardResourceFileParse.getInstance().getForwardAddress();
        String hostAddress = "";
        try {
            InetAddress host = InetAddress.getByName(this.forwardAddress);
            hostAddress = host.getHostAddress();
        }
        catch (UnknownHostException e2) {
            logger.warning(e2.getMessage());
            return;
        }
        try {
            if (trapPDUSequence != null) {
                AgentDispatcher dispacher = new AgentDispatcher();
                dispacher.dispacherTrapSend(hostAddress, version, community, trapPDUSequence);
                logger.info("Trap forward Destination Address=" + hostAddress + " Source Address=" + sourceAddress + " Enterprise Private OID=" + this.privateOID);
            }
        }
        catch (SocketException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (UnknownHostException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SnmpV3ConfigurationException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (GeneralSecurityException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
        catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }
    }

    public static TrapForward getInstance() {
        return SingletonResource.TRAP_FORWARD_IMPL;
    }

    /* synthetic */ TrapForward(TrapForward trapForward) {
        this();
    }

    private static class SingletonResource {
        static final TrapForward TRAP_FORWARD_IMPL = new TrapForward(null);

        private SingletonResource() {
        }
    }
}

