/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.webbrowser.view;

import java.util.logging.Logger;
import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;
import netjfwatcher.webbrowser.preferences.HttpAccessPreferenceException;
import netjfwatcher.webbrowser.view.BrowserLocationChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class BrowserEditors
extends EditorPart {
    private static Logger logger;
    private Browser browser;

    public BrowserEditors() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public boolean isDirty() {
        return false;
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            this.browser = new Browser(parent, 4);
        }
        catch (SWTError sWTError) {
            logger.warning("Browser cannot be initialized.");
            MessageBox messageBox = new MessageBox(parent.getShell(), 33);
            messageBox.setMessage("Browser cannot be initialized.");
            messageBox.setText("Exit");
            messageBox.open();
        }
        try {
            this.setStatusLine();
            UrlEditorInput urlEditorInput = (UrlEditorInput)this.getEditorInput();
            this.browser.addLocationListener((LocationListener)new BrowserLocationChangeListener(urlEditorInput.getName()));
            this.browser.setUrl(urlEditorInput.getUrl());
        }
        catch (HttpAccessPreferenceException e) {
            e.printStackTrace();
        }
    }

    private void setStatusLine() throws HttpAccessPreferenceException {
        SubStatusLineManager statusLineManager = (SubStatusLineManager)this.getEditorSite().getActionBars().getStatusLineManager();
        statusLineManager.setVisible(true);
        statusLineManager.setMessage("Access URL = " + HttpAccessPreference.getInstance().getUrl());
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof UrlEditorInput)) {
            logger.warning("Wrong input: " + input.getClass());
            throw new PartInitException("Wrong input: " + input.getClass());
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
    }
}

