/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.xhtml;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.internal.xhtml.AbstractUAElement;
import org.eclipse.help.internal.xhtml.BundleUtil;
import org.eclipse.help.internal.xhtml.DOMUtil;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UATopicExtension
extends AbstractUAElement {
    protected static final String TAG_TOPIC_EXTENSION = "topicExtension";
    protected static final String ATT_PATH = "path";
    private static final String ATT_CONTENT = "content";
    private static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    private String path;
    private String contentFile;
    private String contentId;
    private Element element;

    UATopicExtension(Element element, Bundle bundle) {
        super(element, bundle);
        this.path = this.getAttribute(element, ATT_PATH);
        this.extractFileAndId(this.getAttribute(element, ATT_CONTENT), bundle);
        this.contentFile = BundleUtil.getResolvedResourceLocation(this.contentFile, bundle, false);
        this.element = element;
    }

    public String getPath() {
        return this.path;
    }

    public Element[] getElements() {
        UAContentParser parser = new UAContentParser(this.contentFile);
        Document dom = parser.getDocument();
        if (dom != null) {
            if (this.contentId != null) {
                return new Element[]{dom.getElementById(this.contentId)};
            }
            Element extensionBody = DOMUtil.getBodyElement(dom);
            return DOMUtil.getElementsByTagName(extensionBody, "*");
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    public Element getElement() {
        return this.element;
    }

    private void extractFileAndId(String content, Bundle bundle) {
        Path resourcePath = new Path(content);
        if (FileLocator.find((Bundle)bundle, (IPath)resourcePath, null) != null) {
            this.contentFile = content;
        } else {
            int lastSlashIndex = content.lastIndexOf(47);
            if (lastSlashIndex != -1) {
                this.contentFile = content.substring(0, lastSlashIndex);
                this.contentId = content.substring(lastSlashIndex + 1);
            } else {
                this.contentFile = content;
            }
        }
    }
}

