/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.SetTargetsDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.model.BuilderUtils;

public class AntBuilderTargetsTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration fConfiguration;
    private Button fAfterCleanTarget;
    private Button fManualBuildTarget;
    private Button fAutoBuildTarget;
    private Button fDuringCleanTarget;
    private Text fAfterCleanTargetText;
    private Text fManualBuildTargetText;
    private Text fAutoBuildTargetText;
    private Text fDuringCleanTargetText;
    private Map fAttributeToTargets = new HashMap();
    private static final String NOT_ENABLED = AntLaunchConfigurationMessages.AntBuilderTargetsTab_0;
    private static final String DEFAULT_TARGET_SELECTED = AntLaunchConfigurationMessages.AntBuilderTargetsTab_10;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String attribute = null;
            Object source = e.getSource();
            Text text = null;
            if (source == AntBuilderTargetsTab.this.fAfterCleanTarget) {
                attribute = "org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS";
                text = AntBuilderTargetsTab.this.fAfterCleanTargetText;
            } else if (source == AntBuilderTargetsTab.this.fManualBuildTarget) {
                attribute = "org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS";
                text = AntBuilderTargetsTab.this.fManualBuildTargetText;
            } else if (source == AntBuilderTargetsTab.this.fAutoBuildTarget) {
                attribute = "org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS";
                text = AntBuilderTargetsTab.this.fAutoBuildTargetText;
            } else if (source == AntBuilderTargetsTab.this.fDuringCleanTarget) {
                attribute = "org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS";
                text = AntBuilderTargetsTab.this.fDuringCleanTargetText;
            }
            AntBuilderTargetsTab.this.setTargets(attribute, text);
            AntBuilderTargetsTab.this.updateLaunchConfigurationDialog();
        }
    };

    protected void createTargetsComponent(Composite parent) {
        this.createLabel(AntLaunchConfigurationMessages.AntBuilderTargetsTab_1, parent);
        this.fAfterCleanTargetText = this.createText(parent);
        this.fAfterCleanTarget = this.createPushButton(parent, AntLaunchConfigurationMessages.AntBuilderTargetsTab_2, null);
        GridData gd = new GridData(128);
        this.fAfterCleanTarget.setLayoutData((Object)gd);
        this.fAfterCleanTarget.addSelectionListener(this.fSelectionListener);
        this.createLabel(AntLaunchConfigurationMessages.AntBuilderTargetsTab_3, parent);
        this.fManualBuildTargetText = this.createText(parent);
        this.fManualBuildTarget = this.createPushButton(parent, AntLaunchConfigurationMessages.AntBuilderTargetsTab_4, null);
        gd = new GridData(128);
        this.fManualBuildTarget.setLayoutData((Object)gd);
        this.fManualBuildTarget.addSelectionListener(this.fSelectionListener);
        this.createLabel(AntLaunchConfigurationMessages.AntBuilderTargetsTab_5, parent);
        this.fAutoBuildTargetText = this.createText(parent);
        this.fAutoBuildTarget = this.createPushButton(parent, AntLaunchConfigurationMessages.AntBuilderTargetsTab_6, null);
        gd = new GridData(128);
        this.fAutoBuildTarget.setLayoutData((Object)gd);
        this.fAutoBuildTarget.addSelectionListener(this.fSelectionListener);
        this.createLabel(AntLaunchConfigurationMessages.AntBuilderTargetsTab_7, parent);
        this.fDuringCleanTargetText = this.createText(parent);
        this.fDuringCleanTarget = this.createPushButton(parent, AntLaunchConfigurationMessages.AntBuilderTargetsTab_8, null);
        gd = new GridData(128);
        this.fDuringCleanTarget.setLayoutData((Object)gd);
        this.fDuringCleanTarget.addSelectionListener(this.fSelectionListener);
    }

    private Label createLabel(String text, Composite parent) {
        Label newLabel = new Label(parent, 0);
        newLabel.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        newLabel.setLayoutData((Object)gd);
        newLabel.setFont(parent.getFont());
        return newLabel;
    }

    private Text createText(Composite parent) {
        Text newText = new Text(parent, 2634);
        newText.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.widthHint = 200;
        newText.setLayoutData((Object)gd);
        return newText;
    }

    protected void setTargets(String attribute, Text text) {
        ILaunchConfigurationWorkingCopy copy = null;
        try {
            copy = this.fConfiguration.getWorkingCopy();
        }
        catch (CoreException coreException) {
            return;
        }
        copy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", (String)this.fAttributeToTargets.get(attribute));
        SetTargetsDialog dialog = new SetTargetsDialog(this.getShell(), copy);
        if (dialog.open() != 0) {
            return;
        }
        String targetsSelected = dialog.getTargetsSelected();
        if (targetsSelected == null) {
            text.setEnabled(true);
            this.fAttributeToTargets.remove(attribute);
            this.setTargetsForUser(text, DEFAULT_TARGET_SELECTED, null);
        } else if (targetsSelected.length() == 0) {
            text.setEnabled(false);
            this.fAttributeToTargets.remove(attribute);
            text.setText(NOT_ENABLED);
        } else {
            text.setEnabled(true);
            this.fAttributeToTargets.put(attribute, targetsSelected);
            this.setTargetsForUser(text, targetsSelected, null);
        }
    }

    private void setTargetsForUser(Text text, String targetsSelected, String configTargets) {
        if (!text.isEnabled()) {
            text.setText(NOT_ENABLED);
            return;
        }
        if (targetsSelected == null) {
            if (configTargets == null) {
                text.setText(DEFAULT_TARGET_SELECTED);
                return;
            }
            targetsSelected = configTargets;
        }
        String[] targets = AntUtil.parseRunTargets(targetsSelected);
        StringBuffer result = new StringBuffer(targets[0]);
        int i = 1;
        while (i < targets.length) {
            result.append(", ");
            result.append(targets[i]);
            ++i;
        }
        text.setText(result.toString());
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.externaltools.builders_tab_context");
        GridLayout layout = new GridLayout();
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createTargetsComponent(mainComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_TARGETS_UPDATED", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
        this.fAfterCleanTargetText.setEnabled(false);
        this.fManualBuildTargetText.setEnabled(false);
        this.fAutoBuildTargetText.setEnabled(false);
        this.fDuringCleanTargetText.setEnabled(false);
        this.initializeBuildKinds(configuration);
        this.intializeTargets(configuration);
    }

    private void intializeTargets(ILaunchConfiguration configuration) {
        String configTargets = null;
        String autoTargets = null;
        String manualTargets = null;
        String afterCleanTargets = null;
        String duringCleanTargets = null;
        try {
            if (!configuration.getAttribute("org.eclipse.ant.ui.ATTR_TARGETS_UPDATED", false)) {
                configTargets = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            }
            autoTargets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS", null);
            manualTargets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS", null);
            afterCleanTargets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS", null);
            duringCleanTargets = configuration.getAttribute("org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS", null);
            this.initializeAttributeToTargets(this.fAutoBuildTargetText, autoTargets, configTargets, "org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS");
            this.initializeAttributeToTargets(this.fManualBuildTargetText, manualTargets, configTargets, "org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS");
            this.initializeAttributeToTargets(this.fDuringCleanTargetText, duringCleanTargets, configTargets, "org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS");
            this.initializeAttributeToTargets(this.fAfterCleanTargetText, afterCleanTargets, configTargets, "org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS");
        }
        catch (CoreException ce) {
            AntUIPlugin.log("Error reading configuration", ce);
        }
        this.setTargetsForUser(this.fManualBuildTargetText, manualTargets, configTargets);
        this.setTargetsForUser(this.fAfterCleanTargetText, afterCleanTargets, configTargets);
        this.setTargetsForUser(this.fDuringCleanTargetText, duringCleanTargets, configTargets);
        this.setTargetsForUser(this.fAutoBuildTargetText, autoTargets, configTargets);
    }

    private void initializeAttributeToTargets(Text textComponent, String specificTargets, String configTargets, String attribute) {
        if (textComponent.isEnabled()) {
            if (specificTargets == null && configTargets != null) {
                this.fAttributeToTargets.put(attribute, configTargets);
            } else {
                this.fAttributeToTargets.put(attribute, specificTargets);
            }
        }
    }

    private void initializeBuildKinds(ILaunchConfiguration configuration) {
        String buildKindString = null;
        try {
            buildKindString = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", "");
        }
        catch (CoreException e) {
            AntUIPlugin.log("Error reading configuration", e);
        }
        int[] buildTypes = BuilderUtils.buildTypesToArray((String)buildKindString);
        int i = 0;
        while (i < buildTypes.length) {
            switch (buildTypes[i]) {
                case 6: {
                    this.fAfterCleanTargetText.setEnabled(true);
                    break;
                }
                case 10: {
                    this.fManualBuildTargetText.setEnabled(true);
                    break;
                }
                case 9: {
                    this.fAutoBuildTargetText.setEnabled(true);
                    break;
                }
                case 15: {
                    this.fDuringCleanTargetText.setEnabled(true);
                }
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer buffer = new StringBuffer();
        if (!this.fAfterCleanTargetText.getText().equals(NOT_ENABLED)) {
            buffer.append("full").append(',');
        }
        if (!this.fManualBuildTargetText.getText().equals(NOT_ENABLED)) {
            buffer.append("incremental").append(',');
        }
        if (!this.fAutoBuildTargetText.getText().equals(NOT_ENABLED)) {
            buffer.append("auto").append(',');
        }
        if (!this.fDuringCleanTargetText.getText().equals(NOT_ENABLED)) {
            buffer.append("clean");
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", buffer.toString());
        String targets = (String)this.fAttributeToTargets.get("org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS");
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_ANT_AFTER_CLEAN_TARGETS", targets);
        targets = (String)this.fAttributeToTargets.get("org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS");
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_ANT_AUTO_TARGETS", targets);
        targets = (String)this.fAttributeToTargets.get("org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS");
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS", targets);
        targets = (String)this.fAttributeToTargets.get("org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS");
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_ANT_CLEAN_TARGETS", targets);
        configuration.setAttribute("org.eclipse.ant.ui.ATTR_TARGETS_UPDATED", true);
    }

    public String getName() {
        return AntLaunchConfigurationMessages.AntTargetsTab_Tar_gets_14;
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_TAB_ANT_TARGETS");
    }
}

