/*
 * Created on 2004/05/31
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.mail;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

/**
 * [MXgƂĕێVOgNXłB A[oƂɃXgɒǉA[MƂɃXg폜܂B
 * 
 * ێł100łB 100𒴂ꍇ͌Âɍ폜܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class MailSendInfoList {
	/* Mail QueueXgTCY */
	private static final int MAIL_QUEUE_LIST_SIZE = 100;

	/* MO */
	private static Logger logger = null;

	/* [MێList */
	private List mailList = Collections.synchronizedList(new LinkedList());

	/*
	 * [MXgƂĕێVOgNX CX^X𐶐܂B
	 */
	private MailSendInfoList() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * [Listɒǉ܂B iA[oƂɒǉ܂j
	 * 
	 * @param subject
	 *            Subject
	 * @param messageBody
	 *            bZ[WBody
	 * @param errorLevel
	 *            G[xy
	 * @param errorCode
	 *            G[R[h
	 */
	public synchronized void setMailList(String subject, String messageBody,
			String errorLevel, String errorCode) {


		if (!MailSendFilter.getInstance().checkAlarmLevelFilter(errorLevel)) {
			ResourceInfo resourceInfo = SystemResourceConfig.getInstance()
					.getResourceFileParse().getResourceInfo();
			logger.info("Mail filtering error level code="
					+ resourceInfo.getMailFilterErrorLevel()
					+ " ,Alarm level code=" + errorLevel);
			return;
		}
		if (!MailSendFilter.getInstance().checkMessageFilter(messageBody)) {
			ResourceInfo resourceInfo = SystemResourceConfig.getInstance()
					.getResourceFileParse().getResourceInfo();

			logger.info("Mail filtering message="
					+ resourceInfo.getMailFilterString() + " , Alarm message="
					+ messageBody);
			return;
		}
		// mail Queue ListTCY𒴂ꍇ͍ŌÂ̏폜Queue Listɒǉ
		if (mailList.size() > MAIL_QUEUE_LIST_SIZE) {
			mailList.remove(0);
			logger.warning("Remove mail list for over mail queue list (size="
					+ mailList.size() + ")");
		}

		MailSendInfo info = new MailSendInfo();
		info.setSubject(subject);
		info.setMessageBody(messageBody);
		info.setErrorLevel(errorLevel);
		info.setErrorCode(errorCode);
		mailList.add(info);
	}

	/**
	 * [Xg擾܂B
	 * 
	 * @return MailM
	 */
	public synchronized MailSendInfo getMailInfo() {
		MailSendInfo info = null;

		if (mailList.size() == 0) {
			return null;
		}

		info = (MailSendInfo) mailList.get(0);
		mailList.remove(0);

		return info;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static MailSendInfoList getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final MailSendInfoList RESOURCE = new MailSendInfoList();
	}
}
