/*
 * Created on 2004/05/31
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.mail;

import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;


/**
 * 1bMailMXg`FbNāAM񂪂MailMs܂B
 * ܂AMailMMailMK[h^C}[Zbg܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ThreadMailSendGuard implements Runnable {
    /* MO */
    private static Logger logger = null;

    /* ThreadNwaitJE^ */
    private static final int WAIT_COUNT = 5;
    private static final int MAIL_CONTROL_THREAD_TIMER = 1000;

    /* MailMK[h^C */
    private int guardTime = 0;

    /* MailMK[h^CJEgl[utO */
    private boolean isCountStart = true;

    /* MailMK[h^CThread */
    private Thread mailGuardThread;

    /*
     * MailMK[h^C}[NXCX^X𐶐܂B
     */
    private ThreadMailSendGuard() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * MailMK[h^CThreadN܂B
     *
     * @return N true : 
     * false : s
     */
    public boolean startThread() {
        if (mailGuardThread == null) {
            mailGuardThread = new Thread(this);
            mailGuardThread.start();

            int wait = 0;

            while (!mailGuardThread.isAlive()) {
                wait++;

                if (wait >= WAIT_COUNT) {
                    break;
                }

                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            return true;
        }

        return false;
    }

    /**
     * MailMK[h^CThread~܂B
     *
     */
    public void stopReceiving() {
        if (mailGuardThread == null) {
            return;
        }

        // interrupt receive thread so it will die a natural death
        mailGuardThread.interrupt();

        /* TrapMThread~܂Loop */
        while ((mailGuardThread != null) && mailGuardThread.isAlive()) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        logger.info("Thread stop");
        mailGuardThread = null;
    }

    /**
     * MailMK[h^CThreadłB
     */
    public void run() {
        while ((mailGuardThread != null) && mailGuardThread.isAlive()) {
            if (isCountStart) {
                if (guardTime < 0) {
                    MailSendInfo mailData =
                        MailSendInfoList.getInstance().getMailInfo();

                    if (mailData != null) {
                        // Mail Send
                        MailSend mailSender = MailSend.getInstance();
                        mailSender.checkMailSend(
                            mailData.getSubject(), mailData.getMessageBody());

                        /*
                         * MailMK[h^CăZbg
                         */
                        SystemResourceFileParse resourceset =
                            (SystemResourceConfig.getInstance())
                            .getResourceFileParse();
                        guardTime =
                            Integer.parseInt(
                                resourceset.getResourceInfo().getMailGuardTime());
                        logger.info("Mail send guard time set : " + guardTime);
                    }
                } else {
                    guardTime--;
                }
            }

            // logger.info("guardTime " + guardTime);
            try {
                Thread.sleep(MAIL_CONTROL_THREAD_TIMER);
            } catch (InterruptedException e) {
                /* Stopw */
                logger.info("Stop Mail guard time count " + e.getMessage());

                break;
            }
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ThreadMailSendGuard getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * MailMK[h^CThreadԂ܂B
     *
     * @return mailGuardThread MailMK[h^CThread
     */
    public Thread getMailGuardThread() {
        return mailGuardThread;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ThreadMailSendGuard RESOURCE = new ThreadMailSendGuard();
    }
}
