/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.resourceconfig.EngineResourceConfig;
import netjfwatcher.engine.resourceconfig.EngineResourceInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


/**
 * GWvtFXy[WNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EnginePreferancePage extends AbstractEnginePreferancePage
    implements IWorkbenchPreferencePage {
    /* MO */
    private static Logger logger;

    /* eLXg */
    private static final int TEXT_WIDTH = 120;
    private static final int TEXT_WIDTH2 = 250;
    
    /* List widthhint */
    private static final int LIST_WIDTHHINT = 200;

    /* List verticalSpan */
    private static final int LIST_VERTIALSPAN = 7;

    /* List ItemHeight */
    private static final int LIST_ITEMHEIGHT = 8;

	/* zFColor` */
	private static Color whiteColor = new Color(null, 255, 255, 255);

    /* \[X */
    private ResourceInfo resourceInfo;

    /* GWR}hM|[g\Text */
    private Text engineCommandReceivePortText;

    /* GWR}hM|[g\Text */
    private Text engineCommandReceiveAllowHostText;

    /* GWAhXXg */
    private List detinationEngineAddressList;

    /* GW|[gXg */
    private List destinationEnginePortList;

    /* GWAhX\Text */
    private Text destinationEngineAddressText;

    /* GW|[g\Text */
    private Text destinationEnginePortText;

    /* GWڑ^CAEgl\Text */
    private Text destinationEngineTimeoutText;

    /* Socket ClientڑGWǉ{^ */
    private Button addButton;

    /* Socket ClientڑGWҏW{^ */
    private Button editButton;

    /* Socket ClientڑGW폜{^ */
    private Button deleteButton;

    /* GWAhX\[NText */
    private Text destinationEngineAddressWorkText;

    /* GW|[g\[NText */
    private Text destinationEnginePortWorkText;

    /* GWڑ^CAEgl\[NText */
    private Text destinationEngineTimeoutWorkText;

    /* GWڑ[U\[NText */
    private Text destinationEngineUserNameWorkText;
    /* GWڑpX[h\[NText */
    private Text destinationEnginePasswordWorkText;
    
    /* GWڑ񃊃Xg */
    private ArrayList engineList;

    /* GWڑMap */
    private HashMap engineMap;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // w̃GWAhXɑΉPortԍ\[X擾
        engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        engineMap = new HashMap();

        // Initialize the preference store we wish to use
        // setPreferenceStore(RssrPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        Color textBackColor = whiteColor;
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);

        label.setText("Server(Engine) Command receive Allow-Host");
        label.setLayoutData(new GridData());
        engineCommandReceiveAllowHostText = new Text(composite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH2;
        engineCommandReceiveAllowHostText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Server(Engine) Command receive Port");
        label.setLayoutData(new GridData());
        engineCommandReceivePortText = new Text(composite, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineCommandReceivePortText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("For Socket Client");
        gridData = new GridData();
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Adrress");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEngineAddressText =
            new Text(composite, SWT.READ_ONLY | SWT.BORDER);
        destinationEngineAddressText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEngineAddressText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Port");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEnginePortText =
            new Text(composite, SWT.READ_ONLY | SWT.BORDER);
        destinationEnginePortText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEnginePortText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Timeout(ms)");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEngineTimeoutText =
            new Text(composite, SWT.READ_ONLY | SWT.BORDER);
        destinationEngineTimeoutText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEngineTimeoutText.setLayoutData(gridData);

        detinationEngineAddressList =
            new List(composite, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTIALSPAN;
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint =
            detinationEngineAddressList.getItemHeight() * LIST_ITEMHEIGHT;

        detinationEngineAddressList.setLayoutData(data);

        destinationEnginePortList =
            new List(composite, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);

        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTIALSPAN;
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint =
            destinationEnginePortList.getItemHeight() * LIST_ITEMHEIGHT;

        destinationEnginePortList.setLayoutData(data);

        addButton = new Button(composite, SWT.NONE);
        addButton.setText("Add");
        addButton.setLayoutData(new GridData());
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData(gridData);

        editButton = new Button(composite, SWT.NONE);
        editButton.setText("Edit");
        editButton.setLayoutData(new GridData());
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData(gridData);

        deleteButton = new Button(composite, SWT.NONE);
        deleteButton.setText("Delete");
        deleteButton.setLayoutData(new GridData());
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Adrress");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEngineAddressWorkText = new Text(composite, SWT.BORDER);
        destinationEngineAddressWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEngineAddressWorkText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Port");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEnginePortWorkText = new Text(composite, SWT.BORDER);
        destinationEnginePortWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEnginePortWorkText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Timeout(ms)");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEngineTimeoutWorkText = new Text(composite, SWT.BORDER);
        destinationEngineTimeoutWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEngineTimeoutWorkText.setLayoutData(gridData);

        
        
        
        
        
        
        
        
        
        
        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) User Name");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEngineUserNameWorkText = new Text(composite, SWT.BORDER);
        destinationEngineUserNameWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEngineUserNameWorkText.setLayoutData(gridData);
        
        label = new Label(composite, SWT.NONE);
        label.setText("Destination Server(Engine) Password");
        gridData = new GridData();
        label.setLayoutData(gridData);

        destinationEnginePasswordWorkText = new Text(composite, SWT.BORDER | SWT.PASSWORD);
        destinationEnginePasswordWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        destinationEnginePasswordWorkText.setLayoutData(gridData);
        
        
        
        showXMLSocketProp();

        setListener();

        return composite;
    }

    /*
     * ListenerZbg܂B
     *
     */
    private void setListener() {
        detinationEngineAddressList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    int index = detinationEngineAddressList.getSelectionIndex();
                    if(index < 0) {
    					return;
    				}
                    destinationEnginePortList.select(index);
                    destinationEngineAddressText.setText(
                        detinationEngineAddressList.getItem(index));
                    destinationEnginePortText.setText(
                        destinationEnginePortList.getItem(index));

                    destinationEngineTimeoutText.setText(
                        ((EngineResourceInfo) engineList.get(index))
                        .getEngineTimeout());

                    destinationEngineAddressWorkText.setText(
                        detinationEngineAddressList.getItem(index));
                    destinationEnginePortWorkText.setText(
                        destinationEnginePortList.getItem(index));

                    destinationEngineTimeoutWorkText.setText(
                        ((EngineResourceInfo) engineList.get(index))
                        .getEngineTimeout());
                    destinationEngineUserNameWorkText.setText(
                            ((EngineResourceInfo) engineList.get(index))
                            .getUserName());
                    destinationEnginePasswordWorkText.setText(
                            ((EngineResourceInfo) engineList.get(index))
                            .getPassword());
                }
            });

        destinationEnginePortList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    int index = destinationEnginePortList.getSelectionIndex();
                    if(index < 0) {
    					return;
    				}
                    detinationEngineAddressList.select(index);
                    destinationEngineAddressText.setText(
                        detinationEngineAddressList.getItem(index));
                    destinationEnginePortText.setText(
                        destinationEnginePortList.getItem(index));
                    destinationEngineTimeoutText.setText(
                        ((EngineResourceInfo) engineList.get(index))
                        .getEngineTimeout());
                    destinationEngineAddressWorkText.setText(
                        detinationEngineAddressList.getItem(index));
                    destinationEnginePortWorkText.setText(
                        destinationEnginePortList.getItem(index));

                    destinationEngineTimeoutWorkText.setText(
                        ((EngineResourceInfo) engineList.get(index))
                        .getEngineTimeout());
                    
                }
            });

        addButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    if (
                        !destinationEngineAddressWorkText.getText().equals("")
                            && !destinationEnginePortWorkText.getText().equals(
                                "")
                            && !destinationEngineTimeoutWorkText.getText()
                                                                    .equals("")) {
                        if (
                            !engineMap.containsKey(
                                    destinationEngineAddressWorkText.getText())) {
                            EngineResourceInfo engineInfo =
                                new EngineResourceInfo();
                            engineInfo.setEngineIPaddress(
                                destinationEngineAddressWorkText.getText());
                            engineInfo.setEnginePort(
                                destinationEnginePortWorkText.getText());
                            engineInfo.setEngineTimeout(
                                destinationEngineTimeoutWorkText.getText());
                            engineInfo.setUserName(
                                    destinationEngineUserNameWorkText.getText());
                            engineInfo.setPassword(
                                    destinationEnginePasswordWorkText.getText());
                            engineInfo.setEngineFlashXMLSocketPort(
                                ((EngineResourceInfo) engineList.get(0))
                                .getEngineFlashXMLSocketPort());
                            engineMap.put(
                                destinationEngineAddressWorkText.getText(),
                                engineInfo);

                            engineList.add(engineInfo);
                            showXMLSocketProp();
                        } else {
                            MessageDialog.openError(
                                getShell(), "Error",
                                "Already Engine Address = "
                                + destinationEngineAddressWorkText.getText());

                            return;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        editButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    if (
                        !destinationEngineAddressWorkText.getText().equals("")
                            && !destinationEnginePortWorkText.getText().equals(
                                "")
                            && !destinationEngineTimeoutWorkText.getText()
                                                                    .equals("")) {
                        if (
                            engineMap.containsKey(
                                    destinationEngineAddressWorkText.getText())) {
                            EngineResourceInfo engineInfo =
                                (EngineResourceInfo) engineMap.get(
                                    destinationEngineAddressWorkText.getText());

                            engineInfo.setEnginePort(
                                destinationEnginePortWorkText.getText());
                            engineInfo.setEngineTimeout(
                                destinationEngineTimeoutWorkText.getText());
                            engineInfo.setUserName(
                                    destinationEngineUserNameWorkText.getText());
                            engineInfo.setPassword(
                                    destinationEnginePasswordWorkText.getText());
                            engineMap.put(
                                destinationEngineAddressWorkText.getText(),
                                engineInfo);

                            engineList.clear();

                            for (
                                Iterator it = engineMap.entrySet().iterator();
                                    it.hasNext();) {
                                Map.Entry ent = (Map.Entry) it.next();
                                String engineAddress = (String) ent.getKey();
                                EngineResourceInfo workEngineInfo =
                                    (EngineResourceInfo) engineMap.get(
                                        engineAddress);

                                if (workEngineInfo == null) {
                                    continue;
                                }

                                engineList.add(workEngineInfo);
                            }

                            showXMLSocketProp();
                        } else {
                            MessageDialog.openError(
                                getShell(), "Error",
                                "No Exit Engine Address = "
                                + destinationEngineAddressWorkText.getText());

                            return;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        deleteButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    if (
                        !destinationEngineAddressWorkText.getText().equals("")
                            && !destinationEnginePortWorkText.getText().equals(
                                "")
                            && !destinationEngineTimeoutWorkText.getText()
                                                                    .equals("")) {
                        if (
                            engineMap.containsKey(
                                    destinationEngineAddressWorkText.getText())) {
                            engineMap.remove(
                                destinationEngineAddressWorkText.getText());
                            engineList.clear();

                            for (
                                Iterator it = engineMap.entrySet().iterator();
                                    it.hasNext();) {
                                Map.Entry ent = (Map.Entry) it.next();
                                String engineAddress = (String) ent.getKey();
                                EngineResourceInfo workEngineInfo =
                                    (EngineResourceInfo) engineMap.get(
                                        engineAddress);

                                if (workEngineInfo == null) {
                                    continue;
                                }

                                engineList.add(workEngineInfo);
                            }

                            showXMLSocketProp();
                        } else {
                            MessageDialog.openError(
                                getShell(), "Error",
                                "No Exit Engine Address = "
                                + destinationEngineAddressWorkText.getText());

                            return;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     * text\Zbg܂B
     */
    private void showXMLSocketProp() {
        detinationEngineAddressList.removeAll();
        destinationEnginePortList.removeAll();

        String engineAddress = "";
        String enginePortString = "";
        engineMap.clear();

        for (int i = 0; i < engineList.size(); i++) {
            engineAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            enginePortString =
                ((EngineResourceInfo) engineList.get(i)).getEnginePort();

            detinationEngineAddressList.add(engineAddress);
            destinationEnginePortList.add(enginePortString);

            engineMap.put(
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress(),
                engineList.get(i));
        }

        engineCommandReceiveAllowHostText.setText(
            resourceInfo.getEngineAllowHost());
        engineCommandReceivePortText.setText(resourceInfo.getEnginePort());

        destinationEngineAddressText.setText(
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress());
        destinationEnginePortText.setText(
            ClientEngineInfo.getClientEngineInfoInstance().getEnginePort());

        detinationEngineAddressList.setData(
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress());
        destinationEnginePortList.setData(
            ClientEngineInfo.getClientEngineInfoInstance().getEnginePort());
        destinationEngineTimeoutText.setText(
            ((EngineResourceInfo) engineList.get(0)).getEngineTimeout());
        /*
        destinationEngineUserNameWorkText.setText(
                ((EngineResourceInfo) engineList.get(0)).getUserName());
        destinationEnginePasswordWorkText.setText(
                ((EngineResourceInfo) engineList.get(0)).getPassword());
        */
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();
        engineCommandReceiveAllowHostText.setText(
            resourceInfo.getEngineAllowHost());
        engineCommandReceivePortText.setText(resourceInfo.getEnginePort());
        destinationEngineAddressText.setText(
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress());
        destinationEnginePortText.setText(
            ClientEngineInfo.getClientEngineInfoInstance().getEnginePort());

        detinationEngineAddressList.setData(
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress());
        detinationEngineAddressList.select(0);
        destinationEnginePortList.setData(
            ClientEngineInfo.getClientEngineInfoInstance().getEnginePort());
        destinationEnginePortList.select(0);
        destinationEngineTimeoutText.setText(
            ((EngineResourceInfo) engineList.get(0)).getEngineTimeout());
        /*
        destinationEngineUserNameWorkText.setText(
                ((EngineResourceInfo) engineList.get(0)).getUserName());
        destinationEnginePasswordWorkText.setText(
                ((EngineResourceInfo) engineList.get(0)).getPassword());
                */
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        String commandReceivePort = engineCommandReceivePortText.getText();

        try {
            Integer.parseInt(commandReceivePort);
        } catch (NumberFormatException e) {
        	Shell shell = new Shell();
            MessageDialog.openError(
                shell, "Error", "Illegal Port=" + commandReceivePort);
            engineCommandReceivePortText.setFocus();
            shell.dispose();

            return false;
        }

        /*
        logger.info("Engine command receive port=" + commandReceivePort);
        logger.info(
            "Engine connect address=" + destinationEngineAddressText.getText());
        logger.info(
            "Engine connect port=" + destinationEnginePortText.getText());
        */
        resourceInfo.setEngineAllowHost(
            engineCommandReceiveAllowHostText.getText());
        resourceInfo.setEnginePort(commandReceivePort);

        /* \`XMLt@CXV */
        saveResourceXMLInfo(resourceInfo);

        ClientEngineInfo.getClientEngineInfoInstance().setEngineAddress(
            destinationEngineAddressText.getText());
        ClientEngineInfo.getClientEngineInfoInstance().setEnginePort(
            destinationEnginePortText.getText());

        String clientXmlSocketPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();
        EngineResourceConfig.getInstance().getEngineInfo().updateEngineResource(
            engineList, clientXmlSocketPort);

        return super.performOk();
    }
}
