/*
 * Created on 2004/05/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * ftHgSNMP(System/Interface MIB)̎悷Cxg
 * L[ƂĊǗNXłB
 * SNMP̎ɃCxg̃L[ɓo^ASNMP̎Thraed
 * ̂̈ThreadL[̃CxgǂݏoĎs܂B
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class QueueForDefaultSnmpMib extends AbstractQueueForProtocolCheck {
    /*
     * ftHgSNMP(System/Interface MIB)̎悷CxgL[Ƃ
     * ێ郊Xg
     */
    private List<NodeWatchInfo> queueList = Collections.synchronizedList(new LinkedList<NodeWatchInfo>());

    /**
     * ftHgSNMP(System/Interface MIB)̎悷CxgL[Ƃ
     * ǗNXCX^X𐶐܂B
     */
    private QueueForDefaultSnmpMib() {
    }

    /**
     * m[hĎL[Ɋi[܂B
     *
     * @param info m[hĎ
     */
    public synchronized void pushQue(NodeWatchInfo info) {
        if (!isPause) {
            checkQueueSize(queueList, info.getIpaddress());

            queueList.add(queueList.size(), info);
        }
    }

    /**
     * L[m[hĎPop܂B
     *
     * @return m[hĎ
     */
    public synchronized NodeWatchInfo popQueue() {
        NodeWatchInfo info = null;

        if (queueList.size() > 0) {
            if (!isPause) {
                info = (NodeWatchInfo) queueList.get(0);
            }

            queueList.remove(0);
        }

        return info;
    }

    /**
     * ftHgSNMP(System/Interface MIB)̎悷CxgL[
     * Ԃ܂B
     *
     * @return queueList ftHgSNMP(System/Interface MIB)̎悷CxgL[
     */
    public List getSnmpConfigQueueList() {
        return queueList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static QueueForDefaultSnmpMib getInstance() {
        return SingletonAboutMessage.QUEUE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonAboutMessage {
        static final QueueForDefaultSnmpMib QUEUE =
            new QueueForDefaultSnmpMib();
    }
}
