/*
 * Created on 2004/05/01
 *
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.ping.ExecutePing;



/**
 * IɃL[`FbNAL[Ƀf[^PingĎs
 * ThreadNXłB
 *
 * @author Yoshimasa matsumoto
 * @version 1.0
 */
public class ThreadQueueCheckPing implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * PingĎsThreadNXCX^X𐶐܂B
     *
     */
    public ThreadQueueCheckPing() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IɃL[`FbNAL[Ƀf[^Pings
     * ܂B
     */
    public void run() {
        // pingsGW
        ExecutePing pingsub = new ExecutePing();

        //IɃL[`FbN[v
        while (!Thread.interrupted()) {
            // PingĎL[Pop
            NodeWatchInfo nodeExecInfo =
                QueueForPing.getInstance().popPingQueue();
            NodeWatchInfo nodeCheckIPAddress = null;

            if (nodeExecInfo != null) {
                nodeCheckIPAddress =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        nodeExecInfo.getIpaddress());
            }

            /*
             * L[Ƀf[^Pings
             */
            if ((nodeExecInfo != null) && (nodeCheckIPAddress != null)) {
                /* Ďm[hIPAhXo */
                String targetIpAddress = nodeExecInfo.getIpaddress();

                /* PingĎ臒l */
                int pingThreshhold =
                    Integer.parseInt(nodeExecInfo.getPingThreshold());

                /* Ďm[hPingsBusy`FbN */
                if (
                    BusyCheckForPing.getInstance().getArbitrationExec(
                            targetIpAddress)) {
                    pingsub.executePing(targetIpAddress, pingThreshhold);
                    BusyCheckForPing.getInstance().release(targetIpAddress);
                } else {
                    logger.warning("Busy Ping IP = " + targetIpAddress);
                }
            }

            nodeExecInfo = null;
            nodeCheckIPAddress = null;

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
