/*
 * Created on 2003/07/21
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.ping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

/**
 * OSŗLPingR}hsāAbZ[WyщԂ 擾܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class PingExcecEngine {
	/** VXevpeB OS */
	public static final String SYSTEM_PROPERTY_OS_NAME = "os.name";

	/** Windows OS */
	public static final String WINDOWS_OS_NAME = "windows";

	/** pingR}h */
	public static final String PING_COMMAND = "ping ";

	/** PingԒP */
	public static final String PING_RESPONSE_TIME_UNIT_MS = "ms";

	/** PingXe[^X */
	public static final int NORMAL = 0;

	/** PingUnreachableXe[^X */
	public static final int UNREACHABLE = 1;

	/** Ping^CAEgXe[^X */
	public static final int TIMEOUT = 2;

	/* MO */
	private static Logger logger = null;

	/** Windows PingR}h퉞R[h */
	public static final String WINDOWS_PING_NORMAL_RESPONSE = "Reply from";

	/** Windows PingR}h unreachableR[h */
	public static final String WINDOWS_PING_UNREACHABLE = "unreachable.";

	/** Windows PingR}h invalid R[h */
	public static final String WINDOWS_PING_SPECIFIED_INVALID = "Destination specified is invalid.";

	/** Linux PingR}h퉞R[h */
	public static final String LINUX_PING_NORMAL_RESPONSE = "bytes from";

	/** Linux PingR}h UunreachableR[h */
	public static final String LINUX_PING_UNREACHABLE = "Uunreachable";

	/** Linux PingR}h filteredR[h */
	public static final String LINUX_PING_UNREACHABLE1 = "filtered";

	private boolean isOSLinux = false;

	/* PingR}hp[^i[ */
	private static String pingParameter;

	/* ^[QbgIP Address */
	private String targetIPAddress;

	/* Ping */
	private static long diffTime;

	private ResourceInfo resourceInfo;

	private int timeOutLinux;

	private int retryLinux;

	/**
	 * pingsNXCX^X𐶐܂B
	 * 
	 */
	public PingExcecEngine(String timeoutMilliSecParam, String retryParam) {
		logger = Logger.getLogger(this.getClass().getName());

		resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();
		String osName = System.getProperty(SYSTEM_PROPERTY_OS_NAME);

		String[] lowerOSName = osName.toLowerCase().split(" ");

		// logger.info("osName : " + osName);

		if ((lowerOSName.length > 1)
				&& (lowerOSName[0].equals(WINDOWS_OS_NAME))) {
			if(timeoutMilliSecParam == null || retryParam == null) {
			pingParameter = " -w " + resourceInfo.getPingTimeout() + " -n "
					+ resourceInfo.getPingRetry() + " ";

			} else {
				pingParameter = " -w " + timeoutMilliSecParam + " -n "
				+ retryParam + " ";	
			}
			isOSLinux = false;
			// logger.info("OS Windows Ping param : " + pingParameter);
		} else {
			if(timeoutMilliSecParam == null || retryParam == null) {
			timeOutLinux = Integer.parseInt(resourceInfo.getPingTimeout());
			retryLinux = Integer.parseInt(resourceInfo.getPingRetry());
			} else {
				timeOutLinux = Integer.parseInt(timeoutMilliSecParam) / 1000;
				retryLinux = Integer.parseInt(retryParam);
			}
			pingParameter = " -w " + timeOutLinux + " -c " + retryLinux + " ";
			isOSLinux = true;
			logger.info("OS Not Windows Ping param : " + pingParameter);
		}
	}

	/**
	 * PingsԂJEg܂B
	 * 
	 * @return result PingsʃtOBPingʂUNREACHABLE܂
	 *         TIMEOUTłȂꍇtrueAȊOfalse
	 */
	public boolean checkPingResponse() {
		boolean isResult = false;
		if (isOSLinux) {
			isResult = pingLinux(targetIPAddress, retryLinux, timeOutLinux);
		} else {
			/*
			 * timeOutLinux = Integer.parseInt(resourceInfo.getPingTimeout());
			 * retryLinux = Integer.parseInt(resourceInfo.getPingRetry());
			 * isResult = pingLinux();
			 */

			isResult = pingWindows(targetIPAddress);
		}
		return isResult;
	}

	private synchronized static boolean pingWindows(String targetIPAddress) {
		/*
		 * PingsʂƂNORMAL/UNREACHABLE/TIMEOUT ̃^Cv
		 */
		int responseType = 0;

		/*
		 * PingsʂƂUNREACHABLE܂TIMEOUTłȂ ꍇtrue
		 */
		boolean resultFlag = false;

		/* PingJnTime */
		long pingTestStartTime = 0;

		/* PingITime */
		long pingTestFinishTime = 0;

		BufferedReader in = null;
		InputStream is = null;
		InputStreamReader ir = null;
		Runtime runTime = null;
		Process process = null;
		try {

			runTime = Runtime.getRuntime();

			pingTestStartTime = System.currentTimeMillis();

			// ping command excute
			process = runTime.exec(PING_COMMAND + pingParameter
					+ targetIPAddress);

			if (process == null) {
				logger.warning("Abort create process");

				return resultFlag;
			}

			is = process.getInputStream();
			ir = new InputStreamReader(is);
			in = new BufferedReader(ir);

			String line;

			while ((line = in.readLine()) != null) {
				if ((line.indexOf(WINDOWS_PING_NORMAL_RESPONSE) >= 0)
						|| (line.indexOf(LINUX_PING_NORMAL_RESPONSE) >= 0)) {
					// System.out.println("Reply from : " + host);
					resultFlag = true;
					responseType = NORMAL;

					break;
				} else if ((line.indexOf(WINDOWS_PING_UNREACHABLE) >= 0)
						|| (line.indexOf(LINUX_PING_UNREACHABLE) >= 0)
						|| (line.indexOf(LINUX_PING_UNREACHABLE1) >= 0)) {
					// logger.info(line);
					responseType = UNREACHABLE;

					break;
				} else {
					// logger.info(line);
					responseType = TIMEOUT;
				}
			}

			pingTestFinishTime = System.currentTimeMillis();

			if (resultFlag) {
				/* Pingɑ΂Đ퉞̏ꍇ */
				diffTime = pingTestFinishTime - pingTestStartTime;
			} else {
				/* Pingɑ΂ĐȉȂꍇ */
				AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
						.getInstance();

				switch (responseType) {
				case UNREACHABLE:
					logger.info("Destination host unreachable. : " + diffTime
							+ PING_RESPONSE_TIME_UNIT_MS);
					alarmMessageMakeInstance
							.setEorrorPingDestinationHostUnreachable(targetIPAddress);

					break;

				case TIMEOUT:
					diffTime = pingTestFinishTime - pingTestStartTime;
					logger.info("Time out error : " + diffTime
							+ PING_RESPONSE_TIME_UNIT_MS);
					alarmMessageMakeInstance
							.setErrorPingTimeout(targetIPAddress);

					break;

				default:
					logger.warning("Ping excecute error");
				}
			}
		} catch (IOException io) {
			logger.warning(io.toString());
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException ex) {
					ex.printStackTrace();
				}
			}

			if (ir != null) {
				try {
					ir.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}

			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}

			if (runTime != null) {
				runTime.gc();
			}

			if (process != null) {
				process.destroy();
			}
		}

		// logger.info("result : " + resultFlag);

		return resultFlag;
	}

	public synchronized static boolean pingLinux(String targetIPAddress,
			int retryLinux, int timeOutLinux) {
		boolean resultFlag = false;
		try {
			long max = 0;
			long min = 0;
			long sum = 0;
			int num = 0;

			InetAddress address = InetAddress.getByName(targetIPAddress);

			int retryCount = 0;
			for (; retryCount < retryLinux; retryCount++) {
				long start = System.currentTimeMillis();

				// Reachability ̃`FbN ICMP gp
				boolean isReachable = address.isReachable(timeOutLinux);

				long end = System.currentTimeMillis();

				if (isReachable) {
					resultFlag = true;
					diffTime = end - start;
					logger
							.info("Reply from " + address.getHostAddress()
									+ ": ");

					sum += diffTime;

					if (retryCount == 0) {
						max = diffTime;
						min = diffTime;
					} else {
						if (diffTime > max) {
							max = diffTime;
						} else if (diffTime < min) {
							min = diffTime;
						}
					}
					num++;

					if (diffTime > 0) {
						logger.info("time=" + diffTime + "ms");
					} else {
						logger.info("time<1ms");
					}
				} else {
					resultFlag = false;
					diffTime = end - start;

					logger.info("Time out error : " + diffTime
							+ PING_RESPONSE_TIME_UNIT_MS + " (set "
							+ timeOutLinux + "ms)");

					if (diffTime >= timeOutLinux) {
						logger.info("Request timed out.");
					} else {
						logger.info("Reply from " + address.getHostAddress()
								+ ": Destination net unreachable.");
						num++;
					}
				}

			}
			if (!resultFlag) {
				/* Pingɑ΂ĐȉȂꍇ */
				AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
						.getInstance();
				alarmMessageMakeInstance.setErrorPingTimeout(targetIPAddress);
			}
			logger
					.info("Ping statistics for " + address.getHostAddress()
							+ ":");
			int lost;
			if (num == 0) {
				lost = 100;
			} else {
				lost = (retryCount - num) * 100 / num;
			}

			logger.info("    Packets: Sent = " + retryCount + ", Received = "
					+ num + ", Lost = " + (retryCount - num) + " (" + lost
					+ "% loss),");

			if (num != 0) {
				logger.info("Approximate round trip times in milli-seconds:");

				long average;
				if (num != 0) {
					average = sum / num;
				} else {
					average = 0;
				}

				logger.info("    Minimum = " + min + "ms, Maximum = " + max
						+ "ms, Average = " + average + "ms");
			}

		} catch (UnknownHostException ex) {
			logger.warning("Unknown host " + targetIPAddress + ".");
		} catch (IOException ex) {
			logger.warning("Network Error Occurred.");
		}

		return resultFlag;
	}

	/**
	 * PingԂԂ܂B
	 * 
	 * @return difftime Ping
	 */
	public long getDifftime() {
		return diffTime;
	}

	/**
	 * ^[QbgIPAhXZbg܂B
	 * 
	 * @param string
	 *            ^[QbgIPAhX
	 */
	public void setTargetIPAddress(String string) {
		targetIPAddress = string;
	}
}
