/*
 * Created on 2003/08/11
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.xmlsocket;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * NCAgXML SocketڑvɂANCAgPʂɐ XbhNXłB
 * NCAgؒf܂ŁA[vɂĐڑԂێ܂B
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class XMLSocketThread extends DataStringDisplay implements Runnable {
	private static final int SLEEP_TIME = 3000;

	private boolean isSocketClient = true;

	/** NCAgɒڑ`FbN邽߂ɑMXML */
	public static final String CONNECT_CHECK = "Connection_Check";

	/** GR[fBOw */
	public static final String ENCODING = "Shift_JIS"; // "UTF-8";

	// public static final String ENCODING = "ISO-8859-1";

	/** Client FlashPolicyt@CRequestXMLLq */
	public static final String POLICY = "policy-file-request";

	/** NULLR[h */
	public static final String NULL_CODE = "\0";

	/** I[R[h */
	public static final String TERMINAL_CODE = NULL_CODE;

	/** Clientւ̉^O */
	public static final String RESP_INFO = "resp_info";

	/** Clientւ̉ */
	public static final String RESP_STR = "resp_str";

	/** ClientEclipse RCPڑł|̃^O */
	public static final String ECLIPSE_RCP = "Eclipse RCP";

	/** Client̉^O */
	public static final String SEND_TEXT = "send_text";

	/** XML SocketXML^O */
	public static final String XML_SOCKET_RESPONSE_TAG = "<" + RESP_INFO + " "
			+ RESP_STR + "=";

	/**
	 * m[h}l[WłClient Flash XMLSocketڑɑM AhX ioIPAhXɖ֌WɑMj
	 */
	public final static String ALL_TARGET = "all";

	// obt@TCY
	private static final int BUFF_LEN = 200;

	/* XMLtH[}bgZbgo̓CX^X */
	private XMLOutputter outputter = new XMLOutputter();

	/* MO */
	private static Logger logger = null;

	/*
	 * Client̑Mf[^':'ŕ̃^[Qbg 'all''CONNECT'܂́A'DISCONNECT'
	 */
	private static final int POSITION_TARGET_ADDRESS_OR_CONNECT_STATUS = 0;

	/* XMLł̈AhXʒu */
	private static final int POSITION_TO_ADDRESS = 1;

	/* XMLłFromAhXʒu */
	private static final int POSITION_FROM_ADDRESS = 2;

	/* XMLł̃bZ[Wʒu */
	private static final int POSITION_MESSAGE = 3;

	/* Clientւ̉GR[tO */
	private static final boolean IS_ECHO_RESPONSE = false;

	/* ClientƂ̐ڑTHread */
	private Thread thisThread;

	/* XML Socket */
	private Socket xmlSocket;

	/* OutputStreamWriter */
	private OutputStreamWriter osw;

	/* Client IPAhX */
	private String remoteip;

	/* socket̓ǂݏoXg[ */
	private InputStream xmlSocketInStream;

	/**
	 * NCAg̐ڑvɂ萶Socketp[^ƂāANCAgւ
	 * CxgPUSHʒm邽߂̃CX^X𐶐܂B<BR>
	 * 
	 * CX^Xɂ킹ēo̓Xg[𐶐܂B<BR>
	 * 
	 * @param socket
	 *            SocketCX^X
	 * @throws IOException
	 *             InputStream擾Ɏsꍇ
	 */
	protected XMLSocketThread(final Socket socket) throws IOException {
		super();
		logger = Logger.getLogger(this.getClass().getName());

		xmlSocket = socket;

		xmlSocketInStream = xmlSocket.getInputStream();
		setXMLOutputterFormat();
	}

	/**
	 * NCAgւ̃CxgPUSHʒmp̃XbhJn܂B<BR>
	 * iNCAg̐ڑ҂[vĂ΂܂j<BR>
	 * 
	 * @param remoteIP
	 *            NCAgIPAhX
	 */
	public void startXMLSocketThread(final String remoteIP) {
		this.remoteip = remoteIP;

		thisThread = Thread.currentThread();
		thisThread.setName(thisThread + " : " + remoteIP);

		thisThread = new Thread(this);
		thisThread.setName(thisThread + " : " + remoteIP);

		logger.info("XML Socket thread start : " + thisThread + " Remote IP="
				+ remoteIP + " Port=" + xmlSocket.getPort());

		thisThread.start();
	}

	/**
	 * NCAgւ̃CxgPUSHʒmp̃XbhłB<BR>
	 * ؒf܂Ŗ[vœ삵܂B
	 * 
	 * 
	 */
	public void run() {
		Thread curThread = Thread.currentThread();
		curThread.setName(curThread + " : " + remoteip);

		try {
			this.pushEventtoClient();
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (osw != null) {
				try {
					osw.close();
					osw = null;
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}

			if (xmlSocketInStream != null) {
				try {
					xmlSocketInStream.close();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}

				xmlSocketInStream = null;
			}

			if (xmlSocket != null) {
				try {
					xmlSocket.close();
					xmlSocket = null;
				} catch (IOException e1) {
					logger.warning(e1.getMessage());
					e1.printStackTrace();
				}
			}
		}
	}

	/*
	 * XMLSocketڑNCAgPʂ̃Cxgi[L[𐶐 AL[ɗ܂ĂCxgNCAgXMLSocket
	 * đM܂B<BR>
	 * 
	 * NCAgؒf܂Ŗ[vœ삷ƂƂɁA NCAg֒IɐڑmFpf[^𑗐MAڑ󋵂
	 * mF܂B́ANCAguEȔIȂǂ\I Ɍo邽߂ɍs܂B
	 * 
	 * @throws FlashPolicyException Flash Policy FileȂꍇ @throws
	 * UnsupportedEncodingException Clientւ̑Mf[^ GR[hɎsꍇ @throws
	 * IOException Flash Policy Fileǂݍ݂Ɉُ킪ꍇ yClientւ̃f[^MɎsꍇ
	 */
	private void pushEventtoClient() throws FlashPolicyException,
			UnsupportedEncodingException, IOException {
		/* XMLSocketڑNCAgPʂ̃Cxgi[L[𐶐 */
		XMLSocketConnectPushQueue pushQueue = XMLSocketConnectPushQueue
				.getInstance();

		/*
		 * NCAgXMLf[^͂IPAhX𒊏o AANCAg̃f[^PolicyvłPocy
		 * NCAgɑMナ^[
		 */
		String targetIPAddress = null;

		try {
			osw = new OutputStreamWriter(xmlSocket.getOutputStream(), ENCODING);

			// osw = new OutputStreamWriter(_socket.getOutputStream(),
			// "Shift_JIS");
			targetIPAddress = this.getReceiveTargetIpAddress();
		} catch (FlashPolicyException e) {
			logger.warning("Abort parse receive data at client IP = "
					+ remoteip + " by FlashPolicyException (" + e.getMessage()
					+ ")");
			e.printStackTrace();
			throw e;
		} catch (UnsupportedEncodingException e) {
			logger.warning("Abort parse receive data at client IP = "
					+ remoteip + " by IOException (" + e.getMessage() + ")");
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			logger.warning("Abort parse receive data at client IP = "
					+ remoteip + " by IOException (" + e.getMessage() + ")");
			e.printStackTrace();
			throw e;
		}

		if (targetIPAddress.equals(POLICY)) {
			logger.info("Policy Request : " + targetIPAddress);

			return;
		}

		/*
		 * ڑNCAgڑԃXgɃZbg
		 */
		String threadName = Thread.currentThread().getName();
		pushQueue.createXMLSocketObject(threadName, remoteip, targetIPAddress);

		/*
		 * NCAgڑJnCxgZbg ڑ̑NCAg֐ڑʒm
		 */
		Date date = Calendar.getInstance().getTime();
		DateFormat dateformat;
		dateformat = DateFormat.getDateTimeInstance();
		pushQueue.addEventToXMLSocketInfoList("CONNECT" + ":" + remoteip
				+ ":    " + dateformat.format(date));

		/*
		 * QueueoXML Socket񂩂NCAgIP AhX܂̓[ho
		 */
		String targetMode = pushQueue.popXMLSocketInfo(threadName)
				.getTargetIpAddress();

		try {
			String popEventData = (String) pushQueue
					.popXMLSocketConnectEvent(threadName);

			while (true) {
				if (popEventData != null) {
					/*
					 * L[ɗ܂ĂCxg͂ăNCAg M
					 */
					parseEvent(popEventData, targetMode);
				}

				popEventData = (String) pushQueue
						.popXMLSocketConnectEvent(threadName);
				Thread.sleep(SLEEP_TIME);

				/*
				 * Client̎Mf[^̗L`FbNA Client̃f[^ꍇɂ͉s
				 */
				this.checkReceiveData();

				/*
				 * NCAgƂ̐ڑԊmF (IClientɃf[^𑗐M邱Ƃɂڑ ԂmF)
				 */
				String str = XML_SOCKET_RESPONSE_TAG + "\'" + CONNECT_CHECK
						+ "\'" + "/>" + TERMINAL_CODE;

				// outputter.output(createDocument(CONNECT_CHECK), osw);
				if (isSocketClient) {
					sendTextResponseFlash(str, osw);
				} else {
					sendResponseSocketRCP(createDocument(CONNECT_CHECK), osw);
				}

			} // while
		} catch (InterruptedException e) {
			logger.warning("Disconnect client IP = " + remoteip
					+ " by InterruptedException (" + e.getMessage() + ")");
		} catch (UnsupportedEncodingException e) {
			logger.warning("Disconnect client IP = " + remoteip
					+ " by UnsupportedEncodingException (" + e.getMessage()
					+ ")");
		} catch (SocketException e) {
			logger.info("Disconnect client IP = " + remoteip
					+ " by SocketException (" + e.getMessage() + ")");
		} catch (IOException e) {
			logger.info("Disconnect client IP = " + remoteip
					+ " by IOException (" + e.getMessage() + ")");
		} catch (Exception e) {
			logger.warning("Disconnect client IP = " + remoteip
					+ " by  Exception (" + e.getMessage() + ")");
		} finally {
			/*
			 * ClientؒfCxgZbg
			 */
			date = Calendar.getInstance().getTime();
			dateformat = DateFormat.getDateTimeInstance();
			pushQueue.addEventToXMLSocketInfoList("DISCONNECT" + ":" + remoteip
					+ ":    " + dateformat.format(date));
			pushQueue.dellThreadKeyInXMLSocketInfoMap(threadName);
		}
	}

	/*
	 * Queueɗ܂ĂEventǂݏoAEventR~jP[V
	 * pA[ʒmpA܂悪SClientClientĂ ʂClientɑM܂B
	 * 
	 * @param popEventData Cxg @param mode [h @throws IOException
	 * f[^MɈُ킪ꍇ
	 */
	private void parseEvent(final String popEventData, final String mode)
			throws IOException {
		XMLSocketConnectPushQueue pushQueue = XMLSocketConnectPushQueue
				.getInstance();

		String threadName = Thread.currentThread().getName();
		String[] clientInfo = popEventData.split(":", 4);

		/*
		 * System.out.println("Remote IP : " +
		 * pushQueue.popXMLSocketInfo(threadName).getRemoteIP());
		 * System.out.println("queue : " + popEventData);
		 */

		/* Popf[^A[ʒmR~jP[V */
		if (!clientInfo[0].equals("MAINTENANCE")) {
			/* A[ʒmbZ[W */
			if (mode.equals(ALL_TARGET)
					|| mode
							.equals(clientInfo[POSITION_TARGET_ADDRESS_OR_CONNECT_STATUS])
					|| clientInfo[POSITION_TARGET_ADDRESS_OR_CONNECT_STATUS]
							.equals("CONNECT")
					|| clientInfo[POSITION_TARGET_ADDRESS_OR_CONNECT_STATUS]
							.equals("DISCONNECT")) {
				String str = XML_SOCKET_RESPONSE_TAG + "\'" + popEventData
						+ "\'" + "/>" + TERMINAL_CODE;

				// outputter.output(createDocument(popEventData), osw);
				if (isSocketClient) {
					sendTextResponseFlash(str, osw);
				} else {
					sendResponseSocketRCP(createDocument(popEventData), osw);
				}

			}
		} else {
			/* NCAgԃR~jP[VpbZ[W */
			String remoteIp = pushQueue.popXMLSocketInfo(threadName)
					.getRemoteIP();

			/*
			 * NCAgԃR~jP[VpbZ[W ̈Ɛڑ悪v΃bZ[WM
			 */
			if (mode.equals("MAINTENANCE")
					&& (clientInfo[1].equals(ALL_TARGET) || remoteIp
							.equals(clientInfo[POSITION_TO_ADDRESS]))) {
				/* R~jP[VbZ[WZbg */
				String str = XML_SOCKET_RESPONSE_TAG + "\'" + "To "
						+ clientInfo[POSITION_TO_ADDRESS] + "  From "
						+ clientInfo[POSITION_FROM_ADDRESS] + " : "
						+ clientInfo[POSITION_MESSAGE] + "\'" + "/>"
						+ TERMINAL_CODE;

				if (isSocketClient) {
					sendTextResponseFlash(str, osw);
				}

				logger
						.info("Message Send : "
								+ clientInfo[POSITION_TO_ADDRESS]);

				/* A[ʒm̓NCAg̃o[Xgʒm邽߂Ɉ莞ԃX[v */

				// Thread.sleep(3000);
			} else {
				logger.info("Not Found Address : "
						+ clientInfo[POSITION_TO_ADDRESS]);
			}
		}
	}

	/*
	 * MXMLf[^͂IPAhX𒊏oAԂ܂B AAClientFlash
	 * Policyv̏ꍇɂ́APolicyvText Ԃ܂B
	 * 
	 * @return targetIpAddress m[hIPAhX @throws FlashPolicyException Flash
	 * Policy FileȂꍇ @throws UnsupportedEncodingException Clientւ̑Mf[^
	 * GR[hɎsꍇ @throws IOException Flash Policy Fileǂݍ݂Ɉُ킪ꍇ
	 * yClientւ̃f[^MɎsꍇ
	 */
	private String getReceiveTargetIpAddress() throws FlashPolicyException,
			UnsupportedEncodingException, IOException {
		byte[] buf = new byte[BUFF_LEN];

		String targetIpAddress = ALL_TARGET;

		int len = xmlSocketInStream.read(buf);

		/*
		 * System.out.println(" Buffer Receive Data : " + hexBytetoString(buf,
		 * len));
		 * 
		 * System.out.println(" Buffer Receive Data : " + bytetoChar(buf));
		 */

		InputStream inbuff = new ByteArrayInputStream(buf, 0, len - 1);

		// XMLf[^IPAhX𒊏o
		targetIpAddress = this.parseReceiveXMLData(inbuff, false);

		// System.out.println(targetIpAddress);

		return targetIpAddress;
	}

	/**
	 * SocketMf[^ǂݍXMLf[^͂܂B
	 * 
	 * ǂݍ񂾕͍ŏI#0tĂ̂ŁAKvB Mf[^ȂΉɃ^[
	 * Mf[^΁AXMLf[^͂
	 * 
	 * @throws FlashPolicyException
	 *             Flash Policy FileȂꍇ
	 * @throws UnsupportedEncodingException
	 *             Clientւ̑Mf[^ GR[hɎsꍇ
	 * @throws IOException
	 *             Flash Policy Fileǂݍ݂Ɉُ킪ꍇ yClientւ̃f[^MɎsꍇ
	 */
	protected void checkReceiveData() throws FlashPolicyException,
			UnsupportedEncodingException, IOException {
		try {
			byte[] buf = new byte[BUFF_LEN];

			/*
			 * readŃubNOɎMǂݎf[^0Byte łreturn
			 */
			if (xmlSocketInStream.available() < 1) {
				return;
			}

			/* ǂݍ񂾕͍ŏI#0tĂ̂ŁA */
			int len = xmlSocketInStream.read(buf);
			InputStream inbuff = new ByteArrayInputStream(buf, 0, len - 1);

			/* MXMLf[^ */
			String recData = this.parseReceiveXMLData(inbuff, true);

			if (recData.equals(POLICY)) {
				logger.warning("Illegal request client Flash Policy");

				return;
			}
		} catch (UnsupportedEncodingException ex) {
			logger.warning("UnsupportedEncodingException : " + ex.getMessage());
			throw ex;
		} catch (IOException ex) {
			logger.warning("Error client message : " + ex.getMessage());
			throw ex;
		}
	}

	/*
	 * ̓Xg[MXML͂܂B ClientFlash Policyv̏ꍇ́APolicyvText Ԃ܂B
	 * PolicyvłȂꍇɂ́AbZ[W񑮐𒊏o ̕Ԃ܂B
	 * 
	 * ܂AMf[^ȉ̏ꍇɂ́AڑNCAgփf[^ M܂B EA[eXgp E`bgp
	 * 
	 * @param inbuff InputStream
	 * 
	 * @param isResponse ClientɉԂۂtO true : ClientɉԂȂ false :
	 * ClientɉԂ
	 * 
	 * @return filterDate ClientFlash Policyv̏ꍇ́A
	 * PolicyvTextԂAPolicyvłȂꍇɂ́AbZ[W 񑮐𒊏o
	 * 
	 * @throws FlashPolicyException Flash Policy FileȂꍇ @throws
	 * UnsupportedEncodingException Clientւ̑Mf[^ GR[hɎsꍇ @throws
	 * IOException Flash Policy Fileǂݍ݂Ɉُ킪ꍇ yClientւ̃f[^MɎsꍇ
	 */
	private String parseReceiveXMLData(final InputStream inbuff,
			final boolean isResponse) throws FlashPolicyException,
			UnsupportedEncodingException, IOException {
		Document doc = null;

		try {
			SAXBuilder builder = new SAXBuilder();

			// doc = builder.build(inbuff, ENCODING);
			doc = builder.build(inbuff);
		} catch (UTFDataFormatException e) {
			// UTFGR[fBOɎs
			logger.warning(e.getMessage());
			e.printStackTrace();

			return null;
		} catch (JDOMException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (NullPointerException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (IOException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}

		// rootvfo
		Element root = doc.getRootElement();

		/*
		 * FlashNCAgXMLSocket Policyv̏ꍇ́A Policy
		 */
		if (root.getName().equals(POLICY)) {
			this.sendFlashXMLSocketPolicy();

			return POLICY;
		}

		String filterDate = root.getAttributeValue(SEND_TEXT);

		/* ڑJn͉ԂȂ */
		if (isResponse) {
			this.sendResponse(filterDate);
		}

		Date date = Calendar.getInstance().getTime();
		DateFormat dateformat;
		dateformat = DateFormat.getDateTimeInstance();

		String[] receiveItem = filterDate.split(":", 3);

		/* NCAgւ̒ʒmpL[ւ̃bZ[Wi[ */
		if (receiveItem.length > 1) {
			/*
			 * NCAg̑MXMLbZ[WƂẮA ȉ̂Q킪AꂼɃbZ[W𐶐
			 * 
			 * EA[ʒmp : IP Address: Date: Message` ENCAgԂ̃R~jP[Vp : IP
			 * Address: Date: Message`
			 * 
			 * "MAINTENANCE"̓NCAgԃR~jP[V iʐMjJn̐ڑbZ[Wɕt^
			 * 
			 */
			if (!receiveItem[0].equals("MAINTENANCE")) {
				// A[eXgp̃bZ[W

				/* XML SocketʒmA[L[Ɋi[ */
				XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue
						.getInstance();

				/* IP Address: Date: Message` */
				pushqueue.addEventToXMLSocketInfoList(receiveItem[0] + ": "
						+ dateformat.format(date) + ": " + receiveItem[1]);
			} else {
				// NCAgԂ̃R~jP[ViʐMjp̃bZ[W

				/* XML SocketʒmA[L[Ɋi[ */
				XMLSocketConnectPushQueue pushqueue = XMLSocketConnectPushQueue
						.getInstance();

				/* IP Address: Date: Message` */
				pushqueue.addEventToXMLSocketInfoList(receiveItem[0] + ":"
						+ receiveItem[1] + ":" + remoteip + ": "
						+ dateformat.format(date) + ": " + receiveItem[2]);
			}
		}

		if (filterDate.equals(ECLIPSE_RCP)) {
			filterDate = ALL_TARGET;
			isSocketClient = false;
		}
		return filterDate;
	}

	/*
	 * NCAg։f[^𑗐M܂B
	 * 
	 * @param str Clientւ̃GR[M @throws UnsupportedEncodingException
	 * MGR[hɎsꍇ @throws IOException MɎsꍇ
	 */
	private void sendResponse(final String str)
			throws UnsupportedEncodingException, IOException {
		String resData = "";

		if (IS_ECHO_RESPONSE) {
			resData = str;
		}

		String responseData = XML_SOCKET_RESPONSE_TAG + "\""
				+ resData.replace('"', '\'') + "\" />" + TERMINAL_CODE;
		String resDataConvert = resData.replace('"', '\'');
		if (IS_ECHO_RESPONSE) {
			logger.info("response send : " + responseData);
		}

		try {
			// outputter.output(createDocument(test), osw);
			if (isSocketClient) {
				sendTextResponseFlash(responseData, osw);
			} else {
				sendResponseSocketRCP(createDocument(resDataConvert), osw);
			}

		} catch (UnsupportedEncodingException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();

			throw e;
		} catch (IOException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();

			throw e;
		}
	}

	/**
	 * NCAgXMLFlash XMLSocket Policyv̏ꍇ Policy郁\bhłB Flash
	 * PolicyLqXMLt@CǂݍŁAClientɑM ܂B
	 * 
	 * @throws FlashPolicyException
	 *             Flash Policy FileȂꍇ
	 * @throws UnsupportedEncodingException
	 *             Clientւ̑Mf[^ GR[hɎsꍇ
	 * @throws IOException
	 *             Flash Policy Fileǂݍ݂Ɉُ킪ꍇ yClientւ̃f[^MɎsꍇ
	 */
	private void sendFlashXMLSocketPolicy() throws FlashPolicyException,
			UnsupportedEncodingException, IOException {
		/* Flash policyt@Cǂݍ */
		File policyFlie = new File(FilePreference.FLASH_XMLSOCKET_POLICY_FILE);
		BufferedReader buffReader = null;

		if (policyFlie == null) {
			throw new FlashPolicyException("Not found Flash Policy : "
					+ FilePreference.FLASH_XMLSOCKET_POLICY_FILE);
		}

		try {
			FileReader fileReader = new FileReader(
					FilePreference.FLASH_XMLSOCKET_POLICY_FILE);
			buffReader = new BufferedReader(fileReader);
		} catch (FileNotFoundException e1) {
			logger.warning(e1.getMessage() + "Path : "
					+ policyFlie.getAbsolutePath());
			throw new FlashPolicyException("FileNotFoundException : "
					+ FilePreference.FLASH_XMLSOCKET_POLICY_FILE + " : "
					+ e1.getMessage());
		}

		char[] charBuff = new char[BUFF_LEN];

		try {
			buffReader.read(charBuff);
		} catch (IOException e1) {
			logger.warning(e1.getMessage() + " File path : "
					+ policyFlie.getAbsolutePath());
			e1.printStackTrace();

			throw new FlashPolicyException("IOException : "
					+ FilePreference.FLASH_XMLSOCKET_POLICY_FILE + " : "
					+ e1.getMessage());
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e3) {
					logger.warning(e3.getMessage());
					e3.printStackTrace();
				}
			}
		}

		try {
			/* ClienFlash Polcy𑗐M */
			if (isSocketClient) {
				sendCharResponseFlash(charBuff, osw);
			}

			logger.info("Response Flash XMLSocket Policy");
		} catch (UnsupportedEncodingException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
			throw e;
		}
	}

	public Document createDocument(String value) {
		Element confElement = new Element(RESP_INFO);
		Document doc = new Document(confElement);
		confElement.setAttribute(RESP_STR, value);
		return doc;
	}

	private void sendResponseSocketRCP(Document doc, OutputStreamWriter osw)
			throws IOException {

		/*
		 * outputter.output(doc, osw); osw.write(TERMINAL_CODE); osw.flush();
		 */
		String sendText = outputter.outputString(doc) + TERMINAL_CODE;
		osw.write(sendText);
		osw.flush();
	}

	private void sendTextResponseFlash(String sendText, OutputStreamWriter osw)
			throws IOException {

		osw.write(sendText);
		osw.flush();
	}

	private void sendCharResponseFlash(char[] charBuff, OutputStreamWriter osw)
			throws IOException {

		osw.write(charBuff);
		osw.flush();
	}

	/*
	 * XMLo̓tH[}bgpCX^X𐶐܂B
	 */
	private void setXMLOutputterFormat() {

		/*
		 * qGgeGg2wAGg ̉sw͂ȂiXMLt@CŌXsĂ邽߁j
		 */

		// XMLOutputter outputter = new XMLOutputter(" ", true);
		Format format = outputter.getFormat();
		format.setEncoding("UTF-8");
		format.setLineSeparator(System.getProperty("line.separator"));
		format.setIndent("  ");
		outputter.setFormat(format);
	}

	/**
	 * XML SocketN[Y܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (xmlSocket != null) {
			try {
				xmlSocket.close();
				xmlSocket = null;
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}
		}
	}

}
