/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.engine.model.action.ActionBuilderDatabase;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.server.taskschedule.TaskScheduleControl;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;



/**
 * GWXPW[\ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineScheduleView extends ViewPart {
    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 700, 400 };

    /* {^ */
    private static final int BUTTON_WIDTH = 150;

    /* {^ */
    private static final int BUTTON_HEIGHT = 20;

    /* List */
    private static final int LIST_WIDTHHINT = 300;

    /* MO */
    private static Logger logger;

    /* ^XNXPW[Xg\[gpList */
    private static java.util.List taskScheduleSortList =
        Collections.synchronizedList(new LinkedList());

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /* XV{^ */
    private Button refreshButton;

    /* \[g{^ */
    private Button sortButton;

    /* LZ{^ */
    private Button cancelButton;

    /* Zbg{^ */
    private Button setButton;

    /* XPW[\List */
    private List scheduleList;

    /* ^XNXPW[ JnN */
    private Text alarmStartYearText;

    /* ^XNXPW[ Jn */
    private Text alarmStartMonthText;

    /* ^XNXPW[ Jn */
    private Text alarmStartDateText;

    /* ^XNXPW[ IN */
    private Text alarmEndYearText;

    /* ^XNXPW[ I */
    private Text alarmEndMonthText;

    /* ^XNXPW[ I */
    private Text alarmEndDateText;

    /* ^XNXPW[ */
    private Combo startHourCombo;

    /* ^XNXPW[ */
    private Combo startMinuteCombo;

    /* ^XNXPW[ */
    private Combo endHourCombo;

    /* ^XNXPW[ */
    private Combo endMinuteCombo;

    /* JneLXg琶Date */
    private Date setStartDate;

    /* IeLXg琶Date */
    private Date setEndDate;

    /* XPW[\tH[}bg */
    private DateFormat dateformat;

    /* ^XNXPW[Xg */
    private boolean isSortDirection = true;

    /*
     * GWANV
     */
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();

    /* EditorPartANV */
    private ActionBuilderEditorsPartClose actionBuilderEditorPart =
        new ActionBuilderEditorsPartClose();

    /*
     * f[^x[XANV
     */
    private ActionBuilderDatabase actionBuilderDatabase =
        new ActionBuilderDatabase();

    /**
     * GWXPW[ViewNXCX^X𐶐܂B
     *
     */
    public EngineScheduleView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");

        fillActionBars();

        setStatusLine();

        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(2, true);
        Composite baseComposite = new Composite(scrollComposite, SWT.NONE);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(new GridData());

        GridLayout gridLayoutListComp = new GridLayout(1, false);
        Composite compositeList = new Composite(baseComposite, SWT.NULL);
        compositeList.setLayout(gridLayoutListComp);
        compositeList.setLayoutData(
            new GridData(
                GridData.HORIZONTAL_ALIGN_BEGINNING
                | GridData.VERTICAL_ALIGN_BEGINNING));

        GridLayout gridLayoutOperation = new GridLayout(1, false);
        Composite compositeOperation = new Composite(baseComposite, SWT.NULL);
        compositeOperation.setLayout(gridLayoutOperation);
        compositeOperation.setLayoutData(new GridData());

        GridLayout gridLayoutButtonComp = new GridLayout(1, false);
        Composite compositeButton = new Composite(compositeOperation, SWT.NULL);
        compositeButton.setLayout(gridLayoutButtonComp);
        compositeButton.setLayoutData(new GridData());

        GridLayout gridLayoutDateTextComp = new GridLayout(9, false);
        Composite compositeDateText =
            new Composite(compositeOperation, SWT.NULL);
        compositeDateText.setLayout(gridLayoutDateTextComp);
        compositeDateText.setLayoutData(new GridData());

        GridLayout gridLayoutCalendar = new GridLayout(1, false);
        Composite compositeCalendar =
            new Composite(compositeOperation, SWT.NONE);
        compositeCalendar.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        compositeCalendar.setLayout(gridLayoutCalendar);

        /*
         * XPW[\Xg
         */
        scheduleList =
            new List(
                compositeList,
                SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);

        // GridData data = new GridData(GridData.FILL_BOTH);
        GridData data =
            new GridData(
                GridData.VERTICAL_ALIGN_BEGINNING
                | GridData.HORIZONTAL_ALIGN_BEGINNING);
        data.horizontalSpan = 1; // Xp
        data.verticalSpan = 10; // Xp
        data.widthHint = LIST_WIDTHHINT;
        data.heightHint = scheduleList.getItemHeight() * 20;
        scheduleList.setLayoutData(data);

        refreshButton = new Button(compositeButton, SWT.NONE);
        refreshButton.setText(" Refresh");
        refreshButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        refreshButton.setLayoutData(gridData);

        sortButton = new Button(compositeButton, SWT.NONE);
        sortButton.setText(" Sort    ");
        sortButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        sortButton.setLayoutData(gridData);

        cancelButton = new Button(compositeButton, SWT.NONE);

        cancelButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
        cancelButton.setText(" Cancel ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        cancelButton.setLayoutData(gridData);

        setButton = new Button(compositeButton, SWT.NONE);

        setButton.setSize(BUTTON_WIDTH, BUTTON_HEIGHT);
        setButton.setText(" Set     ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        setButton.setLayoutData(gridData);

        alarmStartYearText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        alarmStartYearText.setLayoutData(gridData);

        Label label = new Label(compositeDateText, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        alarmStartMonthText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        alarmStartMonthText.setLayoutData(gridData);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        alarmStartDateText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        alarmStartDateText.setLayoutData(gridData);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        startHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        startHourCombo.setLayoutData(gridData);
        setHourCombo(startHourCombo);
        startHourCombo.select(0);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        startMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        startMinuteCombo.setLayoutData(gridData);
        setMinuteCombo(startMinuteCombo);
        startMinuteCombo.select(0);

        alarmEndYearText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        alarmEndYearText.setLayoutData(gridData);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        alarmEndMonthText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        alarmEndMonthText.setLayoutData(gridData);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        alarmEndDateText = new Text(compositeDateText, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        alarmEndDateText.setLayoutData(gridData);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        endHourCombo = new Combo(compositeDateText, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        endHourCombo.setLayoutData(gridData);
        setHourCombo(endHourCombo);
        endHourCombo.select(23);

        label = new Label(compositeDateText, SWT.NONE);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        endMinuteCombo = new Combo(compositeDateText, SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        endMinuteCombo.setLayoutData(gridData);
        setMinuteCombo(endMinuteCombo);
        endMinuteCombo.select(59);

        CalendarComposite calendarComposite = new CalendarComposite();
        calendarComposite.setYearText(alarmStartYearText);
        calendarComposite.setMonthText(alarmStartMonthText);
        calendarComposite.setDateText(alarmStartDateText);
        calendarComposite.setEndYearText(alarmEndYearText);
        calendarComposite.setEndMonthText(alarmEndMonthText);
        calendarComposite.setEndDateText(alarmEndDateText);

        calendarComposite.createCalendarView(compositeCalendar);

        alarmStartYearText.setText(
            calendarComposite.getCalendarTable().getTodaysYY());
        alarmStartMonthText.setText(
            calendarComposite.getCalendarTable().getTodaysMM());
        alarmStartDateText.setText(
            calendarComposite.getCalendarTable().getTodaysDD());

        alarmEndYearText.setText(
            calendarComposite.getCalendarTable().getTodaysYY());
        alarmEndMonthText.setText(
            calendarComposite.getCalendarTable().getTodaysMM());
        alarmEndDateText.setText(
            calendarComposite.getCalendarTable().getTodaysDD());

        /*
         * Scroll compositeZbg
         */
        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * XV{^Listener
         */
        refreshButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    logger = Logger.getLogger(this.getClass().getName());

                    refreshButton.setEnabled(false);
                    getTaskSchedule();
                    refreshButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * XPW[Zbg{^Listener
         */
        setButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    setButton.setEnabled(false);

                    getSelectDate();

                    if (
                        !MessageDialog.openQuestion(
                                getSite().getShell(), "Task Set Confirm",
                                "Set  " + dateformat.format(setStartDate)
                                + " - " + dateformat.format(setEndDate) + " ?")) {
                        setButton.setEnabled(true);

                        return;
                    }

                    setTaskSchedule();
                    getTaskSchedule();
                    setButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * XPW[LZ{^Listener
         */
        cancelButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    cancelButton.setEnabled(false);

                    int selectListIndex = scheduleList.getSelectionIndex();

                    if (selectListIndex >= 0) {
                        TaskScheduleInfo taskInfo =
                            (TaskScheduleInfo) taskScheduleSortList.get(
                                selectListIndex);

                        if (taskInfo != null) {
                            /*
                             * LZmF_CAO
                             */
                            if (
                                !MessageDialog.openQuestion(
                                        getSite().getShell(),
                                        "Task Cancel Confirm",
                                        "Cancel  "
                                        + dateformat.format(
                                            taskInfo.getTaskStartDate())
                                        + " - "
                                        + dateformat.format(
                                            taskInfo.getTaskEndDate()) + " ?")) {
                                cancelButton.setEnabled(true);

                                return;
                            }

                            taskInfo.setTaskID(
                                Integer.toString(selectListIndex));

                            cancelTaskSchedule(taskInfo);
                            getTaskSchedule();
                        }
                    }

                    cancelButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * XPW[\[g{^Listener
         */
        sortButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    sortButton.setEnabled(false);

                    /* \[g] */
                    if (isSortDirection) {
                        isSortDirection = false;
                    } else {
                        isSortDirection = true;
                    }

                    getTaskSchedule();
                    sortButton.setEnabled(true);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        getTaskSchedule();
    }

    /*
     * Hour Combo Boxݒ肵܂B
     *
     */
    private void setHourCombo(Combo combo) {
        for (int i = 0; i < 24; i++) {
            String work = Integer.toString(i);

            if (work.length() == 1) {
                work = "0" + work;
            }

            combo.add(work);
        }
    }

    /*
     * Minute Combo Boxݒ肵܂B
     *
     * @param combo Combo
     */
    private void setMinuteCombo(Combo combo) {
        for (int i = 0; i < 60; i++) {
            String work = Integer.toString(i);

            if (work.length() == 1) {
                work = "0" + work;
            }

            combo.add(work);
        }
    }

    /*
     * ^XNXPW[[h܂B
     *
     */
    private void getTaskSchedule() {
        scheduleList.removeAll();
        taskScheduleSortList.clear();

        Map taskSchduleList =
            TaskScheduleControl.getInstance().getTaskSchedule();

        int count = 0;

        for (Iterator it = taskSchduleList.keySet().iterator(); it.hasNext();) {
            String keyId = (String) it.next();

            TaskScheduleInfo info =
                (TaskScheduleInfo) taskSchduleList.get(keyId);

            taskScheduleSortList.add(count, info);
            count++;
        }

        /*
         * ^XNXPW[List\[g
         */
        Collections.sort(
            taskScheduleSortList,
            new Comparator() {
                public int compare(Object o1, Object o2) {
                    Date startData = ((TaskScheduleInfo) o1).getTaskStartDate();
                    Date startDate2 =
                        ((TaskScheduleInfo) o2).getTaskStartDate();

                    if (isSortDirection) {
                        return startDate2.compareTo(startData);
                    }

                    return startData.compareTo(startDate2);
                }
            });

        for (int i = 0; i < taskScheduleSortList.size(); i++) {
            TaskScheduleInfo info =
                (TaskScheduleInfo) taskScheduleSortList.get(i);

            scheduleList.add(
                dateformat.format(info.getTaskStartDate()) + " - "
                + dateformat.format(info.getTaskEndDate()));
        }
    }

    /*
     * ^XNXPW[Zbg܂B
     */
    private void setTaskSchedule() {
        /*
         * eLXg̓f[^^XNXPW[Jn/I
         * 쐬
         */
        getSelectDate();

        /*
         * Jn̏ꍇ́AAlert\
         */
        Map taskSchduleList =
            TaskScheduleControl.getInstance().getTaskSchedule();

        for (Iterator it = taskSchduleList.keySet().iterator(); it.hasNext();) {
            String keyId = (String) it.next();

            TaskScheduleInfo info =
                (TaskScheduleInfo) taskSchduleList.get(keyId);

            if (
                dateformat.format(setStartDate).equals(
                        dateformat.format(info.getTaskStartDate()))) {
                MessageDialog.openError(
                    getSite().getShell(), "Error",
                    "Already Start Date " + dateformat.format(setStartDate)
                    + "  !");

                return;
            }
        }

        if (setStartDate.getTime() >= setEndDate.getTime()) {
            MessageDialog.openError(
                getSite().getShell(), "Error",
                "Start " + dateformat.format(setStartDate) + " >= " + "End "
                + dateformat.format(setEndDate) + "  !");

            return;
        }

        if (
            setStartDate.getTime() <= Calendar.getInstance().getTime().getTime()) {
            MessageDialog.openError(
                getSite().getShell(), "Error",
                "Start " + dateformat.format(setStartDate) + " <= " + "Now "
                + dateformat.format(setEndDate) + "  !");

            return;
        }

        TaskScheduleControl.getInstance().setTaskSchedule(
            setStartDate, setEndDate);
    }

    /*
     * eLXg̓f[^XPW[Jn/I
     * ܂B
     */
    private void getSelectDate() {
        int indexStartHH = startHourCombo.getSelectionIndex();
        int indexStartMin = startMinuteCombo.getSelectionIndex();
        int indexEndHH = endHourCombo.getSelectionIndex();
        int indexEndMin = endMinuteCombo.getSelectionIndex();

        int startYY = 0;

        try {
            startYY = Integer.parseInt(alarmStartYearText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmStartYearText.setFocus();

            return;
        }

        int startMM = 0;

        try {
            startMM = Integer.parseInt(alarmStartMonthText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmStartMonthText.setFocus();

            return;
        }

        int startDD = 0;

        try {
            startDD = Integer.parseInt(alarmStartDateText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmStartDateText.setFocus();

            return;
        }

        int startHH = 0;

        try {
            startHH = Integer.parseInt(startHourCombo.getItem(indexStartHH));
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            startHourCombo.setFocus();

            return;
        }

        int startMIN = 0;

        try {
            startMIN =
                Integer.parseInt(startMinuteCombo.getItem(indexStartMin));
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            startMinuteCombo.setFocus();

            return;
        }

        int endYY = 0;

        try {
            endYY = Integer.parseInt(alarmEndYearText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmEndYearText.setFocus();

            return;
        }

        int endMM = 0;

        try {
            endMM = Integer.parseInt(alarmEndMonthText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmEndMonthText.setFocus();

            return;
        }

        int endDD = 0;

        try {
            endDD = Integer.parseInt(alarmEndDateText.getText());
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            alarmEndDateText.setFocus();

            return;
        }

        int endHH = 0;

        try {
            endHH = Integer.parseInt(endHourCombo.getItem(indexEndHH));
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            endHourCombo.setFocus();

            return;
        }

        int endMIN = 0;

        try {
            endMIN = Integer.parseInt(endMinuteCombo.getItem(indexEndMin));
        } catch (NumberFormatException e) {
            MessageDialog.openError(
                getSite().getShell(), "Error", "Illegal Date " + " !");
            endMinuteCombo.setFocus();

            return;
        }

        /* Jn */
        Calendar cal = Calendar.getInstance();
        cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
        setStartDate = cal.getTime();

        /* I */
        cal.set(endYY, endMM - 1, endDD, endHH, endMIN, 0);
        setEndDate = cal.getTime();
    }

    /*
     * ^XNXPW[LZ܂B
     *
     */
    private void cancelTaskSchedule(TaskScheduleInfo taskInfo) {
        String taskId = Integer.toString(taskInfo.getId());
        logger.info("Cancel Task Id : " + taskId);

        // Timer Cancel
        if ((taskInfo != null) && (taskInfo.getTaskTimer() != null)) {
            taskInfo.setTaskID(taskId);
            TaskScheduleControl.getInstance().cancelTaskSchedule(taskInfo);
            taskScheduleSortList.remove(taskId);
        }
    }

    /**
     * tH[JXZbgꂽ̏łB
     */
    public void setFocus() {
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC\ */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(false);
    }

    /*
     * GW֘AANVr_[Ԃ܂B
     *
     * @return actionBuilderEngine
     */
    private ActionBuilderEngine getEngineActionBuilder() {
        return actionBuilderEngine;
    }

    /*
     * f[^x[X֘AANVr_[Ԃ܂B
     *
     * @return actionBuilderDatabase
     */
    private ActionBuilderDatabase getDatabaseActionBuilder() {
        return actionBuilderDatabase;
    }

    /*
     * ActionBarsZbg܂B
     *
     */
    private void fillActionBars() {
        IActionBars actionBars = getViewSite().getActionBars();

        /* Engine ToolBarZbg */
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(getEngineActionBuilder().getActionStartEngine());
        toolBar.add(getEngineActionBuilder().getActionStopEngine());

        /* EditorPart CloseANV */
        toolBar.add(actionBuilderEditorPart.actionCloseAllEditors());

        IMenuManager menu = actionBars.getMenuManager();

        menu.add(getDatabaseActionBuilder().getActionStartHSQLDB());
        menu.add(getDatabaseActionBuilder().getActionStopHSQLDB());

        menu.add(new Separator());

        IMenuManager databaseSubMenu = new MenuManager("HSQLDB Manager"); //$NON-NLS-1$

        menu.add(databaseSubMenu);
        databaseSubMenu.add(
            getDatabaseActionBuilder().getActionStartHSQLDBManager());
        databaseSubMenu.add(
            getDatabaseActionBuilder().getActionStopHSQLDBManager());

        menu.add(new Separator());
        menu.add(getDatabaseActionBuilder().getActionStartDatabase());
    }
}
